/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.model;

import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.pde.api.tools.internal.model.ApiBaseline;
import org.eclipse.pde.api.tools.internal.model.BundleApiComponent;
import org.eclipse.pde.api.tools.internal.model.PluginProjectApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiBaseline;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;

public class ApiModelFactory {
    private static long fNextId = 0L;

    private static long getBundleID() {
        return fNextId++;
    }

    public static IApiComponent newApiComponent(IApiBaseline profile, String location) throws CoreException {
        BundleApiComponent component = new BundleApiComponent(profile, location);
        if (component.isValidBundle()) {
            component.init(ApiModelFactory.getBundleID());
            return component;
        }
        return null;
    }

    public static IApiComponent newApiComponent(IApiBaseline profile, IPluginModelBase model) throws CoreException {
        BundleDescription bundleDescription = model.getBundleDescription();
        if (bundleDescription == null) {
            return null;
        }
        String location = bundleDescription.getLocation();
        if (location == null) {
            return null;
        }
        BundleApiComponent component = null;
        IPluginModelBase model2 = ApiModelFactory.getProjectModel(location);
        component = model2 != null && model == model2 ? (ApiModelFactory.isBinaryProject(location) ? new BundleApiComponent(profile, location) : new PluginProjectApiComponent(profile, location, model)) : new BundleApiComponent(profile, location);
        if (component.isValidBundle()) {
            component.init(ApiModelFactory.getBundleID());
            return component;
        }
        return null;
    }

    private static IPluginModelBase getProjectModel(String location) {
        String projectName = new Path(location).lastSegment();
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (project != null) {
            return PluginRegistry.findModel((IProject)project);
        }
        return null;
    }

    private static boolean isBinaryProject(String location) throws CoreException {
        Path path = new Path(location);
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(path.lastSegment());
        return project != null && Util.isBinaryProject(project);
    }

    public static IApiBaseline newApiBaseline(String name) {
        return new ApiBaseline(name);
    }

    public static IApiBaseline newApiBaseline(String name, File eeDescription) throws CoreException {
        return new ApiBaseline(name, eeDescription);
    }

    public static IApiBaseline newApiBaseline(String name, String location) throws CoreException {
        return new ApiBaseline(name, null, location);
    }

    public static IApiBaseline newApiBaseline(String name, File eeDescription, String location) throws CoreException {
        return new ApiBaseline(name, eeDescription, location);
    }
}

