/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.util.swing.calendar;

import com.isencia.util.swing.calendar.JCalendar;
import com.isencia.util.swing.layout.AbsoluteConstraints;
import com.isencia.util.swing.layout.AbsoluteLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;

public class DateSelector
extends JPanel
implements PropertyChangeListener {
    private JCalendar calendarPanel;
    private JTextField txtDateField;
    private Calendar calendar;
    private Calendar oldCalendar;
    private JButton btnDateVisible;
    private SimpleDateFormat formatter = null;
    private JPopupMenu popup = null;

    public void init() {
        this.setLayout(new BorderLayout());
        this.calendarPanel = new JCalendar();
        this.btnDateVisible = new JButton();
        this.txtDateField = new JTextField();
        this.txtDateField.setEditable(false);
        this.setLayout(new AbsoluteLayout());
        this.btnDateVisible.setText("...");
        this.btnDateVisible.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DateSelector.this.setPanelVisibility(actionEvent);
            }
        });
        this.add((Component)this.btnDateVisible, new AbsoluteConstraints(110, 0, 30, 20));
        this.add((Component)this.txtDateField, new AbsoluteConstraints(0, 0, 110, 20));
        this.calendarPanel.addPropertyChangeListener(this);
        this.calendarPanel.setBorder(new LineBorder(Color.black));
        this.formatter = new SimpleDateFormat("dd/MM/yyyy");
        this.popup = new JPopupMenu();
    }

    @Override
    public boolean isManagingFocus() {
        return true;
    }

    private void setPanelVisibility(ActionEvent actionEvent) {
        this.oldCalendar = (Calendar)this.calendarPanel.getCalendar().clone();
        this.calendarPanel.setVisible(true);
        this.popup.add(this.calendarPanel);
        this.popup.show(this.txtDateField, 0, 25);
        this.calendarPanel.setSelectedDay();
    }

    public void setDateFormatter(SimpleDateFormat simpleDateFormat) {
        this.formatter = simpleDateFormat;
    }

    public SimpleDateFormat getDateFormatter() {
        return this.formatter;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("calendar")) {
            this.calendar = (Calendar)propertyChangeEvent.getNewValue();
            this.txtDateField.setText(this.formatter.format(this.calendar.getTime()));
        }
        if (propertyChangeEvent.getPropertyName().equals("closeMe")) {
            this.calendar = (Calendar)propertyChangeEvent.getNewValue();
            this.txtDateField.setText(this.formatter.format(this.calendar.getTime()));
            this.calendarPanel.setVisible(false);
            this.popup.setVisible(false);
        }
        if (propertyChangeEvent.getPropertyName().equals("escape")) {
            this.calendar = this.oldCalendar;
            this.txtDateField.setText(this.formatter.format(this.calendar.getTime()));
            this.calendarPanel.setCalendar(this.calendar);
            this.calendarPanel.setVisible(false);
            this.popup.setVisible(false);
        }
    }

    public String getDateAsString() {
        return this.txtDateField.getText();
    }

    public static void main(String[] stringArray) {
        WindowAdapter windowAdapter = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        };
        try {
            JFrame jFrame = new JFrame("JCalendar Demo");
            jFrame.addWindowListener(windowAdapter);
            DateSelector dateSelector = new DateSelector();
            dateSelector.init();
            String string = "02/02/2002";
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy");
            Date date = simpleDateFormat.parse(string);
            dateSelector.setDate(date);
            jFrame.getContentPane().add(dateSelector);
            jFrame.pack();
            jFrame.setVisible(true);
        }
        catch (ParseException parseException) {}
    }

    public void setDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        this.calendarPanel.setCalendar(calendar);
    }

    public Date getDate() {
        Date date = null;
        if (this.calendarPanel != null && this.calendarPanel.getCalendar() != null) {
            date = this.calendarPanel.getCalendar().getTime();
        }
        return date;
    }

    @Override
    public boolean isFocusTraversable() {
        return false;
    }
}

