/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.util;

import java.io.File;
import java.io.FileFilter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ClassPath {
    private String classPath = "";

    public ClassPath(String string) {
        this.classPath = this.buildClassPath(string, new JarZipNameFilter());
    }

    public ClassPath(String string, String string2) {
        this.classPath = this.buildClassPath(string, new RegexpNameFilter(string2));
    }

    public String toString() {
        return this.classPath;
    }

    private String buildClassPath(String string, FileFilter fileFilter) {
        StringBuffer stringBuffer = new StringBuffer();
        File file = new File(string);
        File[] fileArray = file.listFiles(fileFilter);
        if (fileArray == null) {
            return stringBuffer.toString();
        }
        int n = 0;
        while (n < fileArray.length) {
            if (fileArray[n].isDirectory()) {
                stringBuffer.append(this.buildClassPath(fileArray[n].getPath(), fileFilter));
            } else {
                stringBuffer.append("'" + fileArray[n].getPath() + "'" + File.pathSeparator);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    private class JarZipNameFilter
    implements FileFilter {
        private JarZipNameFilter() {
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String string = file.getName();
            if (string == null) {
                return false;
            }
            return (string = string.toLowerCase()).endsWith(".jar") || string.endsWith(".zip");
        }
    }

    private class RegexpNameFilter
    implements FileFilter {
        private Pattern fileNamePattern = null;

        public RegexpNameFilter(String string) {
            this.fileNamePattern = Pattern.compile(string);
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String string = file.getName();
            if (string == null) {
                return false;
            }
            Matcher matcher = this.fileNamePattern.matcher(string);
            return matcher.matches();
        }
    }
}

