/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.util;

import com.isencia.util.BlockingQueue;
import com.isencia.util.EmptyQueueException;
import com.isencia.util.IQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockingWriterQueue
extends BlockingQueue {
    private static final Logger logger = LoggerFactory.getLogger(BlockingWriterQueue.class);

    public BlockingWriterQueue(IQueue iQueue) {
        super(iQueue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean put(Object object) {
        if (logger.isTraceEnabled()) {
            logger.trace("put() - entry - Putting :" + object);
        }
        boolean bl = false;
        IQueue iQueue = this.getQueue();
        synchronized (iQueue) {
            this.setNotified(false);
            while (!bl && !this.isNotified()) {
                bl = this.getQueue().put(object);
                try {
                    this.getQueue().wait();
                }
                catch (InterruptedException interruptedException) {
                    return false;
                }
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace("put() - exit - Returning :" + bl);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get() throws EmptyQueueException {
        if (logger.isTraceEnabled()) {
            logger.trace("get() - entry");
        }
        Object object = null;
        IQueue iQueue = this.getQueue();
        synchronized (iQueue) {
            if (this.getQueue().size() <= 0) {
                throw new EmptyQueueException("Queue is empty");
            }
            object = this.getQueue().get();
            this.setNotified(true);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("get() - exit - Returning :" + object);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void trigger() {
        if (logger.isTraceEnabled()) {
            logger.trace("trigger() - entry");
        }
        IQueue iQueue = this.getQueue();
        synchronized (iQueue) {
            if (!this.getQueue().isEmpty()) {
                this.setNotified(true);
                this.getQueue().notifyAll();
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace("trigger() - exit");
        }
    }
}

