/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.util;

import com.isencia.util.EmptyQueueException;
import com.isencia.util.IQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BlockingQueue
implements IQueue {
    private static final Logger logger = LoggerFactory.getLogger(BlockingQueue.class);
    private IQueue queue = null;
    private boolean isNotified = false;

    public BlockingQueue(IQueue iQueue) {
        this.queue = iQueue;
    }

    protected boolean isNotified() {
        return this.isNotified;
    }

    protected void setNotified(boolean bl) {
        this.isNotified = bl;
    }

    protected IQueue getQueue() {
        return this.queue;
    }

    @Override
    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    @Override
    public void clear() {
        if (logger.isTraceEnabled()) {
            logger.trace("clear() - entry");
        }
        this.queue.clear();
        if (logger.isTraceEnabled()) {
            logger.trace("clear() - exit");
        }
    }

    @Override
    public int getCapacity() {
        return this.queue.getCapacity();
    }

    @Override
    public Object look() throws EmptyQueueException {
        if (logger.isTraceEnabled()) {
            logger.trace("look() - entry");
        }
        Object object = this.queue.look();
        if (logger.isTraceEnabled()) {
            logger.trace("look() - exit - Result :" + object);
        }
        return object;
    }

    @Override
    public boolean setCapacity(int n) {
        if (logger.isTraceEnabled()) {
            logger.trace("setCapacity() - value :" + n);
        }
        return this.queue.setCapacity(n);
    }

    @Override
    public int size() {
        return this.queue.size();
    }

    public abstract void trigger();
}

