/*
 * Decompiled with CFR 0.152.
 */
package org.edna.pydev.extensions.utils;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.plugin.nature.PythonNature;

public class PydevProjectUtils {
    public static IProject createPydevProject(String string, IWorkspaceRoot iWorkspaceRoot, IProgressMonitor iProgressMonitor) throws Exception {
        IProject iProject = iWorkspaceRoot.getProject(string);
        iProject.create(iProgressMonitor);
        iProject.open(iProgressMonitor);
        IPythonNature iPythonNature = PythonNature.addNature((IProject)iProject, (IProgressMonitor)iProgressMonitor, null, null, null, (String)"python", null);
        PydevProjectUtils.createSrcAndExample(iProject, iPythonNature, "example", null, iProgressMonitor);
        return iProject;
    }

    public static void createSrcAndExample(IProject iProject, IPythonNature iPythonNature, String string, InputStream inputStream, IProgressMonitor iProgressMonitor) throws Exception {
        IFolder iFolder = iProject.getFolder("src");
        iFolder.create(true, true, iProgressMonitor);
        iPythonNature.getPythonPathNature().setProjectSourcePath(iFolder.getFullPath().toString());
        IFile iFile = iFolder.getFile(String.valueOf(string) + ".py");
        if (inputStream == null) {
            inputStream = PydevProjectUtils.getHelloWorldPython();
        }
        iFile.create(inputStream, true, iProgressMonitor);
        iFile = iFolder.getFile(String.valueOf(string) + ".launch");
        boolean bl = iPythonNature.getInterpreterType() == 0;
        iFile.create(PydevProjectUtils.getLaunchConfig(iProject.getName(), string, bl), true, iProgressMonitor);
        iPythonNature.rebuildPath();
        iProject.refreshLocal(2, iProgressMonitor);
    }

    private static InputStream getHelloWorldPython() {
        String string = "# An exmple python script\r\n# Please chose run or debug to run the script with the \r\n# python interpreter found automatically by the workbench. \r\n# For instance go to 'Run' and choose 'example'. \r\n\r\ndef hello():\r\n    print \"Hello World!\"\r\n\r\n\r\nhello()";
        return new ByteArrayInputStream(string.getBytes());
    }

    private static InputStream getLaunchConfig(String string, String string2, boolean bl) throws UnsupportedEncodingException {
        StringBuilder stringBuilder = new StringBuilder("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\r\n");
        if (bl) {
            stringBuilder.append("<launchConfiguration type=\"org.python.pydev.debug.regularLaunchConfigurationType\">\r\n");
        } else {
            stringBuilder.append("<launchConfiguration type=\"org.edna.pydev.extensions.jythonInSameVM\">\r\n");
        }
        stringBuilder.append("<listAttribute key=\"org.eclipse.debug.core.MAPPED_RESOURCE_PATHS\">\r\n");
        stringBuilder.append("<listEntry value=\"/" + string + "/src/" + string2 + "\"/>\r\n");
        stringBuilder.append("</listAttribute>\r\n");
        stringBuilder.append("<listAttribute key=\"org.eclipse.debug.core.MAPPED_RESOURCE_TYPES\">\r\n");
        stringBuilder.append("<listEntry value=\"1\"/>\r\n");
        stringBuilder.append("</listAttribute>\r\n");
        stringBuilder.append("<listAttribute key=\"org.eclipse.debug.ui.favoriteGroups\">\r\n");
        stringBuilder.append("<listEntry value=\"org.eclipse.debug.ui.launchGroup.debug\"/>\r\n");
        stringBuilder.append("</listAttribute>\r\n");
        stringBuilder.append("<stringAttribute key=\"org.eclipse.ui.externaltools.ATTR_LOCATION\" value=\"${workspace_loc:" + string + "}/src/" + string2 + ".py\"/>\r\n");
        stringBuilder.append("<stringAttribute key=\"org.eclipse.ui.externaltools.ATTR_OTHER_WORKING_DIRECTORY\" value=\"\"/>\r\n");
        stringBuilder.append("<stringAttribute key=\"org.eclipse.ui.externaltools.ATTR_TOOL_ARGUMENTS\" value=\"\"/>\r\n");
        String string3 = bl ? "python" : "jython";
        stringBuilder.append("<stringAttribute key=\"org.python.pydev.debug.ATTR_INTERPRETER\" value=\"" + string3 + "\"/>\r\n");
        stringBuilder.append("<stringAttribute key=\"org.python.pydev.debug.ATTR_PROJECT\" value=\"" + string + "\"/>\r\n");
        stringBuilder.append("</launchConfiguration>\r\n");
        return new ByteArrayInputStream(stringBuilder.toString().getBytes("UTF-8"));
    }

    public static IPythonNature addJythonNature(IProject iProject, String string, IProgressMonitor iProgressMonitor) throws CoreException {
        IPythonNature iPythonNature = PythonNature.addNature((IProject)iProject, (IProgressMonitor)iProgressMonitor, (String)"jython 2.5", null, null, (String)string, null);
        iPythonNature.rebuildPath();
        return iPythonNature;
    }
}

