/*
 * Decompiled with CFR 0.152.
 */
package org.edna.pydev.extensions.utils;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.edna.common.util.eclipse.BundleUtils;

public class LibsLocationFinder {
    public static final List<String> findEdnaLibs() throws URISyntaxException, IOException {
        File[] fileArray;
        ArrayList<String> arrayList = new ArrayList<String>(31);
        File file = BundleUtils.getBundleLocation((String)"uk.ac.gda.libs");
        if (file.exists() && file.isDirectory()) {
            fileArray = file.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File file, String string) {
                    return string.toLowerCase().endsWith(".jar");
                }
            });
            int n = 0;
            while (n < fileArray.length) {
                arrayList.add(fileArray[n].getAbsolutePath());
                ++n;
            }
        }
        fileArray = new HashSet();
        fileArray.add("uk.ac.diamond.");
        fileArray.add("uk.ac.gda.");
        fileArray.add("uk.ac.sda.");
        fileArray.add("uk.ac.sda.");
        fileArray.add("org.edna.");
        File file2 = file.getParentFile();
        if (file2.exists() && file2.isDirectory()) {
            File[] fileArray2 = file2.listFiles();
            int n = 0;
            while (n < fileArray2.length) {
                for (String string : fileArray) {
                    if (!fileArray2[n].getName().startsWith(string)) continue;
                    if (fileArray2[n].isDirectory() && System.getProperty("eclipse.debug.session") != null) {
                        arrayList.add(String.valueOf(fileArray2[n].getAbsolutePath()) + "/bin");
                        continue;
                    }
                    arrayList.add(fileArray2[n].getAbsolutePath());
                }
                ++n;
            }
        }
        return arrayList;
    }
}

