/*
 * Decompiled with CFR 0.152.
 */
package org.edna.pydev.extensions.utils;

import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.edna.common.util.eclipse.BundleUtils;
import org.edna.common.util.python.PythonUtils;
import org.edna.pydev.extensions.utils.LibsLocationFinder;
import org.python.copiedfromeclipsesrc.JavaVmLocationFinder;
import org.python.pydev.core.IInterpreterInfo;
import org.python.pydev.core.REF;
import org.python.pydev.core.Tuple;
import org.python.pydev.editor.codecompletion.revisited.ProjectModulesManager;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.runners.SimpleJythonRunner;
import org.python.pydev.ui.interpreters.JythonInterpreterManager;
import org.python.pydev.ui.interpreters.PythonInterpreterManager;
import org.python.pydev.ui.pythonpathconf.InterpreterInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InterpreterUtils {
    private static Logger logger = LoggerFactory.getLogger(InterpreterUtils.class);

    public static void createPythonInterpreter(String string, IProgressMonitor iProgressMonitor) throws Exception {
        String string2 = PythonUtils.getProbablePythonPath();
        InterpreterUtils.createPythonInterpreter(string, string2, iProgressMonitor);
    }

    public static void createPythonInterpreter(String string, String string2, IProgressMonitor iProgressMonitor) throws Exception {
        if (!InterpreterUtils.isPythonInterpreter(string, iProgressMonitor)) {
            Tuple tuple = null;
            try {
                ProjectModulesManager.IN_TESTS = true;
                tuple = PythonInterpreterManager.doCreateInterpreterInfo((String)string2, (IProgressMonitor)iProgressMonitor);
            }
            finally {
                ProjectModulesManager.IN_TESTS = false;
            }
            IInterpreterInfo iInterpreterInfo = (IInterpreterInfo)tuple.o1;
            iInterpreterInfo.setName(string);
            PythonInterpreterManager pythonInterpreterManager = (PythonInterpreterManager)PydevPlugin.getPythonInterpreterManager();
            pythonInterpreterManager.addInterpreterInfo(iInterpreterInfo);
            pythonInterpreterManager.restorePythopathForInterpreters(iProgressMonitor, new HashSet<String>(Arrays.asList(string)));
            pythonInterpreterManager.setPersistedString(pythonInterpreterManager.getStringToPersist(new IInterpreterInfo[]{iInterpreterInfo}));
            pythonInterpreterManager.saveInterpretersInfoModulesManager();
        }
    }

    private static boolean isPythonInterpreter(String string, IProgressMonitor iProgressMonitor) {
        try {
            return PydevPlugin.getPythonInterpreterManager().getInterpreterInfo(string, iProgressMonitor) != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static boolean isJythonInterpreter(String string, IProgressMonitor iProgressMonitor) {
        try {
            return PydevPlugin.getJythonInterpreterManager().getInterpreterInfo(string, iProgressMonitor) != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static void createJythonInterpreter(String string, IProgressMonitor iProgressMonitor) throws Exception {
        if (!InterpreterUtils.isJythonInterpreter(string, iProgressMonitor)) {
            Object object2;
            InterpreterInfo interpreterInfo;
            File file;
            block9: {
                File file2 = BundleUtils.getBundleLocation((String)"uk.ac.gda.libs");
                File file3 = new File(file2, "jython2.5.1");
                file = new File(file3, "jython.jar");
                File file4 = PydevPlugin.getScriptWithinPySrc((String)"interpreterInfo.py");
                if (!file4.exists()) {
                    throw new Exception("The file specified does not exist: " + file4);
                }
                Tuple tuple = new SimpleJythonRunner().runAndGetOutputWithJar(REF.getFileAbsolutePath((File)file4), file.getAbsolutePath(), null, null, null, iProgressMonitor);
                interpreterInfo = null;
                try {
                    try {
                        ProjectModulesManager.IN_TESTS = true;
                        interpreterInfo = InterpreterInfo.fromString((String)((String)tuple.o1));
                    }
                    catch (Exception exception) {
                        logger.error("Cannot automatically create a Jython interpreter.", (Throwable)exception);
                        ProjectModulesManager.IN_TESTS = false;
                        break block9;
                    }
                }
                catch (Throwable throwable) {
                    ProjectModulesManager.IN_TESTS = false;
                    throw throwable;
                }
                ProjectModulesManager.IN_TESTS = false;
            }
            if (interpreterInfo == null) {
                return;
            }
            interpreterInfo.executableOrJar = file.getAbsolutePath();
            List list = JavaVmLocationFinder.findDefaultJavaJars();
            for (Object object2 : list) {
                interpreterInfo.libs.add(REF.getFileAbsolutePath((File)object2));
            }
            object2 = LibsLocationFinder.findEdnaLibs();
            interpreterInfo.libs.addAll(object2);
            interpreterInfo.restoreCompiledLibs(iProgressMonitor);
            interpreterInfo.setName(string);
            JythonInterpreterManager jythonInterpreterManager = (JythonInterpreterManager)PydevPlugin.getJythonInterpreterManager();
            jythonInterpreterManager.addInterpreterInfo((IInterpreterInfo)interpreterInfo);
            jythonInterpreterManager.restorePythopathForInterpreters(iProgressMonitor, new HashSet<String>(Arrays.asList(string)));
            jythonInterpreterManager.setPersistedString(jythonInterpreterManager.getStringToPersist(new IInterpreterInfo[]{interpreterInfo}));
            jythonInterpreterManager.saveInterpretersInfoModulesManager();
            logger.info("Jython interpreter registered: " + string);
        }
    }
}

