/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jlibdc1394.media.protocol.j1394;

import java.awt.Dimension;
import java.util.StringTokenizer;
import javax.media.CaptureDeviceInfo;
import javax.media.Format;
import javax.media.MediaLocator;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;
import javax.media.format.YUVFormat;
import net.sf.jlibdc1394.J1394CameraInfo;
import net.sf.jlibdc1394.JDC1394VideoMode;
import net.sf.jlibdc1394.media.protocol.j1394.FormatHelper;

public class J1394Format {
    public static final int RGB = 0;
    public static final int YUV444 = 1;
    public static final int YUV422 = 2;
    public static final int YUV420 = 3;
    public static final int YUV411 = 4;
    public static final int Y8 = 5;
    public static final int Y16 = 6;
    public static final String PROTOCOL = "j1394://";

    public static boolean isI1394CaptureDevice(CaptureDeviceInfo device) {
        if (device == null) {
            return false;
        }
        String name = device.getName();
        return name != null && name.indexOf("1394") != -1;
    }

    public static MediaLocator getMediaLocator(int cameraIndex, Format format) {
        if (format == null || !(format instanceof VideoFormat)) {
            return null;
        }
        return new MediaLocator(PROTOCOL + cameraIndex + "," + J1394Format.getI1394Format(format) + "," + J1394Format.getI1394Mode(format) + "," + J1394Format.getI1394FrameRate(format));
    }

    public static MediaLocator getMediaLocator(int cameraIndex, Format format, int frameRateCode) {
        if (format == null || !(format instanceof VideoFormat)) {
            return null;
        }
        return new MediaLocator(PROTOCOL + cameraIndex + "," + J1394Format.getI1394Format(format) + "," + J1394Format.getI1394Mode(format) + "," + Math.max(0, frameRateCode));
    }

    public static MediaLocator getMediaLocator(int cameraIndex, int formatCode, int modeCode, int frameRateCode) {
        return new MediaLocator(PROTOCOL + cameraIndex + "," + formatCode + "," + modeCode + "," + frameRateCode);
    }

    public static MediaLocator getMediaLocator(J1394CameraInfo info) {
        if (info == null) {
            return null;
        }
        return new MediaLocator(PROTOCOL + info.getIndex() + "," + info.getFormat() + "," + info.getMode() + "," + info.getFramerate());
    }

    public static String getDescription(int format, int mode) {
        return JDC1394VideoMode.getDescription(format, mode);
    }

    public static int getCameraIndexFromLocator(MediaLocator ml) {
        int cameraIndex = 0;
        String remainder = ml.getRemainder();
        if (remainder.startsWith("//") || remainder.startsWith("\\")) {
            remainder = remainder.substring(2, remainder.length());
        }
        String index = J1394Format.getToken(remainder, 0);
        try {
            int i;
            cameraIndex = i = Integer.parseInt(index);
        }
        catch (Exception e) {
            System.err.println(" Not a valid camera index number: " + index + "\nUsing default index: " + cameraIndex);
        }
        return cameraIndex;
    }

    public static int getFormatFromLocator(MediaLocator ml) {
        int format = 0;
        String remainder = ml.getRemainder();
        if (remainder.startsWith("//") || remainder.startsWith("\\")) {
            remainder = remainder.substring(2, remainder.length());
        }
        String index = J1394Format.getToken(remainder, 1);
        try {
            int i;
            format = i = Integer.parseInt(index);
        }
        catch (Exception e) {
            System.err.println(" Not a valid camera format: " + index + "\nUsing default format: " + format);
        }
        return format;
    }

    public static int getModeFromLocator(MediaLocator ml) {
        int mode = 1;
        String remainder = ml.getRemainder();
        if (remainder.startsWith("//") || remainder.startsWith("\\")) {
            remainder = remainder.substring(2, remainder.length());
        }
        String index = J1394Format.getToken(remainder, 2);
        try {
            int i;
            mode = i = Integer.parseInt(index);
        }
        catch (Exception e) {
            System.err.println(" Not a valid camera mode: " + index + "\nUsing default mode: " + mode);
        }
        return mode;
    }

    public static int getFrameRateFromLocator(MediaLocator ml) {
        int framerate = 3;
        String remainder = ml.getRemainder();
        if (remainder.startsWith("//") || remainder.startsWith("\\")) {
            remainder = remainder.substring(2, remainder.length());
        }
        String index = J1394Format.getToken(remainder, 3);
        try {
            int i;
            framerate = i = Integer.parseInt(index);
        }
        catch (Exception e) {
            System.err.println(" Not a valid camera framerate: " + index + "\nUsing default framerate: " + framerate);
        }
        return framerate;
    }

    public static Format getVideoFormat(int format, int mode, int frameRateCode) {
        return FormatHelper.getVideoFormat(format, mode, frameRateCode);
    }

    public static Format getVideoFormat(int format, int mode) {
        return FormatHelper.getVideoFormat(format, mode);
    }

    public static Dimension getSize(int format, int mode) {
        return FormatHelper.getSize(format, mode);
    }

    public static float getFramerate(int framerateCode) {
        return FormatHelper.getFrameRate(framerateCode);
    }

    public static int getFramerateCode(float framerate) {
        return FormatHelper.getFrameRateCode(framerate);
    }

    public static String getToken(String s, int index) {
        if (s == null || index < 0) {
            return null;
        }
        int count = 0;
        String token = null;
        StringTokenizer stringTok = new StringTokenizer(s, ",");
        while (stringTok.hasMoreElements()) {
            String tok = stringTok.nextToken();
            if (count == index) {
                token = tok;
                break;
            }
            ++count;
        }
        return token;
    }

    public static int getI1394Format(Format format) {
        if (format == null || !(format instanceof VideoFormat)) {
            return -1;
        }
        Dimension d = ((VideoFormat)format).getSize();
        if (d.width == 160 && d.height == 120) {
            return 0;
        }
        if (d.width == 320 && d.height == 240) {
            return 0;
        }
        if (d.width == 640 && d.height == 480) {
            return 0;
        }
        if (d.width == 800 && d.height == 600) {
            return 1;
        }
        if (d.width == 1024 && d.height == 768) {
            return 1;
        }
        if (d.width == 1280 && d.height == 960) {
            return 2;
        }
        if (d.width == 1600 && d.height == 1200) {
            return 2;
        }
        return 0;
    }

    public static int getI1394Mode(Format format) {
        if (format == null || !(format instanceof VideoFormat)) {
            return -1;
        }
        Dimension d = ((VideoFormat)format).getSize();
        String enc = format.getEncoding();
        int mfs = ((VideoFormat)format).getMaxDataLength();
        switch (d.width) {
            case 160: {
                if (mfs != 57600 || !enc.equalsIgnoreCase("yuv")) break;
                return 0;
            }
            case 320: {
                if (mfs != 153600 || !enc.equalsIgnoreCase("yuv")) break;
                return 1;
            }
            case 640: {
                if (mfs == 614400 && enc.equalsIgnoreCase("yuv")) {
                    return 3;
                }
                if (mfs == 921600 && enc.equalsIgnoreCase("rgb")) {
                    return 4;
                }
                if (mfs == 307200 && (enc.equalsIgnoreCase("y") || enc.equalsIgnoreCase("yuv"))) {
                    return 5;
                }
                if (mfs != 614400 || !enc.equalsIgnoreCase("y") && !enc.equalsIgnoreCase("yuv")) break;
                return 6;
            }
            case 800: {
                if (mfs == 960000 && enc.equalsIgnoreCase("yuv")) {
                    return 0;
                }
                if (mfs == 1440000 && enc.equalsIgnoreCase("rgb")) {
                    return 1;
                }
                if (mfs == 480000 && enc.equalsIgnoreCase("y")) {
                    return 2;
                }
                if (mfs != 960000 || !enc.equalsIgnoreCase("y")) break;
                return 6;
            }
            case 1024: {
                if (mfs == 0x120000 && enc.equalsIgnoreCase("yuv")) {
                    return 3;
                }
                if (mfs == 0x240000 && enc.equalsIgnoreCase("rgb")) {
                    return 4;
                }
                if (mfs == 786432 && enc.equalsIgnoreCase("y")) {
                    return 5;
                }
                if (mfs != 0x180000 || !enc.equalsIgnoreCase("y")) break;
                return 7;
            }
            case 1280: {
                if (mfs == 2457600 && enc.equalsIgnoreCase("yuv")) {
                    return 0;
                }
                if (mfs == 3686400 && enc.equalsIgnoreCase("rgb")) {
                    return 1;
                }
                if (mfs == 1228800 && enc.equalsIgnoreCase("y")) {
                    return 2;
                }
                if (mfs != 2457600 || !enc.equalsIgnoreCase("y")) break;
                return 6;
            }
            case 1600: {
                if (mfs == 3840000 && enc.equalsIgnoreCase("yuv")) {
                    return 3;
                }
                if (mfs == 5760000 && enc.equalsIgnoreCase("rgb")) {
                    return 4;
                }
                if (mfs == 1920000 && enc.equalsIgnoreCase("y")) {
                    return 5;
                }
                if (mfs != 3840000 || !enc.equalsIgnoreCase("y")) break;
                return 7;
            }
        }
        return 0;
    }

    public static int getI1394FrameRate(Format format) {
        if (format == null || !(format instanceof VideoFormat)) {
            return -1;
        }
        float rate = ((VideoFormat)format).getFrameRate();
        if (rate == 1.875f) {
            return 0;
        }
        if (rate == 3.75f) {
            return 1;
        }
        if (rate == 7.5f) {
            return 2;
        }
        if (rate == 15.0f) {
            return 3;
        }
        if (rate == 30.0f) {
            return 4;
        }
        if (rate == 60.0f) {
            return 5;
        }
        return 2;
    }

    public static Format YUVFormat(String type, Dimension size, float frameRate) {
        if (type.equalsIgnoreCase("UVYY")) {
            return new YUVFormat(size, size.width * size.height * 2, Format.byteArray, frameRate, 32, size.width * 2, size.width * 2, 1, 0, 2);
        }
        if (type.equalsIgnoreCase("YUY2")) {
            return new YUVFormat(size, size.width * size.height * 4, Format.byteArray, frameRate, 32, size.width * 4, size.width * 4, 0, 1, 3);
        }
        if (type.equalsIgnoreCase("YUY420_1")) {
            return new YUVFormat(size, size.width * size.height * 3 / 2, Format.byteArray, frameRate, 2, size.width, size.width / 2, 0, size.width * size.height, size.width * size.height * 5 / 4);
        }
        if (type.equalsIgnoreCase("YUY420_2")) {
            return new YUVFormat(size, size.width * size.height * 3 / 2, Format.byteArray, frameRate, 2, size.width, size.width / 2, 0, size.width * size.height * 5 / 4, size.width * size.height);
        }
        return null;
    }

    public static VideoFormat JMFFormat(String fourcc, Dimension size, float framerate) {
        YUVFormat result = null;
        boolean unspecified = size == null;
        int width = unspecified ? 0 : size.width;
        int height = unspecified ? 0 : size.height;
        int pixelsPerImage = width * height;
        if (fourcc.equalsIgnoreCase("UYVY")) {
            result = unspecified ? new YUVFormat(null, -1, Format.byteArray, -1.0f, 32, -1, -1, 1, 0, 2) : new YUVFormat(size, pixelsPerImage * 2, Format.byteArray, framerate, 32, width * 2, width * 2, 1, 0, 2);
        } else if (fourcc.equalsIgnoreCase("IYUV")) {
            result = unspecified ? new YUVFormat(null, -1, Format.byteArray, -1.0f, 2, -1, -1, 0, -1, -1) : new YUVFormat(size, pixelsPerImage + pixelsPerImage / 2, Format.byteArray, framerate, 2, width, width / 2, 0, pixelsPerImage, pixelsPerImage + pixelsPerImage / 4);
        } else if (fourcc.equalsIgnoreCase("RGB")) {
            if (unspecified) {
                result = new RGBFormat(null, -1, Format.byteArray, -1.0f, 24, 3, 2, 1, -1, -1, 0, -1);
            } else {
                int flipped = 1;
                int actualHeight = height;
                if (height < 0) {
                    actualHeight = -actualHeight;
                    flipped = 0;
                }
                result = new RGBFormat(size, pixelsPerImage * 3, Format.byteArray, framerate, 24, 3, 2, 1, 3, 3 * width, flipped, 1);
            }
        }
        return result;
    }
}

