/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jlibdc1394.media.protocol.j1394;

import java.awt.Dimension;
import java.io.IOException;
import java.util.Vector;
import javax.media.Buffer;
import javax.media.Control;
import javax.media.Format;
import javax.media.format.VideoFormat;
import javax.media.protocol.BufferTransferHandler;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.PushBufferStream;
import net.sf.jlibdc1394.JDC1394Cam;
import net.sf.jlibdc1394.JDC1394VideoModes;
import net.sf.jlibdc1394.media.protocol.j1394.DataSourceErrorEvent;
import net.sf.jlibdc1394.media.protocol.j1394.DataSourceErrorListener;
import net.sf.jlibdc1394.media.protocol.j1394.DataSourceErrorListenerHandler;
import net.sf.jlibdc1394.media.protocol.j1394.FormatHelper;
import net.sf.jlibdc1394.media.protocol.j1394.J1394Format;
import net.sf.jlibdc1394.media.protocol.j1394.J1394Registry;

public class J1394BufferStream
implements PushBufferStream,
Runnable,
DataSourceErrorListenerHandler {
    public boolean debug = false;
    protected float frameRate;
    protected Dimension size;
    protected int maxDataLength;
    int seqNo = 0;
    protected ContentDescriptor cd = new ContentDescriptor("raw");
    protected int[] data;
    protected VideoFormat format;
    protected boolean started;
    protected Thread thread;
    protected BufferTransferHandler transferHandler;
    protected Control[] controls = new Control[0];
    Format[] supportedFormats;
    private JDC1394Cam camera;
    private boolean camReady = false;
    private long timestamp = 0L;
    private long lastTime = 0L;
    private long currentTime = 0L;
    private long waitTime;
    private boolean firstRead = true;
    private boolean eos = false;
    private boolean error = false;
    private Vector<DataSourceErrorListener> errorListeners = new Vector(10, 10);

    public J1394BufferStream(int cameraIndex, int cameraFormat, int cameraMode, int framerateCode) throws IOException {
        this.format = (VideoFormat)J1394Format.getVideoFormat(cameraFormat, cameraMode, framerateCode);
        this.maxDataLength = this.format.getMaxDataLength();
        this.size = this.format.getSize();
        if (this.size == null) {
            this.size = new Dimension(320, 240);
        }
        this.frameRate = J1394Format.getFramerate(framerateCode);
        this.waitTime = (long)(1000.0f / this.frameRate);
        this.data = new int[this.maxDataLength];
        try {
            if (J1394Registry.port == null) {
                J1394Registry.updateRegistry();
            }
            if (J1394Registry.port == null) {
                this.notifyErrorListeners(new DataSourceErrorEvent("No Firewire bus detected!...", this));
                throw new Error("No Firewire bus detected!...");
            }
            if (J1394Registry.numberOfCameras == 0) {
                this.notifyErrorListeners(new DataSourceErrorEvent("No camera connected!...", this));
                throw new Error("No camera connected!...");
            }
            if (cameraIndex < 0 || cameraIndex >= J1394Registry.numberOfCameras) {
                this.notifyErrorListeners(new DataSourceErrorEvent("Bad camera index!...", this));
                throw new Error("Bad camera index!...");
            }
            this.camera = J1394Registry.cameras[cameraIndex];
            if (this.debug) {
                System.out.println("Loading camera '" + this.camera.getCameraModel() + "' from vendor '" + this.camera.getCameraVendor() + "'.");
            }
            this.camera.initCamera();
            this.supportedFormats = FormatHelper.getFormats(this.camera);
            JDC1394VideoModes vmodes = this.camera.getVideoModes();
            if (!vmodes.checkCapability(cameraFormat, cameraMode, framerateCode)) {
                this.notifyErrorListeners(new DataSourceErrorEvent("Camera settings are not supported!...", this));
                throw new Error("The current camera settings are not supported: \nDCAM Format: " + cameraFormat + "\nDCAM Mode: " + cameraMode + "\nDCAM Framerate: " + framerateCode);
            }
            System.out.println("Using camera settings: \nDCAM Format: " + cameraFormat + "\nDCAM Mode: " + cameraMode + "\nDCAM Framerate: " + framerateCode + "(" + this.frameRate + ")" + "\nSize: " + this.size.width + "x" + this.size.height);
            vmodes.setVideoFormat(cameraFormat);
            vmodes.setVideoMode(cameraMode);
            vmodes.setVideoFrameRate(framerateCode);
            this.camReady = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException(e.toString());
        }
    }

    public ContentDescriptor getContentDescriptor() {
        if (this.debug) {
            System.out.println(this.getClass() + " get content");
        }
        return this.cd;
    }

    public long getContentLength() {
        return -1L;
    }

    public boolean endOfStream() {
        return this.eos;
    }

    public boolean error() {
        return this.error;
    }

    public Format getFormat() {
        if (this.debug) {
            System.out.println(this.getClass() + " get format");
        }
        return this.format;
    }

    public Format[] getSupportedFormats() {
        if (this.debug) {
            System.out.println(this.getClass() + " get supported formats " + this.supportedFormats.length);
        }
        return this.supportedFormats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(Buffer buffer) throws IOException {
        J1394BufferStream j1394BufferStream = this;
        synchronized (j1394BufferStream) {
            if (this.firstRead) {
                this.timestamp = System.currentTimeMillis();
                this.firstRead = false;
            }
            this.currentTime = System.currentTimeMillis();
            ++this.seqNo;
            Object outdata = buffer.getData();
            if (outdata == null || outdata.getClass() != Format.intArray || ((int[])outdata).length < this.format.getMaxDataLength()) {
                outdata = new int[this.format.getMaxDataLength()];
                buffer.setData(outdata);
                buffer.setFormat((Format)this.format);
            }
            if (this.camReady && this.started) {
                try {
                    this.camera.acquireImage((int[])outdata);
                }
                catch (Exception e) {
                    this.notifyErrorListeners(new DataSourceErrorEvent("Driver read error: " + e.toString(), this));
                    this.camReady = false;
                    this.eos = true;
                    this.error = true;
                    e.printStackTrace();
                    throw new IOException(e.toString());
                }
            }
            buffer.setTimeStamp((this.currentTime - this.timestamp) * 1000000L);
            buffer.setFlags(buffer.getFlags() | 0x60 | 0x100);
            buffer.setSequenceNumber((long)this.seqNo);
            buffer.setLength(this.format.getMaxDataLength());
            this.lastTime = this.currentTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTransferHandler(BufferTransferHandler transferHandler) {
        if (this.debug) {
            System.out.println(this.getClass() + " set transfer handler");
        }
        J1394BufferStream j1394BufferStream = this;
        synchronized (j1394BufferStream) {
            this.transferHandler = transferHandler;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEnabled(boolean enabled) {
        J1394BufferStream j1394BufferStream = this;
        synchronized (j1394BufferStream) {
            if (enabled) {
                if (this.debug) {
                    System.out.println(this.getClass() + "(" + this.hashCode() + ") starting thread");
                }
                if (!this.started) {
                    this.started = true;
                    this.lastTime = this.timestamp = System.currentTimeMillis();
                    if (this.debug) {
                        System.out.println(this.getClass() + "(" + this.hashCode() + ") starting image acquisition");
                    }
                    try {
                        this.camera.startImageAcquisition();
                        this.thread = new Thread(this);
                        this.thread.start();
                    }
                    catch (Exception e) {
                        this.started = false;
                        this.notifyErrorListeners(new DataSourceErrorEvent("Driver read error: " + e.toString(), this));
                        e.printStackTrace();
                    }
                    if (this.debug) {
                        System.out.println(this.getClass() + "(" + this.hashCode() + ") started image acquisition");
                    }
                }
            } else {
                if (this.debug) {
                    System.out.println(this.getClass() + "(" + this.hashCode() + ") stopping thread");
                }
                this.started = false;
                this.seqNo = 0;
                if (this.debug) {
                    System.out.println(this.getClass() + "(" + this.hashCode() + ") stopping image acquisition");
                }
                if (this.debug) {
                    System.out.println(this.getClass() + "(" + this.hashCode() + ") stopped image acquisition");
                }
            }
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.started && !this.eos) {
            J1394BufferStream j1394BufferStream = this;
            synchronized (j1394BufferStream) {
                while (this.transferHandler == null && this.started) {
                    try {
                        if (this.debug) {
                            System.out.println("waiting a second");
                        }
                        this.wait(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            if (this.eos || !this.started || this.transferHandler == null) continue;
            this.transferHandler.transferData((PushBufferStream)this);
            try {
                Thread.sleep(this.waitTime - 20L);
            }
            catch (InterruptedException ise) {}
        }
        if (this.camera != null && this.camera.isImageAcquisitionStarted()) {
            try {
                if (this.debug) {
                    System.out.println(this.hashCode() + " Stopping the camera");
                }
                this.camera.stopImageAcquisition();
                if (this.debug) {
                    System.out.println(this.hashCode() + " Stopped the camera");
                }
            }
            catch (Exception ce) {
                ce.printStackTrace();
            }
        }
    }

    public Object[] getControls() {
        if (this.debug) {
            System.out.println(this.getClass() + " get controls");
        }
        return this.controls;
    }

    public Object getControl(String controlType) {
        if (this.debug) {
            System.out.println(this.getClass() + " get control type: " + controlType);
        }
        try {
            Class<?> cls = Class.forName(controlType);
            Object[] cs = this.getControls();
            for (int i = 0; i < cs.length; ++i) {
                if (!cls.isInstance(cs[i])) continue;
                return cs[i];
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public void addDataSourceErrorListener(DataSourceErrorListener listener) {
        if (listener != null) {
            this.errorListeners.add(listener);
        }
    }

    public void removeDataSourceErrorListener(DataSourceErrorListener listener) {
        if (listener != null) {
            this.errorListeners.remove(listener);
        }
    }

    private void removeAllDataSourceErrorListeners() {
        this.errorListeners.removeAllElements();
    }

    private void notifyErrorListeners(DataSourceErrorEvent event) {
        if (this.errorListeners.isEmpty()) {
            return;
        }
        for (DataSourceErrorListener l : this.errorListeners) {
            try {
                if (l == null) continue;
                l.errorOccured(event);
            }
            catch (Exception e) {}
        }
    }

    public JDC1394Cam getCamera() {
        return this.camera;
    }
}

