/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jlibdc1394.impl.cmu;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.jlibdc1394.JDC1394Cam;
import net.sf.jlibdc1394.JDC1394CamException;
import net.sf.jlibdc1394.JDC1394CamPort;
import net.sf.jlibdc1394.impl.cmu.JDC1394CamCMU;

public class JDC1394CamPortCMU
implements JDC1394CamPort {
    private List shortCameraList = new ArrayList();
    private List cameraDescription = new ArrayList();
    private List initedCams = new ArrayList();
    private Map cameras = new HashMap();

    private native int libCheckLink();

    private native int libGetNumberCameras();

    private native String libGetShortCameraDescription(int var1);

    private native String libGetFullCameraDescription(int var1);

    private native String libGetCameraVendor(int var1);

    private native String libGetCameraModel(int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkLink() throws JDC1394CamException {
        JDC1394CamPortCMU jDC1394CamPortCMU = this;
        synchronized (jDC1394CamPortCMU) {
            int cl = this.libCheckLink();
            if (cl != JDC1394CamCMU.CAM_SUCCESS) {
                throw new JDC1394CamException(JDC1394CamCMU.getCMUErrorDescription(cl) + " No cameras found.");
            }
        }
    }

    public int getNumberCameras() throws JDC1394CamException {
        return this.libGetNumberCameras();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshCameraList() throws JDC1394CamException {
        JDC1394CamPortCMU jDC1394CamPortCMU = this;
        synchronized (jDC1394CamPortCMU) {
            this.checkLink();
            int nCameras = this.getNumberCameras();
            this.shortCameraList.clear();
            this.cameraDescription.clear();
            for (int i = 0; i < nCameras; ++i) {
                this.shortCameraList.add(this.libGetShortCameraDescription(i));
                this.cameraDescription.add(this.libGetFullCameraDescription(i));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getCameraListIterator(boolean refresh, int descriptionType) throws JDC1394CamException {
        JDC1394CamPortCMU jDC1394CamPortCMU = this;
        synchronized (jDC1394CamPortCMU) {
            if (refresh) {
                this.refreshCameraList();
            }
            if (descriptionType == 1) {
                return this.shortCameraList.iterator();
            }
            return this.cameraDescription.iterator();
        }
    }

    public JDC1394Cam selectCamera(int camIndex) throws JDC1394CamException {
        Integer idx = new Integer(camIndex);
        JDC1394CamCMU camera = null;
        if (!this.cameras.containsKey(idx)) {
            camera = new JDC1394CamCMU();
            camera.setCameraIndex(camIndex);
            this.initCamera(camIndex, camera);
            this.cameras.put(idx, camera);
        } else {
            camera = (JDC1394CamCMU)this.cameras.get(idx);
        }
        return camera;
    }

    public List getCameraDescriptions(int descriptionType) throws JDC1394CamException {
        if (descriptionType == 1) {
            return this.shortCameraList;
        }
        return this.cameraDescription;
    }

    private void initCamera(int camIndex, JDC1394Cam camera) throws JDC1394CamException {
        Integer idx = new Integer(camIndex);
        if (!this.initedCams.contains(idx)) {
            camera.initCamera();
            this.initedCams.add(idx);
        }
    }

    public Map getCameras() {
        return this.cameras;
    }

    public JDC1394CamCMU getCamera(int index) {
        if (index < 0 || this.cameras == null || this.cameras.isEmpty()) {
            return null;
        }
        try {
            return (JDC1394CamCMU)this.cameras.get(new Integer(index));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    static {
        try {
            System.loadLibrary("net_sf_jlibdc1394_impl_cmu_JDC1394CamCMU");
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

