/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jlibdc1394.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import javax.swing.JInternalFrame;
import net.sf.jlibdc1394.JDC1394Cam;
import net.sf.jlibdc1394.JDC1394CamException;
import net.sf.jlibdc1394.gui.PanelLiveView;

public class InternalFrameCamLiveView
extends JInternalFrame {
    private JDC1394Cam theCamera;
    private PanelLiveView pLiveView;

    public InternalFrameCamLiveView(JDC1394Cam cam) {
        this.theCamera = cam;
        try {
            BorderLayout thisLayout = new BorderLayout();
            this.getContentPane().setLayout(thisLayout);
            thisLayout.setHgap(0);
            thisLayout.setVgap(0);
            this.setTitle("camera live view");
            this.setResizable(true);
            this.setIcon(false);
            this.setClosable(true);
            this.setIconifiable(true);
            this.setVisible(true);
            this.setPreferredSize(new Dimension(421, 300));
            this.setDefaultCloseOperation(2);
            this.setBounds(0, 0, 100, 100);
            this.setIconifiable(true);
            this.connectToCam();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void connectToCam() {
        try {
            if (this.theCamera == null) {
                return;
            }
            Dimension res = this.theCamera.getVideoModes().getResolutionDimension();
            System.out.println(res);
            this.setPreferredSize(res);
            this.setBounds(new Rectangle(this.getX(), this.getY(), res.width, res.height));
            this.theCamera.startImageAcquisition();
            this.pLiveView = new PanelLiveView(this.theCamera);
            this.pLiveView.setBounds(0, 0, res.width, res.height);
            this.getContentPane().add((Component)this.pLiveView, "Center");
        }
        catch (JDC1394CamException e) {
            e.printStackTrace();
        }
    }

    public void dispose() {
        super.dispose();
        try {
            this.theCamera.stopImageAcquisition();
        }
        catch (JDC1394CamException e) {
            e.printStackTrace();
        }
    }
}

