/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.vergil.tree;

import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import ptolemy.actor.gui.Effigy;
import ptolemy.actor.gui.PtolemyEffigy;
import ptolemy.actor.gui.PtolemyFrame;
import ptolemy.actor.gui.Tableau;
import ptolemy.actor.gui.TableauFactory;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.vergil.tree.FullTreeModel;
import ptolemy.vergil.tree.PTree;

public class TreeTableau
extends Tableau {
    private static Color BACKGROUND_COLOR = new Color(0xE5E5E5);

    public TreeTableau(PtolemyEffigy container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        NamedObj model = container.getModel();
        if (!(model instanceof CompositeEntity)) {
            throw new IllegalActionException((Nameable)this, "Cannot have a tree view of a model that is not a CompositeEntity.");
        }
    }

    public void setFrame(JFrame frame) throws IllegalActionException {
        if (!(frame instanceof TreeFrame)) {
            throw new IllegalActionException((Nameable)this, "Frame for PlotTableau must be an instance of PlotTableauFrame.");
        }
        super.setFrame(frame);
        ((TreeFrame)frame).setTableau(this);
    }

    public void show() {
        JFrame frame = this.getFrame();
        if (frame == null) {
            PtolemyEffigy container = (PtolemyEffigy)this.getContainer();
            CompositeEntity model = (CompositeEntity)container.getModel();
            frame = new TreeFrame(model);
            frame.setBackground(BACKGROUND_COLOR);
            this.size.setExpression("300x500");
            ((TreeFrame)frame).setTableau(this);
            frame.pack();
            ((TreeFrame)frame).centerOnScreen();
            frame.setVisible(true);
            try {
                this.setFrame(frame);
            }
            catch (IllegalActionException ex) {
                throw new InternalErrorException((Throwable)ex);
            }
        }
        super.show();
    }

    public static class Factory
    extends TableauFactory {
        public Factory(NamedObj container, String name) throws IllegalActionException, NameDuplicationException {
            super(container, name);
        }

        public Tableau createTableau(Effigy effigy) throws Exception {
            if (effigy instanceof PtolemyEffigy) {
                TreeTableau previous = (TreeTableau)effigy.getEntity("treeTableau");
                if (previous != null) {
                    return previous;
                }
                PtolemyEffigy ptEffigy = (PtolemyEffigy)effigy;
                NamedObj model = ptEffigy.getModel();
                if (model instanceof CompositeEntity) {
                    return new TreeTableau(ptEffigy, "treeTableau");
                }
            }
            return null;
        }
    }

    public static class TreeFrame
    extends PtolemyFrame {
        public TreeFrame(CompositeEntity entity) {
            super((NamedObj)entity);
            PTree pane = new PTree(new FullTreeModel(entity));
            this.getContentPane().add((Component)new JScrollPane(pane), "Center");
        }

        protected void _writeFile(File file) throws IOException {
            FileWriter fout = null;
            try {
                fout = new FileWriter(file);
                this.getModel().exportMoML((Writer)fout);
            }
            finally {
                if (fout != null) {
                    fout.close();
                }
            }
        }
    }
}

