/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.vergil.toolbox;

import java.util.Iterator;
import ptolemy.actor.gui.Effigy;
import ptolemy.actor.gui.PtolemyEffigy;
import ptolemy.actor.gui.Tableau;
import ptolemy.actor.gui.TableauFactory;
import ptolemy.actor.gui.TextEditorTableau;
import ptolemy.actor.gui.TextEffigy;
import ptolemy.data.IntToken;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.StringAttribute;
import ptolemy.vergil.toolbox.TextEditorFactory;
import ptolemy.vergil.toolbox.TextEditorForStringAttributes;

public class TextEditorTableauFactory
extends TableauFactory
implements TextEditorFactory {
    public StringAttribute attributeName = new StringAttribute((NamedObj)this, "attributeName");
    public Parameter columnsDisplayed = new Parameter((NamedObj)this, "columnsDisplayed");
    public Parameter rowsDisplayed;
    private TextEditorForStringAttributes _editor;

    public TextEditorTableauFactory(NamedObj container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.columnsDisplayed.setTypeEquals((Type)BaseType.INT);
        this.columnsDisplayed.setExpression("80");
        this.rowsDisplayed = new Parameter((NamedObj)this, "rowsDisplayed");
        this.rowsDisplayed.setTypeEquals((Type)BaseType.INT);
        this.rowsDisplayed.setExpression("40");
    }

    public void clear() {
        this._editor = null;
    }

    public Tableau createTableau(Effigy effigy) throws Exception {
        Iterator tableaux;
        if (!(effigy instanceof PtolemyEffigy)) {
            return null;
        }
        NamedObj object = ((PtolemyEffigy)effigy).getModel();
        Attribute attribute = object.getAttribute(this.attributeName.getExpression());
        if (!(attribute instanceof StringAttribute)) {
            throw new IllegalActionException((Nameable)object, "Expected " + object.getFullName() + " to contain a StringAttribute named " + this.attributeName.getExpression() + ", but it does not.");
        }
        TextEffigy textEffigy2 = null;
        for (TextEffigy textEffigy2 : effigy.entityList(TextEffigy.class)) {
        }
        if (textEffigy2 == null) {
            textEffigy2 = TextEffigy.newTextEffigy(effigy, ((StringAttribute)attribute).getExpression());
        }
        if ((tableaux = textEffigy2.entityList(TextEditorTableau.class).iterator()).hasNext()) {
            return (TextEditorTableau)((Object)tableaux.next());
        }
        if (this._editor == null) {
            int numberOfRows = ((IntToken)this.rowsDisplayed.getToken()).intValue();
            int numberOfColumns = ((IntToken)this.columnsDisplayed.getToken()).intValue();
            this._editor = new TextEditorForStringAttributes(this, (StringAttribute)attribute, numberOfRows, numberOfColumns, "Editor for " + this.attributeName.getExpression() + " of " + this.getContainer().getFullName());
        }
        TextEditorTableau tableau = new TextEditorTableau(textEffigy2, "_tableau", this._editor);
        return tableau;
    }

    public String getText() {
        if (this._editor != null) {
            return this._editor.text.getText();
        }
        return null;
    }
}

