/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.vergil.toolbox;

import java.awt.Frame;
import ptolemy.actor.gui.EditorFactory;
import ptolemy.data.IntToken;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.StringAttribute;
import ptolemy.util.MessageHandler;
import ptolemy.vergil.toolbox.TextEditorFactory;
import ptolemy.vergil.toolbox.TextEditorForStringAttributes;

public class TextEditorConfigureFactory
extends EditorFactory
implements TextEditorFactory {
    public StringAttribute attributeName = new StringAttribute((NamedObj)this, "attributeName");
    public Parameter columnsDisplayed = new Parameter((NamedObj)this, "columnsDisplayed");
    public Parameter rowsDisplayed;
    private TextEditorForStringAttributes _editor;

    public TextEditorConfigureFactory(NamedObj container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.columnsDisplayed.setTypeEquals((Type)BaseType.INT);
        this.columnsDisplayed.setExpression("80");
        this.rowsDisplayed = new Parameter((NamedObj)this, "rowsDisplayed");
        this.rowsDisplayed.setTypeEquals((Type)BaseType.INT);
        this.rowsDisplayed.setExpression("40");
    }

    public void clear() {
        this._editor = null;
    }

    public void createEditor(NamedObj object, Frame parent) {
        if (this._editor == null) {
            try {
                StringAttribute attributeToEdit = (StringAttribute)this.getContainer().getAttribute(this.attributeName.getExpression(), StringAttribute.class);
                int numberOfRows = ((IntToken)this.rowsDisplayed.getToken()).intValue();
                int numberOfColumns = ((IntToken)this.columnsDisplayed.getToken()).intValue();
                this._editor = new TextEditorForStringAttributes(this, attributeToEdit, numberOfRows, numberOfColumns, "Editor for " + this.attributeName.getExpression() + " of " + this.getContainer().getFullName());
            }
            catch (IllegalActionException ex) {
                MessageHandler.error((String)"Cannot get specified string attribute to edit.", (Throwable)ex);
            }
            this._editor.pack();
            this._editor.adjustFileMenu();
            this._editor.centerOnScreen();
        }
        this._editor.setVisible(true);
    }

    public String getText() {
        if (this._editor != null) {
            return this._editor.text.getText();
        }
        return null;
    }
}

