/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.vergil.toolbox;

import java.awt.event.ActionEvent;
import ptolemy.data.BooleanToken;
import ptolemy.data.IntToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.ChangeRequest;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.moml.MoMLChangeRequest;
import ptolemy.vergil.toolbox.FigureAction;

public class RotateOrFlipPorts
extends FigureAction {
    public static final int CLOCKWISE = 0;
    public static final int COUNTERCLOCKWISE = 1;
    public static final int FLIP_HORIZONTAL = 2;
    public static final int FLIP_VERTICAL = 3;
    private int _direction;

    public RotateOrFlipPorts(int direction, String label) {
        super(label);
        this._direction = direction;
    }

    public void actionPerformed(ActionEvent event) {
        boolean flipOn;
        super.actionPerformed(event);
        NamedObj object = this.getTarget();
        String moml = "";
        if (this._direction == 0 || this._direction == 1) {
            int rotation = 90;
            switch (this._direction) {
                case 1: {
                    rotation = -90;
                }
            }
            try {
                Token token;
                Attribute attribute = object.getAttribute("_rotatePorts");
                if (attribute instanceof Parameter && (token = ((Parameter)attribute).getToken()) instanceof IntToken) {
                    rotation += ((IntToken)token).intValue();
                }
            }
            catch (IllegalActionException illegalActionException) {}
            moml = "<property name=\"_rotatePorts\" class=\"ptolemy.data.expr.Parameter\" value=\"" + rotation + "\"/>";
        } else if (this._direction == 3) {
            flipOn = true;
            try {
                Token token;
                Attribute attribute = object.getAttribute("_flipPortsVertical");
                if (attribute instanceof Parameter && (token = ((Parameter)attribute).getToken()) instanceof BooleanToken) {
                    flipOn = !((BooleanToken)token).booleanValue();
                }
            }
            catch (IllegalActionException illegalActionException) {}
            moml = "<property name=\"_flipPortsVertical\" class=\"ptolemy.data.expr.Parameter\" value=\"" + flipOn + "\"/>";
        } else if (this._direction == 2) {
            flipOn = true;
            try {
                Token token;
                Attribute attribute = object.getAttribute("_flipPortsHorizontal");
                if (attribute instanceof Parameter && (token = ((Parameter)attribute).getToken()) instanceof BooleanToken) {
                    flipOn = !((BooleanToken)token).booleanValue();
                }
            }
            catch (IllegalActionException illegalActionException) {}
            moml = "<property name=\"_flipPortsHorizontal\" class=\"ptolemy.data.expr.Parameter\" value=\"" + flipOn + "\"/>";
        }
        MoMLChangeRequest request = new MoMLChangeRequest((Object)this, object, moml);
        request.setUndoable(true);
        object.requestChange((ChangeRequest)request);
    }
}

