/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.vergil.toolbox;

import diva.canvas.Figure;
import diva.graph.GraphController;
import diva.gui.toolbox.JContextMenu;
import diva.gui.toolbox.MenuFactory;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import ptolemy.kernel.util.NamedObj;
import ptolemy.vergil.toolbox.MenuItemFactory;

public class PtolemyMenuFactory
implements MenuFactory {
    private GraphController _controller;
    private List _factoryList = new LinkedList();

    public PtolemyMenuFactory(GraphController controller) {
        this._controller = controller;
    }

    public void addMenuItemFactory(MenuItemFactory factory) {
        this._factoryList.add(factory);
    }

    public JContextMenu create(Figure figure) {
        NamedObj object = this._getObjectFromFigure(figure);
        if (object == null) {
            return null;
        }
        JContextMenu menu = new JContextMenu((Object)object, object.getFullName());
        for (MenuItemFactory factory : this.menuItemFactoryList()) {
            factory.create(menu, object);
        }
        return menu;
    }

    public GraphController getController() {
        return this._controller;
    }

    public List menuItemFactoryList() {
        return Collections.unmodifiableList(this._factoryList);
    }

    public void removeMenuItemFactory(MenuItemFactory factory) {
        this._factoryList.remove(factory);
    }

    protected NamedObj _getObjectFromFigure(Figure figure) {
        Object object = figure.getUserObject();
        return (NamedObj)this._controller.getGraphModel().getSemanticObject(object);
    }
}

