/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.vergil.toolbox;

import diva.canvas.toolbox.SVGParser;
import diva.util.xml.XmlDocument;
import diva.util.xml.XmlElement;
import diva.util.xml.XmlReader;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import ptolemy.actor.gui.EditorFactory;
import ptolemy.gui.ComponentDialog;
import ptolemy.gui.Query;
import ptolemy.kernel.util.ChangeRequest;
import ptolemy.kernel.util.ConfigurableAttribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.KernelException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.SingletonConfigurableAttribute;
import ptolemy.moml.MoMLChangeRequest;

public class AnnotationEditorFactory
extends EditorFactory {
    private NamedObj _container;
    Query _fontProperties;
    private String _fontSize = "14";
    private String _fontFamily = "sanserif";
    private String _fontColor = "blue";
    private ConfigurableAttribute _iconDescription;
    private JTextArea _textArea;

    public AnnotationEditorFactory(NamedObj container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this._container = container;
    }

    public void createEditor(NamedObj object, Frame parent) {
        ComponentDialog dialog = new ComponentDialog(parent, "Edit Annotation", this.createEditorPane());
        String button = dialog.buttonPressed();
        if (!button.equals("OK")) {
            return;
        }
        String newText = this._textArea.getText();
        if (newText == null || newText.trim().equals("")) {
            newText = "Double click to edit text.";
        }
        String moml = "<configure><svg><text x=\"20\" y=\"20\" style=\"font-size:" + this._fontProperties.getStringValue("fontSize") + "; font-family:" + this._fontProperties.getStringValue("fontFamily") + "; fill:" + this._fontProperties.getStringValue("fontColor") + "\">" + newText + "</text></svg></configure>";
        this._iconDescription.requestChange((ChangeRequest)new MoMLChangeRequest((Object)this, (NamedObj)this._iconDescription, moml));
    }

    public Component createEditorPane() {
        String text;
        block10: {
            this._textArea = new JTextArea();
            this._iconDescription = (ConfigurableAttribute)this._container.getAttribute("_iconDescription");
            if (this._iconDescription == null) {
                try {
                    this._iconDescription = new SingletonConfigurableAttribute(this._container, "_iconDescription");
                }
                catch (KernelException ex) {
                    throw new InternalErrorException(ex.toString());
                }
            }
            text = this._iconDescription.getExpression();
            this._fontSize = "14";
            this._fontFamily = "SansSerif";
            this._fontColor = "blue";
            try {
                StringReader in = new StringReader(text);
                XmlDocument document = new XmlDocument(null);
                XmlReader reader = new XmlReader();
                reader.parse(document, (Reader)in);
                XmlElement root = document.getRoot();
                String name = root.getType();
                if (!name.equals("svg")) break block10;
                Iterator children = root.elements();
                while (children.hasNext()) {
                    XmlElement child = (XmlElement)children.next();
                    name = child.getType();
                    if (!name.equals("text")) continue;
                    text = child.getPCData();
                    String style = (String)child.getAttributeMap().get("style");
                    if (style != null) {
                        StringTokenizer tokenizer = new StringTokenizer(style, ";");
                        while (tokenizer.hasMoreTokens()) {
                            String token = tokenizer.nextToken();
                            int colon = token.indexOf(":");
                            if (colon <= 0) continue;
                            String property = token.substring(0, colon).trim();
                            if (property.equals("fill")) {
                                this._fontColor = token.substring(colon + 1);
                                continue;
                            }
                            if (property.equals("font-size")) {
                                this._fontSize = token.substring(colon + 1);
                                continue;
                            }
                            if (!property.equals("font-family")) continue;
                            this._fontFamily = token.substring(colon + 1);
                        }
                    }
                    break;
                }
            }
            catch (Exception exception) {}
        }
        this._textArea.setText(text);
        AnnotationTextEditor editor = new AnnotationTextEditor(this._textArea);
        return editor;
    }

    public class AnnotationTextEditor
    extends JPanel {
        public AnnotationTextEditor(JTextArea textArea) {
            JScrollPane pane = new JScrollPane(textArea);
            pane.setPreferredSize(new Dimension(600, 300));
            this.add(pane);
            AnnotationEditorFactory.this._fontProperties = new Query();
            String[] sizes = new String[]{"9", "10", "11", "12", "14", "18", "24", "32"};
            AnnotationEditorFactory.this._fontProperties.addChoice("fontSize", "font size", sizes, AnnotationEditorFactory.this._fontSize, true);
            String[] families = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
            AnnotationEditorFactory.this._fontProperties.addChoice("fontFamily", "font family", families, AnnotationEditorFactory.this._fontFamily, false);
            String[] colors = SVGParser.colorNames();
            AnnotationEditorFactory.this._fontProperties.addChoice("fontColor", "font color", colors, AnnotationEditorFactory.this._fontColor, true);
            this.add(AnnotationEditorFactory.this._fontProperties);
        }
    }
}

