/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.vergil.kernel.attributes;

import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import ptolemy.data.DoubleToken;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.vergil.kernel.attributes.FilledShapeAttribute;

public class RectangleAttribute
extends FilledShapeAttribute {
    public Parameter rounding = new Parameter((NamedObj)this, "rounding");
    protected double _roundingValue = 0.0;

    public RectangleAttribute(NamedObj container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.rounding.setTypeEquals((Type)BaseType.DOUBLE);
        this.rounding.setExpression("0.0");
    }

    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.rounding) {
            double roundingValue = ((DoubleToken)this.rounding.getToken()).doubleValue();
            if (roundingValue < 0.0) {
                throw new IllegalActionException((Nameable)this, "Invalid rounding value. Required to be non-negative.");
            }
            if (roundingValue != this._roundingValue) {
                this._roundingValue = roundingValue;
                this._icon.setShape(this._newShape());
            }
        } else {
            super.attributeChanged(attribute);
        }
    }

    protected Shape _newShape() {
        double roundingValue = 0.0;
        try {
            roundingValue = ((DoubleToken)this.rounding.getToken()).doubleValue();
        }
        catch (IllegalActionException illegalActionException) {}
        double x = 0.0;
        double y = 0.0;
        double width = this._widthValue;
        double height = this._heightValue;
        if (this._centeredValue) {
            x = -width * 0.5;
            y = -height * 0.5;
        }
        if (roundingValue == 0.0) {
            return new Rectangle2D.Double(x, y, width, height);
        }
        return new RoundRectangle2D.Double(x, y, width, height, roundingValue, roundingValue);
    }
}

