/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.vergil.kernel.attributes;

import java.awt.Frame;
import java.io.File;
import java.net.URL;
import javax.swing.JFileChooser;
import ptolemy.actor.gui.Configuration;
import ptolemy.actor.gui.EditorFactory;
import ptolemy.actor.gui.MoMLApplication;
import ptolemy.actor.gui.TableauFrame;
import ptolemy.data.expr.FileParameter;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.util.StringUtilities;
import ptolemy.vergil.kernel.attributes.VisibleAttribute;

public class DocumentationAttribute
extends VisibleAttribute {
    public DocumentationAttribute(NamedObj container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this._attachText("_iconDescription", "<svg>\n<rect x=\"-50\" y=\"-20\" width=\"130\" height=\"40\" style=\"fill:yellow\"/><text x=\"-40\" y=\"-5\" style=\"font-size:12; font-family:SansSerif; fill:black\">Double click to see\ndocumentation.</text></svg>");
        new DocumentationAttributeFactory((NamedObj)this, "_editorFactory");
    }

    private static class DocumentationAttributeFactory
    extends EditorFactory {
        public DocumentationAttributeFactory(NamedObj _container, String name) throws IllegalActionException, NameDuplicationException {
            super(_container, name);
        }

        public void createEditor(NamedObj object, Frame parent) {
            try {
                FileParameter docAttribute = null;
                if (!(parent instanceof TableauFrame)) {
                    throw new InternalErrorException("Frame \"" + parent + "\" is not a TableauFrame");
                }
                Configuration configuration = ((TableauFrame)parent).getConfiguration();
                NamedObj documentedObject = object;
                while (documentedObject != null) {
                    docAttribute = (FileParameter)documentedObject.getAttribute("_documentation", FileParameter.class);
                    if (docAttribute != null) break;
                    documentedObject = documentedObject.getContainer();
                }
                if (docAttribute != null) {
                    URL doc = MoMLApplication.specToURL(docAttribute.getExpression());
                    configuration.openModel(doc, doc, doc.toExternalForm());
                } else {
                    NamedObj container = object.getContainer();
                    if (container == null) {
                        container = object;
                    }
                    JFileChooser fileDialog = new JFileChooser();
                    fileDialog.setDialogTitle("Select a documentation file.");
                    String cwd = StringUtilities.getProperty((String)"user.dir");
                    if (cwd != null) {
                        fileDialog.setCurrentDirectory(new File(cwd));
                    }
                    if (fileDialog.showOpenDialog(parent) == 0) {
                        String fileName = fileDialog.getSelectedFile().getAbsolutePath();
                        docAttribute = new FileParameter(container, "_documentation");
                        docAttribute.setExpression(fileName);
                    }
                }
            }
            catch (Throwable throwable) {
                throw new InternalErrorException((Nameable)object, throwable, "Cannot access Documentation");
            }
        }
    }
}

