/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.vergil.kernel.attributes;

import java.awt.Color;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import ptolemy.actor.gui.ColorAttribute;
import ptolemy.data.BooleanToken;
import ptolemy.data.IntToken;
import ptolemy.data.expr.Parameter;
import ptolemy.data.expr.StringParameter;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Workspace;
import ptolemy.vergil.icon.TextIcon;
import ptolemy.vergil.kernel.attributes.VisibleAttribute;

public class AbstractTextAttribute
extends VisibleAttribute {
    public Parameter bold;
    public StringParameter fontFamily;
    public Parameter italic;
    public ColorAttribute textColor;
    public Parameter textSize;
    protected TextIcon _icon = new TextIcon((NamedObj)this, "_icon");
    private boolean _inAttributeChanged = false;

    public AbstractTextAttribute(NamedObj container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this._icon.setPersistent(false);
        this.textSize = new Parameter((NamedObj)this, "textSize");
        this.textSize.setExpression("14");
        this.textSize.setTypeEquals((Type)BaseType.INT);
        this.textSize.addChoice("9");
        this.textSize.addChoice("10");
        this.textSize.addChoice("11");
        this.textSize.addChoice("12");
        this.textSize.addChoice("14");
        this.textSize.addChoice("18");
        this.textSize.addChoice("24");
        this.textSize.addChoice("32");
        this.textColor = new ColorAttribute((NamedObj)this, "textColor");
        this.textColor.setExpression("{0.0, 0.0, 1.0, 1.0}");
        this.fontFamily = new StringParameter((NamedObj)this, "fontFamily");
        this.fontFamily.setExpression("SansSerif");
        String[] families = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        int i = 0;
        while (i < families.length) {
            this.fontFamily.addChoice(families[i]);
            ++i;
        }
        this.bold = new Parameter((NamedObj)this, "bold");
        this.bold.setExpression("false");
        this.bold.setTypeEquals((Type)BaseType.BOOLEAN);
        this.italic = new Parameter((NamedObj)this, "italic");
        this.italic.setExpression("false");
        this.italic.setTypeEquals((Type)BaseType.BOOLEAN);
    }

    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (!(attribute != this.fontFamily && attribute != this.textSize && attribute != this.bold && attribute != this.italic || this._inAttributeChanged)) {
            try {
                this._inAttributeChanged = true;
                int sizeValue = ((IntToken)this.textSize.getToken()).intValue();
                String familyValue = this.fontFamily.stringValue();
                int styleValue = 0;
                if (((BooleanToken)this.bold.getToken()).booleanValue()) {
                    styleValue |= 1;
                }
                if (((BooleanToken)this.italic.getToken()).booleanValue()) {
                    styleValue |= 2;
                }
                Font fontValue = new Font(familyValue, styleValue, sizeValue);
                this._icon.setFont(fontValue);
            }
            finally {
                this._inAttributeChanged = false;
            }
        } else if (attribute == this.textColor) {
            Color colorValue = this.textColor.asColor();
            this._icon.setTextColor(colorValue);
        } else {
            super.attributeChanged(attribute);
        }
    }

    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        AbstractTextAttribute result = (AbstractTextAttribute)((Object)super.clone(workspace));
        result._icon = (TextIcon)result.getAttribute("_icon");
        return result;
    }
}

