/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.vergil.icon;

import diva.canvas.Figure;
import diva.canvas.toolbox.LabelFigure;
import diva.gui.toolbox.FigureIcon;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import ptolemy.gui.Top;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Workspace;
import ptolemy.vergil.icon.DynamicEditorIcon;

public class TextIcon
extends DynamicEditorIcon {
    private String _DEFAULT_TEXT = "Double click to edit text.";
    private Font _font = new Font("SansSerif", 0, 12);
    private String _iconText = "-A-";
    private Color _textColor = Color.blue;
    private String _text;

    public TextIcon(NamedObj container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
    }

    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        TextIcon newObject = (TextIcon)((Object)super.clone(workspace));
        return newObject;
    }

    public Figure createBackgroundFigure() {
        LabelFigure newFigure = this._text != null ? new LabelFigure(this._text, this._font) : new LabelFigure(this._DEFAULT_TEXT, this._font);
        newFigure.setAnchor(8);
        newFigure.setFillPaint((Paint)this._textColor);
        this._addLiveFigure((Figure)newFigure);
        return newFigure;
    }

    public Icon createIcon() {
        if (this._iconCache != null) {
            return this._iconCache;
        }
        LabelFigure figure = new LabelFigure(this._iconText, this._font);
        figure.setFillPaint((Paint)this._textColor);
        this._iconCache = new FigureIcon((Figure)figure, 20, 15);
        return this._iconCache;
    }

    public void setTextColor(Color textColor) {
        this._textColor = textColor;
        Runnable doSet = new Runnable(){

            public void run() {
                Iterator figures = TextIcon.this._liveFigureIterator();
                while (figures.hasNext()) {
                    Object figure = figures.next();
                    ((LabelFigure)figure).setFillPaint((Paint)TextIcon.this._textColor);
                }
            }
        };
        SwingUtilities.invokeLater(doSet);
    }

    public void setFont(Font font) {
        this._font = font;
        Runnable doSet = new Runnable(){

            public void run() {
                Iterator figures = TextIcon.this._liveFigureIterator();
                while (figures.hasNext()) {
                    Object figure = figures.next();
                    ((LabelFigure)figure).setFont(TextIcon.this._font);
                }
            }
        };
        SwingUtilities.invokeLater(doSet);
    }

    public void setIconText(String text) {
        this._iconText = text;
    }

    public void setText(String text) {
        this._text = text;
        Runnable doSet = new Runnable(){

            public void run() {
                Iterator figures = TextIcon.this._liveFigureIterator();
                while (figures.hasNext()) {
                    Object figure = figures.next();
                    ((LabelFigure)figure).setString(TextIcon.this._text);
                }
            }
        };
        Top.deferIfNecessary(doSet);
    }
}

