/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.vergil.icon;

import java.awt.Color;
import ptolemy.actor.gui.Effigy;
import ptolemy.actor.gui.PtolemyEffigy;
import ptolemy.actor.gui.Tableau;
import ptolemy.actor.gui.TableauFactory;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Workspace;
import ptolemy.moml.LibraryAttribute;
import ptolemy.vergil.icon.EditIconFrame;
import ptolemy.vergil.icon.EditorIcon;

public class EditIconTableau
extends Tableau {
    private static Color BACKGROUND_COLOR = new Color(0xE5E5E5);

    public EditIconTableau(Workspace workspace) throws IllegalActionException, NameDuplicationException {
        super(workspace);
    }

    public EditIconTableau(PtolemyEffigy container, String name) throws IllegalActionException, NameDuplicationException {
        this(container, name, null);
    }

    public EditIconTableau(PtolemyEffigy container, String name, LibraryAttribute defaultLibrary) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        NamedObj model = container.getModel();
        if (model == null) {
            return;
        }
        if (model instanceof EditorIcon) {
            EditorIcon entity = (EditorIcon)model;
            EditIconFrame frame = new EditIconFrame(entity, (Tableau)this, defaultLibrary);
            this.setFrame(frame);
            frame.setBackground(BACKGROUND_COLOR);
            return;
        }
        throw new IllegalActionException((Nameable)this, "Cannot edit an icon that is not an instance of EditorIcon.");
    }

    public String getTitle() {
        NamedObj modelContainer;
        NamedObj model;
        NamedObj container = this.getContainer();
        if (container instanceof PtolemyEffigy && (model = ((PtolemyEffigy)container).getModel()) != null && (modelContainer = model.getContainer()) != null) {
            return "Icon editor for " + modelContainer.getName();
        }
        return super.getTitle();
    }

    public static class Factory
    extends TableauFactory {
        public Factory(NamedObj container, String name) throws IllegalActionException, NameDuplicationException {
            super(container, name);
        }

        public Tableau createTableau(Effigy effigy) throws Exception {
            if (effigy instanceof PtolemyEffigy) {
                EditIconTableau tableau = (EditIconTableau)effigy.getEntity("editIconTableau");
                if (tableau == null) {
                    LibraryAttribute library = (LibraryAttribute)this.getAttribute("_library", LibraryAttribute.class);
                    tableau = new EditIconTableau((PtolemyEffigy)effigy, "editIconTableau", library);
                }
                return tableau;
            }
            return null;
        }
    }
}

