/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.vergil.icon;

import diva.canvas.CompositeFigure;
import diva.canvas.Figure;
import diva.canvas.toolbox.BasicRectangle;
import diva.canvas.toolbox.LabelFigure;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import ptolemy.data.IntToken;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Settable;
import ptolemy.vergil.icon.XMLIcon;

public class BoxedValuesIcon
extends XMLIcon {
    public Parameter displayWidth = new Parameter((NamedObj)this, "displayWidth");
    protected static Font _labelFont = new Font("Dialog", 0, 12);

    public BoxedValuesIcon(NamedObj container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.displayWidth.setExpression("80");
        this.displayWidth.setTypeEquals((Type)BaseType.INT);
        this.setPersistent(false);
    }

    public Figure createBackgroundFigure() {
        String displayString = this._displayString();
        double width = 60.0;
        double heigth = 30.0;
        if (displayString != null) {
            LabelFigure label = new LabelFigure(displayString, _labelFont, 1.0, 0);
            Rectangle2D stringBounds = label.getBounds();
            width = stringBounds.getWidth() + 20.0;
            heigth = stringBounds.getHeight() + 10.0;
        }
        BasicRectangle result = new BasicRectangle(0.0, 0.0, width, heigth, (Paint)Color.white, 1.0f);
        return result;
    }

    public Figure createFigure() {
        CompositeFigure result = (CompositeFigure)super.createFigure();
        String truncated = this._displayString();
        if (truncated == null) {
            truncated = " ";
        }
        LabelFigure label = new LabelFigure(truncated, _labelFont, 1.0, 0);
        Rectangle2D backBounds = result.getBackgroundFigure().getBounds();
        label.translateTo(backBounds.getCenterX(), backBounds.getCenterY());
        result.add((Figure)label);
        this._addLiveFigure((Figure)label);
        return result;
    }

    protected String _displayString() {
        NamedObj container = this.getContainer();
        if (container != null) {
            StringBuffer buffer = new StringBuffer();
            Iterator settables = container.attributeList(Settable.class).iterator();
            while (settables.hasNext()) {
                String line;
                Settable settable = (Settable)settables.next();
                if (settable.getVisibility() != Settable.FULL && settable.getVisibility() != Settable.NOT_EDITABLE) continue;
                String name = settable.getDisplayName();
                String value = settable.getExpression();
                String truncated = line = String.valueOf(name) + ": " + value;
                try {
                    int width = ((IntToken)this.displayWidth.getToken()).intValue();
                    if (line.length() > width) {
                        truncated = String.valueOf(line.substring(0, width)) + "...";
                    }
                }
                catch (IllegalActionException illegalActionException) {}
                buffer.append(truncated);
                if (!settables.hasNext()) continue;
                buffer.append("\n");
            }
            return buffer.toString();
        }
        return null;
    }
}

