/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.vergil.fsm.ia;

import diva.gui.GUIUtilities;
import java.awt.event.ActionEvent;
import java.io.File;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JToolBar;
import ptolemy.actor.gui.Configuration;
import ptolemy.actor.gui.Tableau;
import ptolemy.domains.fsm.kernel.ia.InterfaceAutomaton;
import ptolemy.kernel.util.NamedObj;
import ptolemy.util.StringUtilities;
import ptolemy.vergil.fsm.FSMGraphController;
import ptolemy.vergil.fsm.ia.InterfaceAutomatonGraphFrame;

public class InterfaceAutomatonGraphController
extends FSMGraphController {
    private ComposeWithAction _composeWithAction = new ComposeWithAction();
    private File _directory;

    public InterfaceAutomatonGraphController(File directory) {
        this._directory = directory;
    }

    public void addToMenuAndToolbar(JMenu menu, JToolBar toolbar) {
        super.addToMenuAndToolbar(menu, toolbar);
        GUIUtilities.addMenuItem((JMenu)menu, (Action)this._composeWithAction);
    }

    public class ComposeWithAction
    extends AbstractAction {
        public ComposeWithAction() {
            super("Compose With");
            this.putValue("tooltip", "Compose with another interface automaton");
            this.putValue("MnemonicKey", 67);
        }

        public void actionPerformed(ActionEvent e) {
            JFileChooser fileDialog = new JFileChooser();
            fileDialog.setDialogTitle("Select an interface automaton to compose with.");
            if (InterfaceAutomatonGraphController.this._directory != null) {
                fileDialog.setCurrentDirectory(InterfaceAutomatonGraphController.this._directory);
            } else {
                String cwd = StringUtilities.getProperty((String)"user.dir");
                if (cwd != null) {
                    fileDialog.setCurrentDirectory(new File(cwd));
                }
            }
            int returnValue = fileDialog.showOpenDialog(InterfaceAutomatonGraphController.this.getFrame());
            if (returnValue == 0) {
                InterfaceAutomatonGraphController.this._directory = fileDialog.getCurrentDirectory();
                try {
                    File file = fileDialog.getSelectedFile().getCanonicalFile();
                    URL url = file.toURI().toURL();
                    Configuration configuration = InterfaceAutomatonGraphController.this.getConfiguration();
                    Tableau newAutomatonTableau = configuration.openModel(url, url, url.toExternalForm());
                    InterfaceAutomaton model1 = (InterfaceAutomaton)InterfaceAutomatonGraphController.this.getFrame().getModel();
                    InterfaceAutomatonGraphFrame graphFrame2 = (InterfaceAutomatonGraphFrame)newAutomatonTableau.getFrame();
                    InterfaceAutomaton model2 = (InterfaceAutomaton)graphFrame2.getModel();
                    InterfaceAutomaton composition = model1.compose(model2);
                    configuration.openModel((NamedObj)composition);
                }
                catch (Exception ex) {
                    InterfaceAutomatonGraphController.this.getFrame().report("Error reading input", ex);
                }
            }
        }
    }
}

