/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.vergil.fsm;

import diva.graph.GraphEvent;
import diva.graph.GraphModel;
import diva.graph.GraphUtilities;
import diva.graph.modular.EdgeModel;
import diva.graph.modular.MutableEdgeModel;
import diva.graph.modular.NodeModel;
import diva.util.NullIterator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import ptolemy.actor.TypedActor;
import ptolemy.domains.fsm.kernel.State;
import ptolemy.domains.fsm.kernel.Transition;
import ptolemy.kernel.ComponentEntity;
import ptolemy.kernel.ComponentPort;
import ptolemy.kernel.ComponentRelation;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.Port;
import ptolemy.kernel.Relation;
import ptolemy.kernel.util.ChangeListener;
import ptolemy.kernel.util.ChangeRequest;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.Locatable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.moml.MoMLChangeRequest;
import ptolemy.vergil.basic.AbstractBasicGraphModel;
import ptolemy.vergil.basic.NamedObjNodeModel;
import ptolemy.vergil.fsm.Arc;

public class FSMGraphModel
extends AbstractBasicGraphModel {
    private Set _linkSet;
    private ArcModel _arcModel = new ArcModel();
    private PortModel _portModel = new PortModel();
    private StateModel _stateModel = new StateModel();

    public FSMGraphModel(CompositeEntity composite) {
        super((NamedObj)composite);
        this._linkSet = new HashSet();
        this._update();
    }

    public void disconnectEdge(Object eventSource, Object edge) {
        GraphEvent e;
        if (!(this.getEdgeModel(edge) instanceof ArcModel)) {
            return;
        }
        ArcModel model = (ArcModel)this.getEdgeModel(edge);
        Object head = model.getHead(edge);
        Object tail = model.getTail(edge);
        model.removeEdge(edge);
        if (head != null) {
            e = new GraphEvent(eventSource, 11, edge, head);
            this.dispatchGraphEvent(e);
        }
        if (tail != null) {
            e = new GraphEvent(eventSource, 12, edge, tail);
            this.dispatchGraphEvent(e);
        }
    }

    public String getDeleteEdgeMoML(Object edge) {
        if (!(this.getEdgeModel(edge) instanceof ArcModel)) {
            return "";
        }
        ArcModel model = (ArcModel)this.getEdgeModel(edge);
        return model.getDeleteEdgeMoML(edge);
    }

    public String getDeleteNodeMoML(Object node) {
        if (!(this.getNodeModel(node) instanceof NamedObjNodeModel)) {
            return "";
        }
        NamedObjNodeModel model = (NamedObjNodeModel)this.getNodeModel(node);
        return model.getDeleteNodeMoML(node);
    }

    public EdgeModel getEdgeModel(Object edge) {
        if (edge instanceof Arc) {
            return this._arcModel;
        }
        return null;
    }

    public NodeModel getNodeModel(Object node) {
        if (node instanceof Locatable) {
            NamedObj container = ((Locatable)node).getContainer();
            if (container instanceof ComponentEntity) {
                return this._stateModel;
            }
            if (container instanceof ComponentPort) {
                return this._portModel;
            }
        }
        return super.getNodeModel(node);
    }

    public Object getSemanticObject(Object element) {
        if (element instanceof Arc) {
            return ((Arc)element).getRelation();
        }
        return super.getSemanticObject(element);
    }

    public void removeNode(Object eventSource, Object node) {
        if (!(this.getNodeModel(node) instanceof NamedObjNodeModel)) {
            return;
        }
        NamedObjNodeModel model = (NamedObjNodeModel)this.getNodeModel(node);
        model.removeNode(eventSource, node);
    }

    public PortModel getPortModel() {
        return this._portModel;
    }

    public StateModel getStateModel() {
        return this._stateModel;
    }

    public ArcModel getArcModel() {
        return this._arcModel;
    }

    protected boolean _update() {
        Iterator links = this._linkSet.iterator();
        while (links.hasNext()) {
            Arc link = (Arc)links.next();
            ComponentRelation relation = link.getRelation();
            if (relation == null) continue;
            if (relation.getContainer() == null) {
                link.setHead(null);
                link.setTail(null);
                links.remove();
                continue;
            }
            boolean headOK = GraphUtilities.isContainedNode((Object)link.getHead(), (Object)this.getRoot(), (GraphModel)this);
            boolean tailOK = GraphUtilities.isContainedNode((Object)link.getTail(), (Object)this.getRoot(), (GraphModel)this);
            if (headOK && tailOK) continue;
            link.setHead(null);
            link.setTail(null);
            link.setRelation(null);
            links.remove();
            NamedObj container = this.getPtolemyModel();
            MoMLChangeRequest request = new MoMLChangeRequest((Object)container, container, "<deleteRelation name=\"" + relation.getName(container) + "\"/>\n");
            request.setMergeWithPreviousUndo(true);
            request.setUndoable(true);
            container.requestChange((ChangeRequest)request);
            return false;
        }
        Iterator relations = ((CompositeEntity)this.getPtolemyModel()).relationList().iterator();
        while (relations.hasNext()) {
            this._updateLinks((ComponentRelation)relations.next());
        }
        return super._update();
    }

    private void _updateLinks(ComponentRelation relation) {
        Arc link;
        Iterator links = this._linkSet.iterator();
        Arc foundLink = null;
        while (links.hasNext()) {
            Arc link2 = (Arc)links.next();
            if (link2.getRelation() != relation) continue;
            foundLink = link2;
            break;
        }
        if (foundLink != null) {
            return;
        }
        List linkedPortList = relation.linkedPortList();
        if (linkedPortList.size() != 2) {
            return;
        }
        Port port1 = (Port)linkedPortList.get(0);
        Locatable location1 = this._getLocation(port1.getContainer());
        Port port2 = (Port)linkedPortList.get(1);
        Locatable location2 = this._getLocation(port2.getContainer());
        try {
            link = new Arc();
        }
        catch (Exception e) {
            throw new InternalErrorException("Failed to create new link, even though one does not already exist:" + e.getMessage());
        }
        link.setRelation(relation);
        if (((State)port1.getContainer()).incomingPort.equals(port1)) {
            link.setHead(location1);
            link.setTail(location2);
        } else {
            link.setHead(location2);
            link.setTail(location1);
        }
        this._linkSet.add(link);
    }

    public class ArcModel
    implements MutableEdgeModel {
        public boolean acceptHead(Object edge, Object node) {
            return node instanceof Locatable;
        }

        public boolean acceptTail(Object edge, Object node) {
            return node instanceof Locatable;
        }

        public Object getHead(Object edge) {
            return ((Arc)edge).getHead();
        }

        public String getDeleteEdgeMoML(Object edge) {
            Arc link = (Arc)edge;
            ComponentRelation linkRelation = link.getRelation();
            StringBuffer moml = new StringBuffer();
            NamedObj container = FSMGraphModel.this.getPtolemyModel();
            moml.append(this._deleteRelation(container, (Relation)linkRelation));
            CompositeEntity master = (CompositeEntity)linkRelation.getContainer();
            if (master != null) {
                TypedActor[] refinements = null;
                try {
                    refinements = ((Transition)linkRelation).getRefinement();
                }
                catch (IllegalActionException illegalActionException) {}
                if (refinements != null) {
                    int i = 0;
                    while (i < refinements.length) {
                        TypedActor refinement = refinements[i];
                        boolean removeIt = true;
                        Iterator states = master.entityList(State.class).iterator();
                        block7: while (removeIt && states.hasNext()) {
                            State state = (State)states.next();
                            TypedActor[] stateRefinements = null;
                            try {
                                stateRefinements = state.getRefinement();
                            }
                            catch (IllegalActionException illegalActionException) {}
                            if (stateRefinements == null) continue;
                            int j = 0;
                            while (j < stateRefinements.length) {
                                if (stateRefinements[j] == refinement) {
                                    removeIt = false;
                                    continue block7;
                                }
                                ++j;
                            }
                        }
                        Iterator transitions = master.relationList().iterator();
                        block9: while (removeIt && transitions.hasNext()) {
                            Relation transition = (Relation)transitions.next();
                            if (transition == linkRelation || !(transition instanceof Transition)) continue;
                            TypedActor[] transitionRefinements = null;
                            try {
                                transitionRefinements = ((Transition)transition).getRefinement();
                            }
                            catch (IllegalActionException illegalActionException) {}
                            if (transitionRefinements == null) continue;
                            int j = 0;
                            while (j < transitionRefinements.length) {
                                if (transitionRefinements[j] == refinement) {
                                    removeIt = false;
                                    continue block9;
                                }
                                ++j;
                            }
                        }
                        if (removeIt) {
                            moml.append("<deleteEntity name=\"" + ((NamedObj)refinement).getName(container) + "\"/>\n");
                        }
                        ++i;
                    }
                }
            }
            return moml.toString();
        }

        public Object getTail(Object edge) {
            return ((Arc)edge).getTail();
        }

        public boolean isDirected(Object edge) {
            return true;
        }

        public void removeEdge(final Object edge) {
            final Arc link = (Arc)edge;
            ComponentRelation linkRelation = link.getRelation();
            StringBuffer moml = new StringBuffer();
            NamedObj container = FSMGraphModel.this.getPtolemyModel();
            moml.append(this._deleteRelation(container, (Relation)linkRelation));
            MoMLChangeRequest request = new MoMLChangeRequest((Object)FSMGraphModel.this, container, moml.toString()){

                protected void _execute() throws Exception {
                    super._execute();
                    link.setHead(null);
                    link.setTail(null);
                    link.setRelation(null);
                }
            };
            request.addChangeListener(new ChangeListener(){

                public void changeFailed(ChangeRequest change, Exception exception) {
                }

                public void changeExecuted(ChangeRequest change) {
                    FSMGraphModel.this._linkSet.remove(edge);
                }
            });
            request.setUndoable(true);
            container.requestChange((ChangeRequest)request);
        }

        public void setHead(final Object edge, final Object newArcHead) {
            final Arc link = (Arc)edge;
            NamedObj linkHead = (NamedObj)link.getHead();
            NamedObj linkTail = (NamedObj)link.getTail();
            ComponentRelation linkRelation = link.getRelation();
            StringBuffer moml = new StringBuffer();
            final StringBuffer failmoml = new StringBuffer();
            moml.append("<group>\n");
            failmoml.append("<group>\n");
            final NamedObj container = FSMGraphModel.this.getPtolemyModel();
            if (linkRelation != null) {
                if (newArcHead == null) {
                    moml.append(this._deleteRelation(container, (Relation)linkRelation));
                } else {
                    moml.append(this._unlinkHead(container, linkHead, (Relation)linkRelation));
                }
            }
            String relationName = null;
            if (newArcHead != null) {
                relationName = this._linkHead(container, moml, failmoml, (NamedObj)newArcHead, linkTail, (Relation)linkRelation);
            }
            moml.append("</group>\n");
            failmoml.append("</group>\n");
            final String relationNameToAdd = relationName;
            MoMLChangeRequest request = new MoMLChangeRequest((Object)FSMGraphModel.this, container, moml.toString()){

                protected void _execute() throws Exception {
                    super._execute();
                    link.setHead(newArcHead);
                    if (relationNameToAdd != null) {
                        ComponentRelation relation = ((CompositeEntity)FSMGraphModel.this.getPtolemyModel()).getRelation(relationNameToAdd);
                        link.setRelation(relation);
                    }
                }
            };
            request.addChangeListener(new ChangeListener(){

                public void changeFailed(ChangeRequest change, Exception exception) {
                    FSMGraphModel.this._linkSet.remove(link);
                    link.setHead(null);
                    link.setTail(null);
                    link.setRelation(null);
                    MoMLChangeRequest requestChange = new MoMLChangeRequest((Object)FSMGraphModel.this, container, failmoml.toString());
                    container.requestChange((ChangeRequest)requestChange);
                }

                public void changeExecuted(ChangeRequest change) {
                    if (GraphUtilities.isPartiallyContainedEdge((Object)edge, (Object)FSMGraphModel.this.getRoot(), (GraphModel)FSMGraphModel.this)) {
                        FSMGraphModel.this._linkSet.add(edge);
                    } else {
                        FSMGraphModel.this._linkSet.remove(edge);
                    }
                }
            });
            request.setUndoable(true);
            container.requestChange((ChangeRequest)request);
        }

        public void setTail(final Object edge, final Object newArcTail) {
            final Arc link = (Arc)edge;
            NamedObj linkHead = (NamedObj)link.getHead();
            NamedObj linkTail = (NamedObj)link.getTail();
            ComponentRelation linkRelation = link.getRelation();
            StringBuffer moml = new StringBuffer();
            final StringBuffer failmoml = new StringBuffer();
            moml.append("<group>\n");
            failmoml.append("<group>\n");
            final NamedObj container = FSMGraphModel.this.getPtolemyModel();
            if (linkRelation != null) {
                if (newArcTail == null) {
                    moml.append(this._deleteRelation(container, (Relation)linkRelation));
                } else {
                    moml.append(this._unlinkTail(container, linkTail, (Relation)linkRelation));
                }
            }
            String relationName = null;
            if (newArcTail != null) {
                relationName = this._linkTail(container, moml, failmoml, linkHead, (NamedObj)newArcTail, (Relation)linkRelation);
            }
            moml.append("</group>\n");
            failmoml.append("</group>\n");
            final String relationNameToAdd = relationName;
            MoMLChangeRequest request = new MoMLChangeRequest((Object)FSMGraphModel.this, container, moml.toString()){

                protected void _execute() throws Exception {
                    super._execute();
                    link.setTail(newArcTail);
                    if (relationNameToAdd != null) {
                        link.setRelation(((CompositeEntity)FSMGraphModel.this.getPtolemyModel()).getRelation(relationNameToAdd));
                    }
                }
            };
            request.addChangeListener(new ChangeListener(){

                public void changeFailed(ChangeRequest change, Exception exception) {
                    FSMGraphModel.this._linkSet.remove(link);
                    link.setHead(null);
                    link.setTail(null);
                    link.setRelation(null);
                    MoMLChangeRequest requestChange = new MoMLChangeRequest((Object)FSMGraphModel.this, container, failmoml.toString());
                    container.requestChange((ChangeRequest)requestChange);
                }

                public void changeExecuted(ChangeRequest change) {
                    if (GraphUtilities.isPartiallyContainedEdge((Object)edge, (Object)FSMGraphModel.this.getRoot(), (GraphModel)FSMGraphModel.this)) {
                        FSMGraphModel.this._linkSet.add(edge);
                    } else {
                        FSMGraphModel.this._linkSet.remove(edge);
                    }
                }
            });
            request.setUndoable(true);
            container.requestChange((ChangeRequest)request);
        }

        private String _deleteRelation(NamedObj container, Relation relation) {
            return "<deleteRelation name=\"" + relation.getName(container) + "\"/>\n";
        }

        private String _linkHead(NamedObj container, StringBuffer moml, StringBuffer failmoml, NamedObj linkHead, NamedObj linkTail, Relation linkRelation) {
            if (linkHead != null && linkTail != null) {
                NamedObj head = (NamedObj)FSMGraphModel.this.getSemanticObject(linkHead);
                NamedObj tail = (NamedObj)FSMGraphModel.this.getSemanticObject(linkTail);
                if (head instanceof State && tail instanceof State) {
                    State headState = (State)head;
                    State tailState = (State)tail;
                    ComponentPort headPort = headState.incomingPort;
                    ComponentPort tailPort = tailState.outgoingPort;
                    NamedObj ptolemyModel = FSMGraphModel.this.getPtolemyModel();
                    if (ptolemyModel != container) {
                        String contextString = "<entity name=\"" + ptolemyModel.getName(container) + "\">\n";
                        moml.append(contextString);
                        failmoml.append(contextString);
                    }
                    boolean createdNewRelation = false;
                    String relationName = null;
                    if (linkRelation != null) {
                        relationName = linkRelation.getName(ptolemyModel);
                    } else {
                        createdNewRelation = true;
                        relationName = ptolemyModel.uniqueName("relation");
                        Iterator ports = tailPort.deepConnectedPortList().iterator();
                        int count = 0;
                        while (ports.hasNext()) {
                            if (ports.next() != headPort) continue;
                            ++count;
                        }
                        double angle = headPort.getContainer() != tailPort.getContainer() ? 0.6283185307179586 + 1.5 * Math.atan(0.3 * (double)count) : 1.0471975511965976 - 0.75 * Math.atan(0.3 * (double)count);
                        moml.append("<relation name=\"" + relationName + "\"><property name=\"exitAngle\" value=\"" + angle + "\"/></relation>\n");
                        moml.append("<link port=\"" + tailPort.getName(ptolemyModel) + "\" relation=\"" + relationName + "\"/>\n");
                    }
                    moml.append("<link port=\"" + headPort.getName(ptolemyModel) + "\" relation=\"" + relationName + "\"/>\n");
                    failmoml.append("<unlink port=\"" + headPort.getName(ptolemyModel) + "\" relation=\"" + relationName + "\"/>\n");
                    if (linkRelation == null) {
                        failmoml.append("<unlink port=\"" + tailPort.getName(ptolemyModel) + "\" relation=\"" + relationName + "\"/>\n");
                        failmoml.append("<deleteRelation name=\"" + relationName + "\"/>\n");
                    }
                    if (ptolemyModel != container) {
                        moml.append("</entity>");
                        failmoml.append("</entity>");
                    }
                    if (createdNewRelation) {
                        return relationName;
                    }
                    return null;
                }
                throw new RuntimeException("Attempt to create a link between non-states: Head = " + head + ", Tail = " + tail);
            }
            return null;
        }

        private String _linkTail(NamedObj container, StringBuffer moml, StringBuffer failmoml, NamedObj linkHead, NamedObj linkTail, Relation linkRelation) {
            if (linkHead != null && linkTail != null) {
                NamedObj head = (NamedObj)FSMGraphModel.this.getSemanticObject(linkHead);
                NamedObj tail = (NamedObj)FSMGraphModel.this.getSemanticObject(linkTail);
                if (head instanceof State && tail instanceof State) {
                    State headState = (State)head;
                    State tailState = (State)tail;
                    ComponentPort headPort = headState.incomingPort;
                    ComponentPort tailPort = tailState.outgoingPort;
                    NamedObj ptolemyModel = FSMGraphModel.this.getPtolemyModel();
                    if (ptolemyModel != container) {
                        String contextString = "<entity name=\"" + ptolemyModel.getName(container) + "\">\n";
                        moml.append(contextString);
                        failmoml.append(contextString);
                    }
                    boolean createdNewRelation = false;
                    String relationName = null;
                    if (linkRelation != null) {
                        relationName = linkRelation.getName(ptolemyModel);
                    } else {
                        createdNewRelation = true;
                        relationName = ptolemyModel.uniqueName("relation");
                        moml.append("<relation name=\"" + relationName + "\"/>\n");
                        moml.append("<link port=\"" + headPort.getName(ptolemyModel) + "\" relation=\"" + relationName + "\"/>\n");
                    }
                    moml.append("<link port=\"" + tailPort.getName(ptolemyModel) + "\" relation=\"" + relationName + "\"/>\n");
                    failmoml.append("<unlink port=\"" + tailPort.getName(ptolemyModel) + "\" relation=\"" + relationName + "\"/>\n");
                    if (linkRelation == null) {
                        failmoml.append("<unlink port=\"" + headPort.getName(ptolemyModel) + "\" relation=\"" + relationName + "\"/>\n");
                        failmoml.append("<deleteRelation name=\"" + relationName + "\"/>\n");
                    }
                    if (ptolemyModel != container) {
                        moml.append("</entity>");
                        failmoml.append("</entity>");
                    }
                    if (createdNewRelation) {
                        return relationName;
                    }
                    return null;
                }
                throw new RuntimeException("Attempt to create a link between non-states: Head = " + head + ", Tail = " + tail);
            }
            return null;
        }

        private String _unlinkHead(NamedObj container, NamedObj linkHead, Relation relation) {
            NamedObj head = (NamedObj)FSMGraphModel.this.getSemanticObject(linkHead);
            State headState = (State)head;
            ComponentPort headPort = headState.incomingPort;
            return "<unlink port=\"" + headPort.getName(container) + "\" relation=\"" + relation.getName(container) + "\"/>\n";
        }

        private String _unlinkTail(NamedObj container, NamedObj linkTail, Relation relation) {
            NamedObj tail = (NamedObj)FSMGraphModel.this.getSemanticObject(linkTail);
            State tailState = (State)tail;
            ComponentPort tailPort = tailState.outgoingPort;
            return "<unlink port=\"" + tailPort.getName(container) + "\" relation=\"" + relation.getName(container) + "\"/>\n";
        }
    }

    public class PortModel
    extends NamedObjNodeModel {
        public String getDeleteNodeMoML(Object node) {
            NamedObj deleteObj = ((Locatable)node).getContainer();
            String moml = "<deletePort name=\"" + deleteObj.getName() + "\"/>\n";
            return moml;
        }

        public Object getParent(Object node) {
            return ((Locatable)node).getContainer().getContainer();
        }

        public Iterator inEdges(Object node) {
            return new NullIterator();
        }

        public Iterator outEdges(Object node) {
            return new NullIterator();
        }

        public void removeNode(final Object eventSource, Object node) {
            NamedObj deleteObj = ((Locatable)node).getContainer();
            String elementName = null;
            if (!(deleteObj instanceof ComponentPort)) {
                throw new InternalErrorException("Attempt to remove a node that is not an Entity. node = " + node);
            }
            elementName = "deletePort";
            String moml = "<" + elementName + " name=\"" + deleteObj.getName() + "\"/>\n";
            NamedObj container = deleteObj.getContainer();
            MoMLChangeRequest request = new MoMLChangeRequest((Object)FSMGraphModel.this, container, moml);
            request.setUndoable(true);
            request.addChangeListener(new ChangeListener(){

                public void changeFailed(ChangeRequest change, Exception exception) {
                    FSMGraphModel.this.dispatchGraphEvent(new GraphEvent(eventSource, 30, FSMGraphModel.this.getRoot()));
                }

                public void changeExecuted(ChangeRequest change) {
                    FSMGraphModel.this.dispatchGraphEvent(new GraphEvent(eventSource, 30, FSMGraphModel.this.getRoot()));
                }
            });
            request.setUndoable(true);
            container.requestChange((ChangeRequest)request);
        }
    }

    public class StateModel
    extends NamedObjNodeModel {
        public String getDeleteNodeMoML(Object node) {
            NamedObj deleteObj = ((Locatable)node).getContainer();
            NamedObj container = deleteObj.getContainer();
            StringBuffer moml = new StringBuffer("<group>\n");
            moml.append("<deleteEntity name=\"" + deleteObj.getName(container) + "\"/>\n");
            CompositeEntity master = (CompositeEntity)deleteObj.getContainer();
            if (master != null) {
                TypedActor[] refinements = null;
                try {
                    refinements = ((State)deleteObj).getRefinement();
                }
                catch (IllegalActionException illegalActionException) {}
                if (refinements != null) {
                    int i = 0;
                    while (i < refinements.length) {
                        TypedActor refinement = refinements[i];
                        boolean removeIt = true;
                        Iterator states = master.entityList(State.class).iterator();
                        block7: while (removeIt && states.hasNext()) {
                            State state = (State)states.next();
                            if (state == deleteObj) continue;
                            TypedActor[] stateRefinements = null;
                            try {
                                stateRefinements = state.getRefinement();
                            }
                            catch (IllegalActionException illegalActionException) {}
                            if (stateRefinements == null) continue;
                            int j = 0;
                            while (j < stateRefinements.length) {
                                if (stateRefinements[j] == refinement) {
                                    removeIt = false;
                                    continue block7;
                                }
                                ++j;
                            }
                        }
                        Iterator transitions = master.relationList().iterator();
                        block9: while (removeIt && transitions.hasNext()) {
                            Relation transition = (Relation)transitions.next();
                            if (!(transition instanceof Transition)) continue;
                            TypedActor[] transitionRefinements = null;
                            try {
                                transitionRefinements = ((Transition)transition).getRefinement();
                            }
                            catch (IllegalActionException illegalActionException) {}
                            if (transitionRefinements == null) continue;
                            int j = 0;
                            while (j < transitionRefinements.length) {
                                if (transitionRefinements[j] == refinement) {
                                    removeIt = false;
                                    continue block9;
                                }
                                ++j;
                            }
                        }
                        if (removeIt) {
                            moml.append("<deleteEntity name=\"" + ((NamedObj)refinement).getName(container) + "\"/>\n");
                        }
                        ++i;
                    }
                }
            }
            moml.append("</group>\n");
            return moml.toString();
        }

        public Object getParent(Object node) {
            return ((Locatable)node).getContainer().getContainer();
        }

        public Iterator inEdges(Object node) {
            Locatable icon = (Locatable)node;
            LinkedList<Arc> stateLinkList = new LinkedList<Arc>();
            for (Arc link : FSMGraphModel.this._linkSet) {
                NamedObj head = (NamedObj)link.getHead();
                if (head == null || !head.equals(icon)) continue;
                stateLinkList.add(link);
            }
            return stateLinkList.iterator();
        }

        public Iterator outEdges(Object node) {
            Locatable icon = (Locatable)node;
            LinkedList<Arc> stateLinkList = new LinkedList<Arc>();
            for (Arc link : FSMGraphModel.this._linkSet) {
                Object tail = link.getTail();
                if (tail == null || !tail.equals(icon)) continue;
                stateLinkList.add(link);
            }
            return stateLinkList.iterator();
        }

        public void removeNode(final Object eventSource, Object node) {
            NamedObj deleteObj = ((Locatable)node).getContainer();
            Iterator inEdges = this.inEdges(node);
            while (inEdges.hasNext()) {
                FSMGraphModel.this.disconnectEdge(eventSource, inEdges.next());
            }
            Iterator outEdges = this.outEdges(node);
            while (outEdges.hasNext()) {
                FSMGraphModel.this.disconnectEdge(eventSource, outEdges.next());
            }
            String elementName = null;
            if (!(deleteObj instanceof ComponentEntity)) {
                throw new InternalErrorException("Attempt to remove a node that is not an Entity. node = " + node);
            }
            elementName = "deleteEntity";
            String moml = "<" + elementName + " name=\"" + deleteObj.getName() + "\"/>\n";
            NamedObj container = deleteObj.getContainer();
            MoMLChangeRequest request = new MoMLChangeRequest((Object)FSMGraphModel.this, container, moml);
            request.addChangeListener(new ChangeListener(){

                public void changeFailed(ChangeRequest change, Exception exception) {
                    FSMGraphModel.this.dispatchGraphEvent(new GraphEvent(eventSource, 30, FSMGraphModel.this.getRoot()));
                }

                public void changeExecuted(ChangeRequest change) {
                    FSMGraphModel.this.dispatchGraphEvent(new GraphEvent(eventSource, 30, FSMGraphModel.this.getRoot()));
                }
            });
            request.setUndoable(true);
            container.requestChange((ChangeRequest)request);
        }
    }
}

