/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.vergil.fsm;

import diva.canvas.DamageRegion;
import diva.graph.GraphController;
import diva.graph.GraphModel;
import diva.graph.GraphPane;
import diva.gui.GUIUtilities;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import ptolemy.actor.gui.DebugListenerTableau;
import ptolemy.actor.gui.Effigy;
import ptolemy.actor.gui.PtolemyPreferences;
import ptolemy.actor.gui.Tableau;
import ptolemy.actor.gui.TextEffigy;
import ptolemy.domains.fsm.kernel.FSMActor;
import ptolemy.gui.ComponentDialog;
import ptolemy.gui.Query;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.DebugListener;
import ptolemy.kernel.util.Debuggable;
import ptolemy.kernel.util.KernelException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.moml.LibraryAttribute;
import ptolemy.util.CancelException;
import ptolemy.util.MessageHandler;
import ptolemy.vergil.basic.ExtendedGraphFrame;
import ptolemy.vergil.fsm.FSMGraphController;
import ptolemy.vergil.fsm.FSMGraphModel;

public class FSMGraphFrame
extends ExtendedGraphFrame {
    protected FSMGraphController _controller;
    protected JMenu _debugMenu;
    protected JMenu _graphMenu;
    protected Action _layoutAction;
    private long _lastDelayTime = 0L;

    public FSMGraphFrame(CompositeEntity entity, Tableau tableau) {
        this(entity, tableau, null);
    }

    public FSMGraphFrame(CompositeEntity entity, Tableau tableau, LibraryAttribute defaultLibrary) {
        super(entity, tableau, defaultLibrary);
        this.helpFile = "ptolemy/configs/doc/vergilFsmEditorHelp.htm";
        this._layoutAction = new LayoutAction();
    }

    protected void _addMenus() {
        super._addMenus();
        this._graphMenu = new JMenu("Graph");
        this._graphMenu.setMnemonic(71);
        this._menubar.add(this._graphMenu);
        GUIUtilities.addHotKey((JComponent)this._getRightComponent(), (Action)this._layoutAction);
        GUIUtilities.addMenuItem((JMenu)this._graphMenu, (Action)this._layoutAction);
        this._graphMenu.addSeparator();
        this._controller.addToMenuAndToolbar(this._graphMenu, this._toolbar);
        JMenuItem[] debugMenuItems = new JMenuItem[]{new JMenuItem("Listen to Director", 68), new JMenuItem("Listen to State Machine", 76), new JMenuItem("Animate States", 65), new JMenuItem("Stop Animating", 83)};
        this._debugMenu = new JMenu("Debug");
        this._debugMenu.setMnemonic(68);
        DebugMenuListener debugMenuListener = new DebugMenuListener();
        int i = 0;
        while (i < debugMenuItems.length) {
            debugMenuItems[i].setActionCommand(debugMenuItems[i].getText());
            debugMenuItems[i].addActionListener(debugMenuListener);
            this._debugMenu.add(debugMenuItems[i]);
            ++i;
        }
        this._menubar.add(this._debugMenu);
    }

    protected boolean _close() {
        this.getModel().removeDebugListener((DebugListener)this._controller);
        return super._close();
    }

    protected GraphPane _createGraphPane(NamedObj entity) {
        this._controller = new FSMGraphController();
        this._controller.setConfiguration(this.getConfiguration());
        this._controller.setFrame(this);
        FSMGraphModel graphModel = new FSMGraphModel((CompositeEntity)entity);
        return new FSMGraphPane(this._controller, graphModel, entity);
    }

    public class DebugMenuListener
    implements ActionListener {
        private NamedObj _listeningTo;

        public void actionPerformed(ActionEvent e) {
            block12: {
                JMenuItem target = (JMenuItem)e.getSource();
                String actionCommand = target.getActionCommand();
                try {
                    if (actionCommand.equals("Listen to Director")) {
                        Effigy effigy = (Effigy)FSMGraphFrame.this.getTableau().getContainer();
                        TextEffigy textEffigy = new TextEffigy(effigy, effigy.uniqueName("debug listener"));
                        DebugListenerTableau tableau = new DebugListenerTableau(textEffigy, textEffigy.uniqueName("debugListener"));
                        tableau.setDebuggable((Debuggable)((FSMActor)FSMGraphFrame.this.getModel()).getDirector());
                        break block12;
                    }
                    if (actionCommand.equals("Listen to State Machine")) {
                        Effigy effigy = (Effigy)FSMGraphFrame.this.getTableau().getContainer();
                        TextEffigy textEffigy = new TextEffigy(effigy, effigy.uniqueName("debug listener"));
                        DebugListenerTableau tableau = new DebugListenerTableau(textEffigy, textEffigy.uniqueName("debugListener"));
                        tableau.setDebuggable((Debuggable)FSMGraphFrame.this.getModel());
                        break block12;
                    }
                    if (actionCommand.equals("Animate States")) {
                        Query query = new Query();
                        query.addLine("delay", "Time (in ms) to hold highlight", Long.toString(FSMGraphFrame.this._lastDelayTime));
                        ComponentDialog dialog = new ComponentDialog((Frame)FSMGraphFrame.this, "Delay for Animation", query);
                        if (!dialog.buttonPressed().equals("OK")) break block12;
                        try {
                            FSMGraphFrame.this._lastDelayTime = Long.parseLong(query.getStringValue("delay"));
                            FSMGraphFrame.this._controller.setAnimationDelay(FSMGraphFrame.this._lastDelayTime);
                            NamedObj model = FSMGraphFrame.this.getModel();
                            if (model != null && this._listeningTo != model) {
                                if (this._listeningTo != null) {
                                    this._listeningTo.removeDebugListener((DebugListener)FSMGraphFrame.this._controller);
                                }
                                this._listeningTo = model;
                                this._listeningTo.addDebugListener((DebugListener)FSMGraphFrame.this._controller);
                            }
                            break block12;
                        }
                        catch (NumberFormatException ex) {
                            MessageHandler.error((String)"Invalid time, which is required to be an integer: ", (Throwable)ex);
                        }
                        break block12;
                    }
                    if (actionCommand.equals("Stop Animating") && this._listeningTo != null) {
                        this._listeningTo.removeDebugListener((DebugListener)FSMGraphFrame.this._controller);
                        FSMGraphFrame.this._controller.clearAnimation();
                        this._listeningTo = null;
                    }
                }
                catch (KernelException ex) {
                    try {
                        MessageHandler.warning((String)("Failed to create debug listener: " + (Object)((Object)ex)));
                    }
                    catch (CancelException cancelException) {}
                }
            }
        }
    }

    private class FSMGraphPane
    extends GraphPane {
        private NamedObj _entity;

        public FSMGraphPane(FSMGraphController controller, FSMGraphModel model, NamedObj entity) {
            super((GraphController)controller, (GraphModel)model);
            this._entity = entity;
        }

        public void repaint() {
            this._setBackground();
            super.repaint();
        }

        public void repaint(DamageRegion damage) {
            this._setBackground();
            super.repaint(damage);
        }

        private void _setBackground() {
            List list;
            if (this._entity != null && (list = this._entity.attributeList(PtolemyPreferences.class)).size() > 0) {
                PtolemyPreferences preferences = (PtolemyPreferences)((Object)list.get(list.size() - 1));
                this.getCanvas().setBackground(preferences.backgroundColor.asColor());
            }
        }
    }

    private class LayoutAction
    extends AbstractAction {
        public LayoutAction() {
            super("Automatic Layout");
            this.putValue("tooltip", "Layout the Graph (Ctrl+T)");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(84, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            this.putValue("MnemonicKey", 76);
        }

        public void actionPerformed(ActionEvent e) {
            try {
                FSMGraphFrame.this.layoutGraph();
            }
            catch (Exception ex) {
                MessageHandler.error((String)"Layout failed", (Throwable)ex);
            }
        }
    }
}

