/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.vergil.fsm;

import diva.canvas.JCanvas;
import diva.canvas.event.LayerAdapter;
import diva.canvas.event.LayerEvent;
import diva.canvas.event.LayerListener;
import diva.graph.GraphController;
import diva.graph.GraphModel;
import diva.graph.GraphPane;
import diva.graph.JGraph;
import diva.gui.GUIUtilities;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import ptolemy.actor.IOPort;
import ptolemy.actor.gui.Tableau;
import ptolemy.actor.lib.hoc.Case;
import ptolemy.actor.lib.hoc.Refinement;
import ptolemy.actor.lib.hoc.RefinementPort;
import ptolemy.gui.ComponentDialog;
import ptolemy.gui.Query;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.Port;
import ptolemy.kernel.util.ChangeRequest;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.moml.LibraryAttribute;
import ptolemy.moml.MoMLChangeRequest;
import ptolemy.util.MessageHandler;
import ptolemy.util.StringUtilities;
import ptolemy.vergil.actor.ActorEditorGraphController;
import ptolemy.vergil.actor.ActorGraphFrame;
import ptolemy.vergil.actor.ActorGraphModel;
import ptolemy.vergil.basic.EditorDropTarget;
import ptolemy.vergil.toolbox.FigureAction;

public class CaseGraphFrame
extends ActorGraphFrame
implements ChangeListener {
    protected JMenu _caseMenu;
    private AddCaseAction _addCaseAction;
    private Case _case;
    private RemoveCaseAction _removeCaseAction;
    private JTabbedPane _tabbedPane;

    public CaseGraphFrame(Case entity, Tableau tableau) {
        this(entity, tableau, null);
    }

    public CaseGraphFrame(Case entity, Tableau tableau, LibraryAttribute defaultLibrary) {
        super((CompositeEntity)entity, tableau, defaultLibrary);
        this._case = entity;
        this._addCaseAction = new AddCaseAction();
        this._removeCaseAction = new RemoveCaseAction();
    }

    public void stateChanged(ChangeEvent event) {
        Object source = event.getSource();
        if (source instanceof JTabbedPane) {
            Component selected = ((JTabbedPane)source).getSelectedComponent();
            if (selected instanceof JGraph) {
                this.setJGraph((JGraph)selected);
            }
            if (this._graphPanner != null) {
                this._graphPanner.setCanvas((JCanvas)((JGraph)selected));
                this._graphPanner.repaint();
            }
        }
    }

    protected void _addMenus() {
        super._addMenus();
        this._caseMenu = new JMenu("Case");
        this._caseMenu.setMnemonic(67);
        this._menubar.add(this._caseMenu);
        GUIUtilities.addHotKey((JComponent)this._getRightComponent(), (Action)this._addCaseAction);
        GUIUtilities.addMenuItem((JMenu)this._caseMenu, (Action)this._addCaseAction);
        GUIUtilities.addHotKey((JComponent)this._getRightComponent(), (Action)this._removeCaseAction);
        GUIUtilities.addMenuItem((JMenu)this._caseMenu, (Action)this._removeCaseAction);
    }

    protected GraphPane _createGraphPane(NamedObj entity) {
        this._controller = new CaseGraphController();
        this._controller.setConfiguration(this.getConfiguration());
        this._controller.setFrame(this);
        ActorGraphModel graphModel = new ActorGraphModel(entity);
        return new GraphPane((GraphController)this._controller, (GraphModel)graphModel);
    }

    protected JComponent _createRightComponent(NamedObj entity) {
        if (!(entity instanceof Case)) {
            return super._createRightComponent(entity);
        }
        this._tabbedPane = new JTabbedPane();
        this._tabbedPane.addChangeListener(this);
        Iterator cases = ((Case)entity).entityList(Refinement.class).iterator();
        boolean first = true;
        while (cases.hasNext()) {
            Refinement refinement = (Refinement)cases.next();
            JGraph jgraph = this._addTabbedPane(refinement, false);
            if (!first) continue;
            first = false;
            this.setJGraph(jgraph);
        }
        return this._tabbedPane;
    }

    private JGraph _addTabbedPane(Refinement refinement, boolean newPane) {
        GraphPane pane = this._createGraphPane((NamedObj)refinement);
        pane.getForegroundLayer().setPickHalo(2.0);
        pane.getForegroundEventLayer().setConsuming(false);
        pane.getForegroundEventLayer().setEnabled(true);
        pane.getForegroundEventLayer().addLayerListener((LayerListener)new LayerAdapter(){

            public void mousePressed(LayerEvent event) {
                Component component = event.getComponent();
                if (!component.hasFocus()) {
                    component.requestFocus();
                }
            }
        });
        JGraph jgraph = new JGraph(pane);
        String name = refinement.getName();
        jgraph.setName(name);
        int index = this._tabbedPane.getComponentCount();
        if (newPane) {
            --index;
        }
        this._tabbedPane.add((Component)jgraph, index);
        jgraph.setBackground(BACKGROUND_COLOR);
        new EditorDropTarget(jgraph);
        return jgraph;
    }

    public class AddCaseAction
    extends FigureAction {
        public AddCaseAction() {
            super("Add Case");
            this.putValue("MnemonicKey", 65);
        }

        public void actionPerformed(ActionEvent e) {
            super.actionPerformed(e);
            Query query = new Query();
            query.addLine("case", "Pattern that the control input must match", "");
            ComponentDialog dialog = new ComponentDialog((Frame)CaseGraphFrame.this, "Add Case", query);
            if (dialog.buttonPressed().equals("OK")) {
                final String pattern = query.getStringValue("case");
                String moml = "<entity name=\"" + StringUtilities.escapeForXML((String)pattern) + "\" class=\"" + CaseGraphFrame.this._case.refinementClassName() + "\"/>";
                MoMLChangeRequest change = new MoMLChangeRequest(this, (NamedObj)CaseGraphFrame.this._case, moml){

                    protected void _execute() throws Exception {
                        super._execute();
                        Refinement entity = (Refinement)CaseGraphFrame.this._case.getEntity(pattern);
                        for (Port port : CaseGraphFrame.this._case.portList()) {
                            if (port == ((CaseGraphFrame)((AddCaseAction)AddCaseAction.this).CaseGraphFrame.this)._case.control.getPort()) continue;
                            try {
                                entity.setMirrorDisable(true);
                                Port newPort = entity.newPort(port.getName());
                                if (!(newPort instanceof RefinementPort) || !(port instanceof IOPort)) continue;
                                try {
                                    ((RefinementPort)newPort).setMirrorDisable(true);
                                    if (((IOPort)port).isInput()) {
                                        ((RefinementPort)newPort).setInput(true);
                                    }
                                    if (((IOPort)port).isOutput()) {
                                        ((RefinementPort)newPort).setOutput(true);
                                    }
                                    if (!((IOPort)port).isMultiport()) continue;
                                    ((RefinementPort)newPort).setMultiport(true);
                                }
                                finally {
                                    ((RefinementPort)newPort).setMirrorDisable(false);
                                }
                            }
                            finally {
                                entity.setMirrorDisable(false);
                            }
                        }
                        CaseGraphFrame.this._addTabbedPane(entity, true);
                    }
                };
                CaseGraphFrame.this._case.requestChange((ChangeRequest)change);
            }
        }
    }

    public class CaseGraphController
    extends ActorEditorGraphController {
        public GraphModel getGraphModel() {
            Component tab;
            if (CaseGraphFrame.this._tabbedPane != null && (tab = CaseGraphFrame.this._tabbedPane.getSelectedComponent()) instanceof JGraph) {
                GraphPane pane = ((JGraph)tab).getGraphPane();
                return pane.getGraphModel();
            }
            return super.getGraphModel();
        }
    }

    public class RemoveCaseAction
    extends FigureAction {
        public RemoveCaseAction() {
            super("Remove Case");
            this.putValue("MnemonicKey", 82);
        }

        public void actionPerformed(ActionEvent e) {
            super.actionPerformed(e);
            Query query = new Query();
            List refinements = CaseGraphFrame.this._case.entityList(Refinement.class);
            if (refinements.size() < 2) {
                MessageHandler.error((String)"No cases to remove.");
            } else {
                String[] caseNames = new String[refinements.size() - 1];
                Iterator cases = refinements.iterator();
                int i = 0;
                while (cases.hasNext()) {
                    String name = ((Nameable)cases.next()).getName();
                    if (name.equals("default")) continue;
                    caseNames[i] = name;
                    ++i;
                }
                query.addChoice("case", "Remove case", caseNames, caseNames[0]);
                ComponentDialog dialog = new ComponentDialog((Frame)CaseGraphFrame.this, "Remove Case", query);
                if (dialog.buttonPressed().equals("OK")) {
                    final String name = query.getStringValue("case");
                    String moml = "<deleteEntity name=\"" + StringUtilities.escapeForXML((String)name) + "\"/>";
                    MoMLChangeRequest change = new MoMLChangeRequest(this, (NamedObj)CaseGraphFrame.this._case, moml){

                        protected void _execute() throws Exception {
                            super._execute();
                            int count = CaseGraphFrame.this._tabbedPane.getTabCount();
                            int i = 0;
                            while (i < count) {
                                if (name.equals(CaseGraphFrame.this._tabbedPane.getTitleAt(i))) {
                                    CaseGraphFrame.this._tabbedPane.remove(i);
                                    break;
                                }
                                ++i;
                            }
                        }
                    };
                    CaseGraphFrame.this._case.requestChange((ChangeRequest)change);
                }
            }
        }
    }
}

