/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.vergil.debugger;

import diva.gui.toolbox.JContextMenu;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenuItem;
import ptolemy.actor.Actor;
import ptolemy.kernel.ComponentEntity;
import ptolemy.kernel.Entity;
import ptolemy.kernel.util.NamedObj;
import ptolemy.util.MessageHandler;
import ptolemy.vergil.basic.BasicGraphController;
import ptolemy.vergil.debugger.BreakpointConfigurerDialog;
import ptolemy.vergil.toolbox.MenuItemFactory;

public class BreakpointDialogFactory
implements MenuItemFactory {
    private BasicGraphController _graphController;

    public BreakpointDialogFactory(BasicGraphController graphController) {
        this._graphController = graphController;
    }

    public JMenuItem create(final JContextMenu menu, NamedObj object) {
        String name = "Set Breakpoints";
        final NamedObj target = object;
        if (!(target instanceof ComponentEntity && ((ComponentEntity)target).isOpaque() && target instanceof Actor && ((Actor)target).getExecutiveDirector() != null)) {
            return null;
        }
        AbstractAction action = new AbstractAction(name){

            public void actionPerformed(ActionEvent e) {
                try {
                    Component parent = menu.getInvoker();
                    while (parent.getParent() != null) {
                        parent = parent.getParent();
                    }
                    if (parent instanceof Frame) {
                        new BreakpointConfigurerDialog((Frame)parent, (Entity)target, BreakpointDialogFactory.this._graphController);
                    } else {
                        new BreakpointConfigurerDialog(null, (Entity)target, BreakpointDialogFactory.this._graphController);
                    }
                }
                catch (Throwable throwable) {
                    MessageHandler.error((String)"Failed to create Breakpoint dialog.", (Throwable)throwable);
                }
            }
        };
        return menu.add((Action)action, name);
    }
}

