/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.vergil.basic;

import diva.canvas.JCanvas;
import diva.gui.GUIUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import ptolemy.actor.gui.Tableau;
import ptolemy.gui.GraphicalMessageHandler;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.NamedObj;
import ptolemy.moml.LibraryAttribute;
import ptolemy.vergil.basic.BasicGraphFrame;

public abstract class ExtendedGraphFrame
extends BasicGraphFrame {
    private Action _fullScreenAction = new FullScreenAction("Full Screen");
    private Component _previousDefaultContext;
    private JDialog _screen;

    public ExtendedGraphFrame(CompositeEntity entity, Tableau tableau) {
        this(entity, tableau, null);
    }

    public ExtendedGraphFrame(CompositeEntity entity, Tableau tableau, LibraryAttribute defaultLibrary) {
        super((NamedObj)entity, tableau, defaultLibrary);
        GUIUtilities.addToolBarButton((JToolBar)this._toolbar, (Action)this._fullScreenAction);
    }

    public void cancelFullScreen() {
        if (this._screen == null) {
            return;
        }
        this._screen.dispose();
        this._screen = null;
        this._splitPane.setRightComponent(this._getRightComponent());
        this._graphPanner.setCanvas((JCanvas)this.getJGraph());
        this.pack();
        this.show();
        GraphicalMessageHandler.setContext(this._previousDefaultContext);
        this.toFront();
        this._getRightComponent().requestFocus();
    }

    public void fullScreen() {
        if (this._screen != null) {
            this._screen.toFront();
            return;
        }
        this._screen = new JDialog();
        this._screen.getContentPane().setLayout(new BorderLayout());
        Toolkit toolkit = this._screen.getToolkit();
        int width = toolkit.getScreenSize().width;
        int height = toolkit.getScreenSize().height;
        this._screen.setSize(width, height);
        this._screen.setUndecorated(true);
        this._screen.getContentPane().add((Component)this.getJGraph(), "Center");
        this._screen.setVisible(true);
        this._previousDefaultContext = GraphicalMessageHandler.getContext();
        GraphicalMessageHandler.setContext(this._screen);
        this._screen.toFront();
        this.getJGraph().requestFocus();
        this._screen.setResizable(false);
        ActionMap actionMap = this.getJGraph().getActionMap();
        actionMap.put(this._fullScreenAction, this._fullScreenAction);
        InputMap inputMap = this.getJGraph().getInputMap();
        inputMap.put(KeyStroke.getKeyStroke("ESCAPE"), this._fullScreenAction);
        this._graphPanner.setCanvas(null);
        this.setVisible(false);
    }

    protected void _addMenus() {
        super._addMenus();
        this._viewMenu.addSeparator();
        GUIUtilities.addHotKey((JComponent)this._getRightComponent(), (Action)this._fullScreenAction);
        GUIUtilities.addMenuItem((JMenu)this._viewMenu, (Action)this._fullScreenAction);
    }

    public class FullScreenAction
    extends AbstractAction
    implements KeyListener {
        public FullScreenAction(String description) {
            super(description);
            GUIUtilities.addIcons((Action)this, (String[][])new String[][]{{"/ptolemy/vergil/basic/img/fullscreen.gif", "LargeIcon"}, {"/ptolemy/vergil/basic/img/fullscreen_o.gif", "rolloverIcon"}, {"/ptolemy/vergil/basic/img/fullscreen_ov.gif", "rolloverSelectedIcon"}, {"/ptolemy/vergil/basic/img/fullscreen_on.gif", "selectedIcon"}});
            this.putValue("tooltip", description);
            this.putValue("MnemonicKey", 83);
        }

        public void actionPerformed(ActionEvent e) {
            if (ExtendedGraphFrame.this._screen == null) {
                ExtendedGraphFrame.this.fullScreen();
            } else {
                ExtendedGraphFrame.this.cancelFullScreen();
            }
        }

        public void keyPressed(KeyEvent e) {
            if (ExtendedGraphFrame.this._screen != null) {
                ExtendedGraphFrame.this.cancelFullScreen();
            }
        }

        public void keyReleased(KeyEvent e) {
            if (ExtendedGraphFrame.this._screen != null) {
                ExtendedGraphFrame.this.cancelFullScreen();
            }
        }

        public void keyTyped(KeyEvent e) {
            if (ExtendedGraphFrame.this._screen != null) {
                ExtendedGraphFrame.this.cancelFullScreen();
            }
        }
    }
}

