/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.vergil.basic;

import java.awt.Frame;
import java.util.List;
import ptolemy.actor.gui.EditorFactory;
import ptolemy.actor.gui.Effigy;
import ptolemy.actor.gui.TableauFrame;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.KernelException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.util.MessageHandler;
import ptolemy.vergil.actor.DocEffigy;
import ptolemy.vergil.actor.DocTableau;
import ptolemy.vergil.basic.DocAttribute;

public class DocViewerFactory
extends EditorFactory {
    public DocViewerFactory(NamedObj container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
    }

    public void createEditor(NamedObj object, Frame parent) {
        NamedObj container = object.getContainer();
        if (container != null) {
            List docAttributes = container.attributeList(DocAttribute.class);
            if (docAttributes.size() < 1) {
                MessageHandler.message((String)"To create documentation, right click on the background and select 'Documentation->Customize Documentation'");
                return;
            }
            DocAttribute doc = (DocAttribute)((Object)docAttributes.get(0));
            if (!(parent instanceof TableauFrame)) {
                MessageHandler.error((String)"Cannot display documentation!");
            }
            Effigy effigy = ((TableauFrame)parent).getEffigy();
            try {
                DocEffigy newEffigy = new DocEffigy((CompositeEntity)effigy.getContainer(), effigy.getContainer().uniqueName("parentClass"));
                newEffigy.setDocAttribute(doc);
                DocTableau tableau = new DocTableau(newEffigy, "docTableau");
                tableau.show();
            }
            catch (KernelException e) {
                MessageHandler.error((String)"Error opening documentation", (Throwable)e);
            }
            return;
        }
        MessageHandler.error((String)"Need a container to document.");
    }
}

