/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.vergil.basic;

import diva.graph.GraphEvent;
import diva.graph.modular.CompositeModel;
import diva.graph.modular.ModularGraphModel;
import diva.graph.modular.NodeModel;
import java.util.List;
import ptolemy.data.ObjectToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Variable;
import ptolemy.kernel.Port;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.ChangeListener;
import ptolemy.kernel.util.ChangeRequest;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.Locatable;
import ptolemy.kernel.util.Location;
import ptolemy.kernel.util.NamedObj;
import ptolemy.util.MessageHandler;
import ptolemy.vergil.kernel.AttributeNodeModel;
import ptolemy.vergil.kernel.CompositePtolemyModel;

public abstract class AbstractBasicGraphModel
extends ModularGraphModel
implements ChangeListener {
    private AttributeNodeModel _attributeModel = new AttributeNodeModel();
    private NamedObj _composite;
    private CompositePtolemyModel _compositeModel = new CompositePtolemyModel();

    public AbstractBasicGraphModel(NamedObj composite) {
        super((Object)composite);
        this._composite = composite;
        composite.addChangeListener((ChangeListener)this);
    }

    public void changeExecuted(ChangeRequest change) {
        if (change != null && change.getSource() == this) {
            return;
        }
        if (this._update()) {
            this.dispatchGraphEvent(new GraphEvent((Object)this, 30, this.getRoot()));
        }
    }

    public void changeFailed(ChangeRequest change, Exception exception) {
        if (change == null) {
            MessageHandler.error((String)"Change failed", (Throwable)exception);
        } else if (!change.isErrorReported()) {
            change.setErrorReported(true);
            MessageHandler.error((String)"Change failed", (Throwable)exception);
        }
        if (this._update()) {
            this.dispatchGraphEvent(new GraphEvent((Object)this, 30, this.getRoot()));
        }
    }

    public abstract void disconnectEdge(Object var1, Object var2);

    public abstract String getDeleteEdgeMoML(Object var1);

    public abstract String getDeleteNodeMoML(Object var1);

    public CompositeModel getCompositeModel(Object composite) {
        if (composite.equals(this._composite)) {
            return this._compositeModel;
        }
        return null;
    }

    public NodeModel getNodeModel(Object node) {
        if (node instanceof Locatable && ((Locatable)node).getContainer() instanceof Attribute) {
            return this._attributeModel;
        }
        return null;
    }

    public Object getProperty(Object object, String propertyName) {
        try {
            NamedObj namedObject = (NamedObj)object;
            Attribute a = namedObject.getAttribute(propertyName);
            Token t = ((Variable)a).getToken();
            if (t instanceof ObjectToken) {
                return ((ObjectToken)t).getValue();
            }
            return t.toString();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public NamedObj getPtolemyModel() {
        return this._composite;
    }

    public Object getSemanticObject(Object element) {
        if (element instanceof Port) {
            return element;
        }
        if (element instanceof Locatable) {
            return ((Locatable)element).getContainer();
        }
        return null;
    }

    public boolean isNode(Object object) {
        NamedObj container;
        NodeModel nodeModel = this.getNodeModel(object);
        if (nodeModel != null) {
            return true;
        }
        return object instanceof Locatable && (container = ((Locatable)object).getContainer()) == null;
    }

    public abstract void removeNode(Object var1, Object var2);

    public void setProperty(Object object, String propertyName, Object value) {
        throw new UnsupportedOperationException("hack");
    }

    public void setSemanticObject(Object object, Object semantic) {
        throw new UnsupportedOperationException("Ptolemy Graph Model does not allow semantic objects to be changed");
    }

    public void removeListeners() {
        this._composite.removeChangeListener((ChangeListener)this);
    }

    protected Locatable _getLocation(NamedObj object) {
        List locations = object.attributeList(Locatable.class);
        if (locations.size() > 0) {
            return (Locatable)locations.get(0);
        }
        try {
            Location location = new Location(object, "_location");
            location.propagateExistence();
            return location;
        }
        catch (Exception e) {
            throw new InternalErrorException("Failed to create location, even though one does not exist:" + e.getMessage());
        }
    }

    protected boolean _update() {
        return true;
    }
}

