/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.vergil.actor;

import diva.canvas.Figure;
import diva.canvas.FigureDecorator;
import diva.canvas.Site;
import diva.canvas.connector.Connector;
import diva.canvas.connector.ConnectorAdapter;
import diva.canvas.connector.ConnectorEvent;
import diva.canvas.connector.ConnectorListener;
import diva.canvas.connector.ConnectorManipulator;
import diva.canvas.connector.ConnectorTarget;
import diva.canvas.connector.ManhattanConnector;
import diva.canvas.connector.PerimeterTarget;
import diva.canvas.connector.Terminal;
import diva.canvas.event.MouseFilter;
import diva.canvas.interactor.ActionInteractor;
import diva.canvas.interactor.Interactor;
import diva.canvas.interactor.SelectionInteractor;
import diva.canvas.interactor.SelectionModel;
import diva.canvas.toolbox.SVGUtilities;
import diva.graph.BasicEdgeController;
import diva.graph.EdgeRenderer;
import diva.graph.GraphController;
import diva.gui.toolbox.MenuCreator;
import diva.gui.toolbox.MenuFactory;
import java.awt.Paint;
import javax.swing.Action;
import ptolemy.actor.gui.ColorAttribute;
import ptolemy.actor.gui.Configuration;
import ptolemy.actor.gui.PtolemyPreferences;
import ptolemy.data.DoubleToken;
import ptolemy.data.Token;
import ptolemy.kernel.ComponentRelation;
import ptolemy.kernel.Port;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.Locatable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.StringAttribute;
import ptolemy.moml.Vertex;
import ptolemy.util.MessageHandler;
import ptolemy.vergil.actor.ActorGraphModel;
import ptolemy.vergil.actor.LinkManhattanConnector;
import ptolemy.vergil.basic.PopupMouseFilter;
import ptolemy.vergil.kernel.Link;
import ptolemy.vergil.toolbox.ConfigureAction;
import ptolemy.vergil.toolbox.MenuActionFactory;
import ptolemy.vergil.toolbox.PtolemyMenuFactory;

public class LinkController
extends BasicEdgeController {
    protected Configuration _configuration;
    protected static ConfigureAction _configureAction = new ConfigureAction("Configure");
    protected MenuCreator _menuCreator;
    protected PtolemyMenuFactory _menuFactory;

    public LinkController(GraphController controller) {
        super(controller);
        SelectionModel sm = controller.getSelectionModel();
        SelectionInteractor interactor = (SelectionInteractor)this.getEdgeInteractor();
        interactor.setSelectionModel(sm);
        ConnectorManipulator manipulator = new ConnectorManipulator();
        manipulator.setSnapHalo(4.0);
        manipulator.addConnectorListener((ConnectorListener)new LinkDropper());
        interactor.setPrototypeDecorator((FigureDecorator)manipulator);
        MouseFilter handleFilter = new MouseFilter(1, 0, 0);
        manipulator.setHandleFilter(handleFilter);
        LinkTarget ct = new LinkTarget();
        this.setConnectorTarget((ConnectorTarget)ct);
        this.setEdgeRenderer(new LinkRenderer());
        this._menuCreator = new MenuCreator(null);
        this._menuCreator.setMouseFilter((MouseFilter)new PopupMouseFilter());
        interactor.addInteractor((Interactor)this._menuCreator);
        this._menuFactory = new PtolemyMenuFactory(controller);
        this._menuFactory.addMenuItemFactory(new MenuActionFactory(_configureAction));
        this._menuCreator.setMenuFactory((MenuFactory)this._menuFactory);
        ActionInteractor doubleClickInteractor = new ActionInteractor((Action)_configureAction);
        doubleClickInteractor.setConsuming(false);
        doubleClickInteractor.setMouseFilter(new MouseFilter(1, 0, 0, 2));
        interactor.addInteractor((Interactor)doubleClickInteractor);
    }

    public void setConfiguration(Configuration configuration) {
        this._configuration = configuration;
    }

    protected class LinkDropper
    extends ConnectorAdapter {
        protected LinkDropper() {
        }

        public void connectorDropped(ConnectorEvent evt) {
            Connector c = evt.getConnector();
            Figure f = evt.getTarget();
            Link link = (Link)c.getUserObject();
            Object node = f == null ? null : f.getUserObject();
            ActorGraphModel model = (ActorGraphModel)LinkController.this.getController().getGraphModel();
            switch (evt.getEnd()) {
                case 21: {
                    if (node == link.getTail()) {
                        MessageHandler.error((String)"Cannot link both ends to the same object.");
                        return;
                    }
                    model.getLinkModel().setHead(link, node);
                    break;
                }
                case 22: {
                    if (node == link.getHead()) {
                        MessageHandler.error((String)"Cannot link both ends to the same object.");
                        return;
                    }
                    model.getLinkModel().setTail(link, node);
                    break;
                }
                default: {
                    throw new IllegalStateException("Cannot handle both ends of an edge being dragged.");
                }
            }
            if (link.getHead() != null && link.getTail() != null) {
                ((ManhattanConnector)c).setLineWidth(2.0f);
            } else {
                ((ManhattanConnector)c).setLineWidth(1.0f);
            }
        }
    }

    public static class LinkRenderer
    implements EdgeRenderer {
        public Connector render(Object edge, Site tailSite, Site headSite) {
            Link link = (Link)edge;
            LinkManhattanConnector connector = new LinkManhattanConnector(tailSite, headSite, link);
            if (link.getHead() != null && link.getTail() != null) {
                connector.setLineWidth(2.0f);
            }
            connector.setUserObject(edge);
            connector.setBendRadius(20.0);
            ComponentRelation relation = link.getRelation();
            if (relation != null) {
                Token radiusValue;
                StringAttribute _explAttr;
                Object color;
                Object colorAttribute;
                String displayName;
                String tipText = relation.getName();
                if (!tipText.equals(displayName = relation.getDisplayName())) {
                    tipText = String.valueOf(displayName) + " (" + tipText + ")";
                }
                connector.setToolTipText(tipText);
                try {
                    colorAttribute = (StringAttribute)relation.getAttribute("_color", StringAttribute.class);
                    if (colorAttribute != null && (color = colorAttribute.getExpression()) != null && !((String)color).trim().equals("")) {
                        connector.setStrokePaint(SVGUtilities.getColor((String)color));
                    }
                }
                catch (IllegalActionException illegalActionException) {}
                try {
                    colorAttribute = (ColorAttribute)relation.getAttribute("color", ColorAttribute.class);
                    if (colorAttribute != null) {
                        color = ((ColorAttribute)((Object)colorAttribute)).asColor();
                        connector.setStrokePaint((Paint)color);
                    }
                }
                catch (IllegalActionException illegalActionException) {}
                if ((_explAttr = (StringAttribute)relation.getAttribute("_explanation")) != null) {
                    connector.setToolTipText(_explAttr.getExpression());
                }
                if ((radiusValue = PtolemyPreferences.preferenceValue((NamedObj)relation, "_linkBendRadius")) instanceof DoubleToken) {
                    double overrideRadius = ((DoubleToken)radiusValue).doubleValue();
                    connector.setBendRadius(overrideRadius);
                }
            }
            return connector;
        }
    }

    public static class LinkTarget
    extends PerimeterTarget {
        public boolean acceptHead(Connector c, Figure f) {
            Object object = f.getUserObject();
            if (object instanceof Port || object instanceof Vertex || object instanceof Locatable && ((Locatable)object).getContainer() instanceof Port) {
                return super.acceptHead(c, f);
            }
            return false;
        }

        public boolean acceptTail(Connector c, Figure f) {
            Object object = f.getUserObject();
            if (object instanceof Port || object instanceof Vertex || object instanceof Locatable && ((Locatable)object).getContainer() instanceof Port) {
                return super.acceptTail(c, f);
            }
            return false;
        }

        public Site getHeadSite(Figure f, double x, double y) {
            if (f instanceof Terminal) {
                Site site = ((Terminal)f).getConnectSite();
                return site;
            }
            return super.getHeadSite(f, x, y);
        }
    }
}

