/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.vergil.actor;

import diva.canvas.CanvasUtilities;
import diva.canvas.CompositeFigure;
import diva.canvas.Figure;
import diva.canvas.Site;
import diva.canvas.connector.PerimeterSite;
import diva.canvas.connector.TerminalFigure;
import diva.canvas.interactor.CompositeInteractor;
import diva.canvas.interactor.Interactor;
import diva.canvas.toolbox.BasicFigure;
import diva.canvas.toolbox.SVGUtilities;
import diva.graph.GraphController;
import diva.graph.NodeRenderer;
import diva.util.java2d.Polygon2D;
import diva.util.java2d.ShapeUtilities;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import ptolemy.actor.IOPort;
import ptolemy.actor.gui.ColorAttribute;
import ptolemy.actor.gui.DebugListenerTableau;
import ptolemy.actor.gui.Effigy;
import ptolemy.actor.gui.Tableau;
import ptolemy.actor.gui.TextEffigy;
import ptolemy.actor.parameters.ParameterPort;
import ptolemy.data.BooleanToken;
import ptolemy.data.IntToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.Typeable;
import ptolemy.kernel.Port;
import ptolemy.kernel.util.Debuggable;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.KernelException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.StringAttribute;
import ptolemy.util.MessageHandler;
import ptolemy.vergil.actor.PortTerminal;
import ptolemy.vergil.basic.BasicGraphController;
import ptolemy.vergil.basic.BasicGraphFrame;
import ptolemy.vergil.kernel.AnimationRenderer;
import ptolemy.vergil.kernel.AttributeController;
import ptolemy.vergil.toolbox.FigureAction;
import ptolemy.vergil.toolbox.MenuActionFactory;

public class IOPortController
extends AttributeController {
    public static double MULTIPORT_CONNECTION_SPACING = 5.0;

    public IOPortController(GraphController controller) {
        this(controller, FULL);
    }

    public IOPortController(GraphController controller, AttributeController.Access access) {
        super(controller, access);
        this._decoratable = false;
        this.setNodeRenderer(new EntityPortRenderer());
        this._menuFactory.addMenuItemFactory(new MenuActionFactory(new ListenToPortAction()));
        CompositeInteractor interactor = new CompositeInteractor();
        this.setNodeInteractor((Interactor)interactor);
        interactor.addInteractor((Interactor)this._menuCreator);
    }

    protected static int _getCardinality(Port port) {
        Token rotationValue;
        NamedObj container;
        boolean isInput = false;
        boolean isOutput = false;
        boolean isInputOutput = false;
        if (port instanceof IOPort) {
            isInput = ((IOPort)port).isInput();
            isOutput = ((IOPort)port).isOutput();
            isInputOutput = isInput && isOutput;
        }
        StringAttribute cardinal = null;
        int portRotation = 0;
        try {
            Parameter rotationParameter;
            cardinal = (StringAttribute)port.getAttribute("_cardinal", StringAttribute.class);
            container = port.getContainer();
            if (container != null && (rotationParameter = (Parameter)container.getAttribute("_rotatePorts", Parameter.class)) != null && (rotationValue = rotationParameter.getToken()) instanceof IntToken) {
                portRotation = ((IntToken)rotationValue).intValue();
            }
        }
        catch (IllegalActionException illegalActionException) {}
        if (cardinal == null) {
            if (isInputOutput) {
                portRotation -= 90;
            } else if (isOutput) {
                portRotation += 180;
            }
        } else {
            portRotation = cardinal.getExpression().equalsIgnoreCase("NORTH") ? 90 : (cardinal.getExpression().equalsIgnoreCase("SOUTH") ? -90 : (cardinal.getExpression().equalsIgnoreCase("EAST") ? 180 : (cardinal.getExpression().equalsIgnoreCase("WEST") ? 0 : (portRotation -= 90))));
        }
        portRotation = 90 * (portRotation / 90 % 4);
        try {
            container = port.getContainer();
            if (container != null) {
                Token rotationValue2;
                Parameter flipVerticalParameter;
                Parameter flipHorizontalParameter = (Parameter)container.getAttribute("_flipPortsHorizontal", Parameter.class);
                if (flipHorizontalParameter != null && (rotationValue = flipHorizontalParameter.getToken()) instanceof BooleanToken && ((BooleanToken)rotationValue).booleanValue()) {
                    if (portRotation == 0 || portRotation == -180) {
                        portRotation += 180;
                    } else if (portRotation == 180) {
                        portRotation = 0;
                    }
                }
                if ((flipVerticalParameter = (Parameter)container.getAttribute("_flipPortsVertical", Parameter.class)) != null && (rotationValue2 = flipVerticalParameter.getToken()) instanceof BooleanToken && ((BooleanToken)rotationValue2).booleanValue()) {
                    if (portRotation == -270 || portRotation == -90) {
                        portRotation += 180;
                    } else if (portRotation == 90 || portRotation == 270) {
                        portRotation -= 180;
                    }
                }
            }
        }
        catch (IllegalActionException illegalActionException) {}
        return portRotation;
    }

    protected static int _getDirection(int portRotation) {
        int direction = portRotation == 90 || portRotation == -270 ? 1 : (portRotation == 180 || portRotation == -180 ? 3 : (portRotation == 270 || portRotation == -90 ? 5 : 7));
        return direction;
    }

    public class EntityPortRenderer
    implements NodeRenderer {
        public Figure render(Object n) {
            String displayName;
            Shape shape;
            Polygon2D.Double polygon;
            final Port port = (Port)n;
            if (IOPortController.this._isPropertySet((NamedObj)port, "_hide")) {
                return null;
            }
            boolean isInput = false;
            boolean isOutput = false;
            boolean isInputOutput = false;
            if (port instanceof IOPort) {
                isInput = ((IOPort)port).isInput();
                isOutput = ((IOPort)port).isOutput();
                boolean bl = isInputOutput = isInput && isOutput;
            }
            if (isInputOutput) {
                polygon = new Polygon2D.Double();
                polygon.moveTo(0.0, -4.0);
                polygon.lineTo(-4.0, -4.0);
                polygon.lineTo(-2.0, 0.0);
                polygon.lineTo(-4.0, 4.0);
                polygon.lineTo(4.0, 4.0);
                polygon.lineTo(2.0, 0.0);
                polygon.lineTo(4.0, -4.0);
                polygon.lineTo(0.0, -4.0);
                polygon.closePath();
                shape = polygon;
            } else if (isInput) {
                polygon = new Polygon2D.Double();
                polygon.moveTo(-4.0, 0.0);
                polygon.lineTo(-4.0, 4.0);
                polygon.lineTo(4.0, 0.0);
                polygon.lineTo(-4.0, -4.0);
                polygon.lineTo(-4.0, 0.0);
                polygon.closePath();
                shape = polygon;
            } else if (isOutput) {
                polygon = new Polygon2D.Double();
                polygon.moveTo(4.0, 0.0);
                polygon.lineTo(4.0, -4.0);
                polygon.lineTo(-4.0, 0.0);
                polygon.lineTo(4.0, 4.0);
                polygon.lineTo(4.0, 0.0);
                polygon.closePath();
                shape = polygon;
            } else {
                shape = new Ellipse2D.Double(-4.0, -4.0, 8.0, 8.0);
            }
            Color fill = port instanceof ParameterPort ? Color.lightGray : (port instanceof IOPort && ((IOPort)port).isMultiport() ? Color.white : Color.black);
            StringAttribute _colorAttr = (StringAttribute)port.getAttribute("_color");
            if (_colorAttr != null) {
                String _color = _colorAttr.getExpression();
                fill = SVGUtilities.getColor((String)_color);
            }
            int portRotation = IOPortController._getCardinality(port);
            int direction = IOPortController._getDirection(portRotation);
            double rotation = portRotation;
            AffineTransform transform = AffineTransform.getRotateInstance(Math.toRadians(rotation));
            shape = ShapeUtilities.transformModify((Shape)shape, (AffineTransform)transform);
            Object figure = new BasicFigure(shape, fill, 1.5f){

                public String getToolTipText() {
                    StringAttribute _explAttr;
                    String displayName;
                    String tipText = port.getName();
                    if (!tipText.equals(displayName = port.getDisplayName())) {
                        tipText = String.valueOf(displayName) + " (" + tipText + ")";
                    }
                    if ((_explAttr = (StringAttribute)port.getAttribute("_explanation")) != null) {
                        tipText = _explAttr.getExpression();
                    } else if (port instanceof Typeable) {
                        try {
                            tipText = String.valueOf(tipText) + ", type:" + ((Typeable)port).getType();
                        }
                        catch (IllegalActionException illegalActionException) {}
                    }
                    return tipText;
                }
            };
            String tipText = port.getName();
            if (!tipText.equals(displayName = port.getDisplayName())) {
                tipText = String.valueOf(displayName) + " (" + tipText + ")";
            }
            figure.setToolTipText(tipText);
            double normal = CanvasUtilities.getNormal((int)direction);
            if (port instanceof IOPort) {
                int numberOfLinks;
                IOPort ioPort = (IOPort)port;
                if (ioPort.isMultiport() && (numberOfLinks = ioPort.linkedRelationList().size()) > 1) {
                    double endY;
                    double endX;
                    double startY;
                    double startX;
                    CompositeFigure compositeFigure = new CompositeFigure((Figure)figure){

                        public String getToolTipText() {
                            StringAttribute _explAttr;
                            String displayName;
                            String tipText = port.getName();
                            if (!tipText.equals(displayName = port.getDisplayName())) {
                                tipText = String.valueOf(displayName) + " (" + tipText + ")";
                            }
                            if ((_explAttr = (StringAttribute)port.getAttribute("_explanation")) != null) {
                                tipText = _explAttr.getExpression();
                            } else if (port instanceof Typeable) {
                                try {
                                    tipText = String.valueOf(tipText) + ", type:" + ((Typeable)port).getType();
                                }
                                catch (IllegalActionException illegalActionException) {}
                            }
                            return tipText;
                        }
                    };
                    Rectangle2D bounds = figure.getShape().getBounds2D();
                    double x = bounds.getX();
                    double y = bounds.getY();
                    double width = bounds.getWidth();
                    double height = bounds.getHeight();
                    int extent = numberOfLinks - 1;
                    if (direction == 3) {
                        startX = x + width;
                        startY = y + height / 2.0;
                        endX = startX + (double)extent * MULTIPORT_CONNECTION_SPACING;
                        endY = startY + (double)extent * MULTIPORT_CONNECTION_SPACING;
                    } else if (direction == 7) {
                        startX = x;
                        startY = y + height / 2.0;
                        endX = startX - (double)extent * MULTIPORT_CONNECTION_SPACING;
                        endY = startY - (double)extent * MULTIPORT_CONNECTION_SPACING;
                    } else if (direction == 1) {
                        startX = x + width / 2.0;
                        startY = y;
                        endX = startX - (double)extent * MULTIPORT_CONNECTION_SPACING;
                        endY = startY - (double)extent * MULTIPORT_CONNECTION_SPACING;
                    } else {
                        startX = x + width / 2.0;
                        startY = y + height;
                        endX = startX + (double)extent * MULTIPORT_CONNECTION_SPACING;
                        endY = startY + (double)extent * MULTIPORT_CONNECTION_SPACING;
                    }
                    Line2D.Double line = new Line2D.Double(startX, startY, endX, endY);
                    BasicFigure lineFigure = new BasicFigure((Shape)line, (Paint)fill, 2.0f);
                    compositeFigure.add((Figure)lineFigure);
                    figure = compositeFigure;
                }
                figure = new PortTerminal(ioPort, (Figure)figure, normal, false);
            } else {
                PerimeterSite tsite = new PerimeterSite((Figure)figure, 0);
                tsite.setNormal(normal);
                figure = new TerminalFigure((Figure)figure, (Site)tsite);
            }
            try {
                ColorAttribute highlightAttribute = (ColorAttribute)port.getAttribute("_highlightColor", ColorAttribute.class);
                if (highlightAttribute != null && !highlightAttribute.getExpression().trim().equals("")) {
                    Color color = highlightAttribute.asColor();
                    AnimationRenderer animationRenderer = new AnimationRenderer(color);
                    animationRenderer.renderSelected((Figure)figure);
                }
            }
            catch (IllegalActionException illegalActionException) {}
            return figure;
        }
    }

    private class ListenToPortAction
    extends FigureAction {
        public ListenToPortAction() {
            super("Listen to Port");
        }

        public void actionPerformed(ActionEvent e) {
            if (IOPortController.this._configuration == null) {
                MessageHandler.error((String)"Cannot listen to port without a configuration.");
                return;
            }
            super.actionPerformed(e);
            NamedObj object = this.getTarget();
            try {
                BasicGraphController controller = (BasicGraphController)IOPortController.this.getController();
                BasicGraphFrame frame = controller.getFrame();
                Tableau tableau = frame.getTableau();
                Effigy effigy = (Effigy)tableau.getContainer();
                TextEffigy textEffigy = new TextEffigy(effigy, effigy.uniqueName("debugListener" + object.getName()));
                DebugListenerTableau debugTableau = new DebugListenerTableau(textEffigy, textEffigy.uniqueName("debugListener" + object.getName()));
                debugTableau.setDebuggable((Debuggable)object);
            }
            catch (KernelException ex) {
                MessageHandler.error((String)"Failed to create debug listener.", (Throwable)ex);
            }
        }
    }
}

