/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.vergil.actor;

import diva.canvas.CanvasUtilities;
import diva.canvas.CompositeFigure;
import diva.canvas.Figure;
import diva.canvas.Site;
import diva.canvas.connector.FixedNormalSite;
import diva.canvas.connector.PerimeterSite;
import diva.canvas.connector.TerminalFigure;
import diva.canvas.toolbox.BasicFigure;
import diva.canvas.toolbox.LabelFigure;
import diva.graph.GraphController;
import diva.graph.NodeRenderer;
import diva.util.java2d.Polygon2D;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import ptolemy.actor.IOPort;
import ptolemy.actor.parameters.ParameterPort;
import ptolemy.data.type.Typeable;
import ptolemy.kernel.Port;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.KernelException;
import ptolemy.kernel.util.Locatable;
import ptolemy.kernel.util.Location;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.vergil.actor.IOPortController;
import ptolemy.vergil.actor.PortTerminal;
import ptolemy.vergil.kernel.AttributeController;

public class ExternalIOPortController
extends AttributeController {
    public static final IOPort _GENERIC_INPUT = new IOPort();
    public static final IOPort _GENERIC_OUTPUT = new IOPort();
    public static final IOPort _GENERIC_INOUT = new IOPort();
    public static final IOPort _GENERIC_INPUT_MULTIPORT = new IOPort();
    public static final IOPort _GENERIC_OUTPUT_MULTIPORT = new IOPort();
    public static final IOPort _GENERIC_INOUT_MULTIPORT = new IOPort();
    private static Font _labelFont;

    static {
        try {
            _GENERIC_INPUT.setInput(true);
            _GENERIC_OUTPUT.setOutput(true);
            _GENERIC_INOUT.setInput(true);
            _GENERIC_INOUT.setOutput(true);
            _GENERIC_INPUT_MULTIPORT.setInput(true);
            _GENERIC_OUTPUT_MULTIPORT.setOutput(true);
            _GENERIC_INOUT_MULTIPORT.setInput(true);
            _GENERIC_INOUT_MULTIPORT.setOutput(true);
            _GENERIC_INPUT_MULTIPORT.setMultiport(true);
            _GENERIC_OUTPUT_MULTIPORT.setMultiport(true);
            _GENERIC_INOUT_MULTIPORT.setMultiport(true);
            new Location((NamedObj)_GENERIC_INPUT, "_location");
            new Location((NamedObj)_GENERIC_OUTPUT, "_location");
            new Location((NamedObj)_GENERIC_INOUT, "_location");
            new Location((NamedObj)_GENERIC_INPUT_MULTIPORT, "_location");
            new Location((NamedObj)_GENERIC_OUTPUT_MULTIPORT, "_location");
            new Location((NamedObj)_GENERIC_INOUT_MULTIPORT, "_location");
        }
        catch (KernelException ex) {
            throw new InternalErrorException(null, (Throwable)ex, null);
        }
        _labelFont = new Font("SansSerif", 0, 12);
    }

    public ExternalIOPortController(GraphController controller) {
        this(controller, FULL);
    }

    public ExternalIOPortController(GraphController controller, AttributeController.Access access) {
        super(controller, access);
        this.setNodeRenderer(new PortRenderer());
    }

    protected boolean _hide(Object node) {
        if (node instanceof Locatable && ((Locatable)node).getContainer().getAttribute("_hideInside") != null) {
            return true;
        }
        return node instanceof NamedObj && ((NamedObj)node).getAttribute("_hideInside") != null;
    }

    private String _portTooltip(Port port) {
        String tipText = port.getName();
        if (port instanceof IOPort) {
            IOPort ioport = (IOPort)port;
            if (ioport.isInput()) {
                tipText = String.valueOf(tipText) + ", Input";
            }
            if (ioport.isOutput()) {
                tipText = String.valueOf(tipText) + ", Output";
            }
            if (ioport.isMultiport()) {
                tipText = String.valueOf(tipText) + ", Multiport";
            }
            try {
                tipText = String.valueOf(tipText) + ", type:" + ((Typeable)port).getType();
            }
            catch (ClassCastException classCastException) {
            }
            catch (IllegalActionException illegalActionException) {}
        }
        return tipText;
    }

    public class PortRenderer
    implements NodeRenderer {
        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Figure render(Object n) {
            void var3_16;
            Polygon2D.Double polygon = new Polygon2D.Double();
            Location location = (Location)n;
            if (location != null) {
                void var3_14;
                void var3_10;
                IOPort ioport;
                Color fill;
                final Port port = (Port)location.getContainer();
                if (!(port instanceof IOPort)) {
                    polygon.moveTo(-6.0, 6.0);
                    polygon.lineTo(0.0, 6.0);
                    polygon.lineTo(8.0, 0.0);
                    polygon.lineTo(0.0, -6.0);
                    polygon.lineTo(-6.0, -6.0);
                    fill = Color.black;
                } else {
                    ioport = (IOPort)port;
                    polygon.moveTo(-8.0, 4.0);
                    if (ioport.isMultiport()) {
                        fill = ioport instanceof ParameterPort ? Color.darkGray : Color.white;
                        if (ioport.isOutput() && ioport.isInput()) {
                            polygon.lineTo(-4.0, 4.0);
                            polygon.lineTo(-4.0, 9.0);
                            polygon.lineTo(2.0, 4.0);
                            polygon.lineTo(2.0, 9.0);
                            polygon.lineTo(8.0, 4.0);
                            polygon.lineTo(12.0, 4.0);
                            polygon.lineTo(12.0, -4.0);
                            polygon.lineTo(8.0, -4.0);
                            polygon.lineTo(2.0, -9.0);
                            polygon.lineTo(2.0, -4.0);
                            polygon.lineTo(-4.0, -9.0);
                            polygon.lineTo(-4.0, -4.0);
                            polygon.lineTo(-8.0, -4.0);
                        } else if (ioport.isOutput()) {
                            polygon.lineTo(-8.0, 4.0);
                            polygon.lineTo(-8.0, 9.0);
                            polygon.lineTo(-2.0, 4.0);
                            polygon.lineTo(-2.0, 9.0);
                            polygon.lineTo(4.0, 4.0);
                            polygon.lineTo(12.0, 4.0);
                            polygon.lineTo(12.0, -4.0);
                            polygon.lineTo(4.0, -4.0);
                            polygon.lineTo(-2.0, -9.0);
                            polygon.lineTo(-2.0, -4.0);
                            polygon.lineTo(-8.0, -9.0);
                        } else {
                            if (!ioport.isInput()) throw new InternalErrorException((Nameable)port, null, "Port is neither input nor output");
                            polygon.lineTo(-5.0, 4.0);
                            polygon.lineTo(-5.0, 9.0);
                            polygon.lineTo(1.0, 4.0);
                            polygon.lineTo(1.0, 9.0);
                            polygon.lineTo(7.0, 4.0);
                            polygon.lineTo(12.0, 0.0);
                            polygon.lineTo(7.0, -4.0);
                            polygon.lineTo(1.0, -9.0);
                            polygon.lineTo(1.0, -4.0);
                            polygon.lineTo(-5.0, -9.0);
                            polygon.lineTo(-5.0, -4.0);
                            polygon.lineTo(-8.0, -4.0);
                        }
                    } else {
                        fill = ioport instanceof ParameterPort ? Color.lightGray : Color.black;
                        if (ioport.isOutput() && ioport.isInput()) {
                            polygon.lineTo(0.0, 4.0);
                            polygon.lineTo(0.0, 9.0);
                            polygon.lineTo(6.0, 4.0);
                            polygon.lineTo(12.0, 4.0);
                            polygon.lineTo(12.0, -4.0);
                            polygon.lineTo(6.0, -4.0);
                            polygon.lineTo(0.0, -9.0);
                            polygon.lineTo(0.0, -4.0);
                            polygon.lineTo(-8.0, -4.0);
                        } else if (ioport.isOutput()) {
                            polygon.lineTo(-8.0, 9.0);
                            polygon.lineTo(-2.0, 4.0);
                            polygon.lineTo(12.0, 4.0);
                            polygon.lineTo(12.0, -4.0);
                            polygon.lineTo(-2.0, -4.0);
                            polygon.lineTo(-8.0, -9.0);
                        } else {
                            if (!ioport.isInput()) throw new InternalErrorException((Nameable)port, null, "Port is neither input nor output");
                            polygon.lineTo(0.0, 4.0);
                            polygon.lineTo(0.0, 9.0);
                            polygon.lineTo(12.0, 0.0);
                            polygon.lineTo(0.0, -9.0);
                            polygon.lineTo(0.0, -4.0);
                            polygon.lineTo(-8.0, -4.0);
                        }
                    }
                }
                polygon.closePath();
                if (port instanceof ParameterPort) {
                    BasicFigure basicFigure = new BasicFigure((Shape)polygon, (Paint)new Color(0, 0, 0, 0), 0.0f);
                } else {
                    BasicFigure basicFigure = new BasicFigure((Shape)polygon, (Paint)fill, 1.5f);
                }
                int direction = !(port instanceof IOPort) ? 1 : ((ioport = (IOPort)port).isInput() && ioport.isOutput() ? 1 : (ioport.isInput() ? 3 : (ioport.isOutput() ? 7 : 1)));
                double normal = CanvasUtilities.getNormal((int)direction);
                String name = port.getName();
                Rectangle2D backBounds = var3_10.getBounds();
                CompositeFigure compositeFigure = new CompositeFigure((Figure)var3_10){

                    public String getToolTipText() {
                        return ExternalIOPortController.this._portTooltip(port);
                    }
                };
                if (name != null && !name.equals("") && !(port instanceof ParameterPort)) {
                    LabelFigure label = new LabelFigure(name, _labelFont, 1.0, 6);
                    label.translateTo(backBounds.getX(), backBounds.getY());
                    ((CompositeFigure)compositeFigure).add((Figure)label);
                }
                if (port instanceof IOPort) {
                    int numberOfLinks;
                    IOPort ioPort = (IOPort)port;
                    if (ioPort.isMultiport() && (numberOfLinks = ioPort.insideRelationList().size()) > 1) {
                        double endY;
                        double endX;
                        double startY;
                        double startX;
                        Rectangle2D bounds = compositeFigure.getShape().getBounds2D();
                        double x = bounds.getX();
                        double y = bounds.getY();
                        double width = bounds.getWidth();
                        double height = bounds.getHeight();
                        int extent = numberOfLinks - 1;
                        if (direction == 3) {
                            startX = x + width;
                            startY = y + height / 2.0;
                            endX = startX + (double)extent * IOPortController.MULTIPORT_CONNECTION_SPACING;
                            endY = startY + (double)extent * IOPortController.MULTIPORT_CONNECTION_SPACING;
                        } else if (direction == 7) {
                            startX = x;
                            startY = y + height / 2.0;
                            endX = startX - (double)extent * IOPortController.MULTIPORT_CONNECTION_SPACING;
                            endY = startY - (double)extent * IOPortController.MULTIPORT_CONNECTION_SPACING;
                        } else if (direction == 1) {
                            startX = x + width / 2.0;
                            startY = y;
                            endX = startX - (double)extent * IOPortController.MULTIPORT_CONNECTION_SPACING;
                            endY = startY - (double)extent * IOPortController.MULTIPORT_CONNECTION_SPACING;
                        } else {
                            startX = x + width / 2.0;
                            startY = y + height;
                            endX = startX + (double)extent * IOPortController.MULTIPORT_CONNECTION_SPACING;
                            endY = startY + (double)extent * IOPortController.MULTIPORT_CONNECTION_SPACING;
                        }
                        Line2D.Double line = new Line2D.Double(startX, startY, endX, endY);
                        BasicFigure lineFigure = new BasicFigure((Shape)line, (Paint)fill, 2.0f);
                        ((CompositeFigure)compositeFigure).add((Figure)lineFigure);
                    }
                    PortTerminal portTerminal = new PortTerminal(ioPort, (Figure)compositeFigure, normal, true);
                } else {
                    PerimeterSite tsite = new PerimeterSite((Figure)compositeFigure, 0);
                    tsite.setNormal(normal);
                    tsite = new FixedNormalSite((Site)tsite);
                    TerminalFigure terminalFigure = new TerminalFigure((Figure)compositeFigure, (Site)tsite){

                        public String getToolTipText() {
                            return ExternalIOPortController.this._portTooltip(port);
                        }
                    };
                }
                var3_14.setToolTipText(port.getName());
                return var3_16;
            } else {
                polygon.moveTo(0.0, 0.0);
                polygon.lineTo(0.0, 10.0);
                polygon.lineTo(12.0, 0.0);
                polygon.lineTo(0.0, -10.0);
                polygon.closePath();
                BasicFigure basicFigure = new BasicFigure((Shape)polygon, (Paint)Color.black);
                basicFigure.setToolTipText("Unknown port");
            }
            return var3_16;
        }
    }
}

