/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.vergil.actor;

import com.microstar.xml.HandlerBase;
import com.microstar.xml.XmlException;
import com.microstar.xml.XmlHandler;
import com.microstar.xml.XmlParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import ptolemy.actor.TypedCompositeActor;
import ptolemy.actor.gui.Configuration;
import ptolemy.data.expr.Parameter;
import ptolemy.kernel.Entity;
import ptolemy.kernel.Port;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.Instantiable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Settable;
import ptolemy.kernel.util.StringAttribute;
import ptolemy.vergil.actor.DocApplicationSpecializer;
import ptolemy.vergil.basic.DocAttribute;

public class DocManager
extends HandlerBase {
    public static String DocML_DTD_1 = "<!ELEMENT doc (author | description | port | property | Pt.AcceptedRating | Pt.ProposedRating | since | version)*><!ATTLIST doc name CDATA #REQUIRED class CDATA #REQUIRED><!ELEMENT author (#PCDATA)><!ELEMENT description (#PCDATA)><!ELEMENT port (#PCDATA)><!ATTLIST port name CDATA #REQUIRED><!ELEMENT property (#PCDATA)><!ATTLIST property name CDATA #REQUIRED><!ELEMENT Pt.acceptedRating (#PCDATA)><!ELEMENT Pt.proposedRating (#PCDATA)><!ELEMENT since (#PCDATA)><!ELEMENT version (#PCDATA)>";
    private HashMap _attributes;
    private String _author;
    private String _className;
    private Configuration _configuration;
    private StringBuffer _currentCharData = new StringBuffer();
    private String _description;
    private boolean _docFileHasBeenRead = false;
    private String _exception;
    private Stack _externalEntities = new Stack();
    private boolean _isInstanceDoc = false;
    private String _name;
    private DocManager _nextTier;
    private XmlParser _parser = new XmlParser();
    private HashMap _properties = new HashMap();
    private HashMap _ports = new HashMap();
    private String _ptAcceptedRating;
    private String _ptProposedRating;
    private static String _remoteDocumentationURLBase;
    private String _since;
    private NamedObj _target;
    private Class _targetClass;
    private String _version;
    private static Class _namedObjClass;

    static {
        try {
            _namedObjClass = Class.forName("ptolemy.kernel.util.NamedObj");
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException(ex);
        }
    }

    public DocManager(Configuration configuration, NamedObj target) {
        this._configuration = configuration;
        this._target = target;
        this._targetClass = target.getClass();
        this._className = target.getClassName();
        try {
            List docAttributes = this._target.attributeList(DocAttribute.class);
            if (docAttributes.size() > 0) {
                String versionValue;
                String sinceValue;
                String authorValue;
                DocAttribute instanceDoc = (DocAttribute)((Object)docAttributes.get(docAttributes.size() - 1));
                String descriptionValue = instanceDoc.description.stringValue();
                if (descriptionValue != null && !descriptionValue.trim().equals("")) {
                    this._isInstanceDoc = true;
                    this._description = descriptionValue;
                }
                if ((authorValue = instanceDoc.author.getExpression()) != null && !authorValue.trim().equals("")) {
                    this._isInstanceDoc = true;
                    this._author = authorValue;
                }
                if ((sinceValue = instanceDoc.since.getExpression()) != null && !sinceValue.trim().equals("")) {
                    this._isInstanceDoc = true;
                    this._since = sinceValue;
                }
                if ((versionValue = instanceDoc.version.getExpression()) != null && !versionValue.trim().equals("")) {
                    this._isInstanceDoc = true;
                    this._version = versionValue;
                }
                for (NamedObj attribute : target.attributeList(Settable.class)) {
                    String attributeDoc;
                    if (((Settable)attribute).getVisibility() == Settable.NONE || (attributeDoc = instanceDoc.getParameterDoc(attribute.getName())) == null || attributeDoc.trim().equals("")) continue;
                    this._isInstanceDoc = true;
                    this._properties.put(attribute.getName(), attributeDoc);
                }
                if (target instanceof Entity) {
                    for (Port port : ((Entity)target).portList()) {
                        String portDoc = instanceDoc.getPortDoc(port.getName());
                        if (portDoc == null || portDoc.trim().equals("")) continue;
                        this._isInstanceDoc = true;
                        this._ports.put(port.getName(), portDoc);
                    }
                }
            }
        }
        catch (IllegalActionException e) {
            this._exception = "Error evaluating DocAttribute parameter:\n" + (Object)((Object)e);
        }
    }

    public DocManager(Configuration configuration, Class targetClass) {
        this._configuration = configuration;
        this._targetClass = targetClass;
        this._className = this._targetClass.getName();
    }

    public DocManager(Configuration configuration, URL url) {
        this._configuration = configuration;
        try {
            this.parse(null, url.openStream());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this._exception = "Error reading URL: " + url.toExternalForm() + "\n<pre>\n" + ex + "\n</pre>\n";
        }
        this._docFileHasBeenRead = true;
    }

    public void attribute(String name, String value, boolean specified) throws XmlException {
        if (name == null) {
            throw new XmlException("Attribute has no name", this._currentExternalEntity(), this._parser.getLineNumber(), this._parser.getColumnNumber());
        }
        if (value != null) {
            this._attributes.put(name, value);
        }
    }

    public static URL docClassNameToURL(Configuration configuration, String className, boolean lookForPtDoc, boolean lookForJavadoc, boolean lookForSource, boolean lookForActorIndex) {
        URL toRead;
        block32: {
            toRead = null;
            try {
                Parameter docApplicationSpecializerParameter = (Parameter)configuration.getAttribute("_docApplicationSpecializer", Parameter.class);
                if (docApplicationSpecializerParameter != null) {
                    String docApplicationSpecializerClassName = docApplicationSpecializerParameter.getExpression();
                    try {
                        Class<?> docApplicationSpecializerClass = Class.forName(docApplicationSpecializerClassName);
                        DocApplicationSpecializer docApplicationSpecializer = (DocApplicationSpecializer)docApplicationSpecializerClass.newInstance();
                        toRead = docApplicationSpecializer.docClassNameToURL(_remoteDocumentationURLBase, className, lookForPtDoc, lookForJavadoc, lookForSource, lookForActorIndex);
                    }
                    catch (Throwable throwable) {
                        throw new Exception("Failed to call doc application initializer class \"" + docApplicationSpecializerClassName + "\" on class \"" + className + "\".");
                    }
                }
                String applicationName = "";
                try {
                    StringAttribute applicationNameAttribute = (StringAttribute)configuration.getAttribute("_applicationName", StringAttribute.class);
                    if (applicationNameAttribute != null) {
                        applicationName = applicationNameAttribute.getExpression();
                    }
                }
                catch (Throwable throwable) {}
                String[] docNames = new String[]{"doc/codeDoc" + (applicationName.equals("") ? "/" : String.valueOf(applicationName) + "/doc/codeDoc/") + className.replace('.', '/') + ".xml", "doc/codeDoc/" + className.replace('.', '/') + ".xml", "doc/codeDoc" + (applicationName.equals("") ? "/" : String.valueOf(applicationName) + "/doc/codeDoc/") + className.replace('.', '/') + ".html", "doc/codeDoc/" + className.replace('.', '/') + ".html", String.valueOf(className.replace('.', '/')) + ".java", "doc/codeDoc" + (applicationName.equals("") ? "/" : String.valueOf(applicationName) + "/doc/codeDoc/") + className.replace('.', '/') + "Idx.htm"};
                LinkedList<String> docNameList = new LinkedList<String>();
                ClassLoader referenceClassLoader = Class.forName("ptolemy.vergil.actor.DocManager").getClassLoader();
                if (toRead == null && lookForPtDoc) {
                    docNameList.add(docNames[0]);
                    toRead = referenceClassLoader.getResource(docNames[0]);
                }
                if (toRead == null && lookForPtDoc && !applicationName.equals("")) {
                    docNameList.add(docNames[1]);
                    toRead = referenceClassLoader.getResource(docNames[1]);
                }
                if (toRead == null && lookForJavadoc) {
                    try {
                        Class<?> targetClass = Class.forName(className);
                        if (!_namedObjClass.isAssignableFrom(targetClass) || !lookForPtDoc) {
                            docNameList.add(docNames[2]);
                            toRead = referenceClassLoader.getResource(docNames[2]);
                            if (toRead == null) {
                                docNameList.add(docNames[3]);
                                toRead = referenceClassLoader.getResource(docNames[3]);
                            }
                        }
                    }
                    catch (ClassNotFoundException classNotFoundException) {}
                }
                if (toRead == null && lookForSource && !lookForPtDoc && !lookForJavadoc) {
                    docNameList.add(docNames[4]);
                    toRead = referenceClassLoader.getResource(docNames[4]);
                }
                if (toRead == null && lookForActorIndex) {
                    docNameList.add(docNames[5]);
                    toRead = referenceClassLoader.getResource(docNames[5]);
                }
                if (toRead != null || _remoteDocumentationURLBase == null) break block32;
                for (String docName : docNameList) {
                    block34: {
                        toRead = new URL(String.valueOf(_remoteDocumentationURLBase) + docName);
                        if (toRead == null) continue;
                        InputStream toReadStream = null;
                        try {
                            try {
                                toReadStream = toRead.openStream();
                            }
                            catch (IOException iOException) {
                                toRead = null;
                                if (toReadStream != null) {
                                    try {
                                        toReadStream.close();
                                    }
                                    catch (IOException iOException2) {}
                                }
                                break block34;
                            }
                        }
                        catch (Throwable throwable) {
                            if (toReadStream != null) {
                                try {
                                    toReadStream.close();
                                }
                                catch (IOException iOException) {}
                            }
                            throw throwable;
                        }
                        if (toReadStream != null) {
                            try {
                                toReadStream.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                    if (toRead == null) {
                        continue;
                    }
                    break;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
        }
        return toRead;
    }

    public void charData(char[] chars, int offset, int length) {
        this._currentCharData.append(chars, offset, length);
    }

    public void endDocument() throws Exception {
    }

    public void endElement(String elementName) throws Exception {
        if (elementName.equals("author")) {
            this._author = this._currentCharData.toString();
        } else if (elementName.equals("description")) {
            this._description = this._currentCharData.toString();
        } else if (elementName.equals("port")) {
            this._ports.put(this._name, this._currentCharData.toString());
        } else if (elementName.equals("property")) {
            this._properties.put(this._name, this._currentCharData.toString());
        } else if (elementName.equals("Pt.AcceptedRating")) {
            this._ptAcceptedRating = this._currentCharData.toString();
        } else if (elementName.equals("Pt.ProposedRating")) {
            this._ptProposedRating = this._currentCharData.toString();
        } else if (elementName.equals("since")) {
            this._since = this._currentCharData.toString();
        } else if (elementName.equals("version")) {
            this._version = this._currentCharData.toString();
        }
    }

    public void error(String message, String systemID, int line, int column) throws XmlException {
        throw new XmlException(message, this._currentExternalEntity(), line, column);
    }

    public String getAcceptedRating() {
        if (this._ptAcceptedRating == null) {
            this._readDocFile();
        }
        return this._ptAcceptedRating;
    }

    public String getAuthor() {
        if (this._author == null) {
            this._readDocFile();
            if (this._author == null) {
                return "No author given";
            }
        }
        return this._author;
    }

    public String getClassName() {
        if (this._className == null && this._exception != null) {
            return this._exception;
        }
        return this._className;
    }

    public String getDescription() {
        if (this._exception != null) {
            return this._exception;
        }
        if (this._description == null) {
            this._readDocFile();
            if (this._description == null) {
                this._createNextTier();
                if (this._nextTier != null) {
                    return this._nextTier.getDescription();
                }
                return "No description";
            }
        }
        return this._description;
    }

    public DocManager getNextTier() {
        this._createNextTier();
        return this._nextTier;
    }

    public String getPortDoc(String name) {
        this._readDocFile();
        String result = (String)this._ports.get(name);
        if (result == null && (result = (String)this._ports.get(String.valueOf(name) + " (port)")) == null) {
            this._createNextTier();
            if (this._nextTier != null) {
                return this._nextTier.getPortDoc(name);
            }
        }
        return result;
    }

    public String getPropertyDoc(String name) {
        this._readDocFile();
        String result = (String)this._properties.get(name);
        if (result == null && (result = (String)this._properties.get(String.valueOf(name) + " (parameter)")) == null) {
            this._createNextTier();
            if (this._nextTier != null) {
                return this._nextTier.getPropertyDoc(name);
            }
        }
        return result;
    }

    public String getProposedRating() {
        if (this._ptProposedRating == null) {
            this._readDocFile();
        }
        return this._ptProposedRating;
    }

    public String getSince() {
        if (this._since == null) {
            this._readDocFile();
        }
        return this._since;
    }

    public static String getRemoteDocumentationURLBase() {
        return _remoteDocumentationURLBase;
    }

    public Class getTargetClass() {
        return this._targetClass;
    }

    public String getVersion() {
        String tail;
        int index;
        if (this._version == null) {
            this._readDocFile();
        }
        if (this._version != null && this._version.startsWith("$Id:") && (index = this._version.indexOf(",v ")) > 4 && (index = (tail = this._version.substring(index + 3)).indexOf(" ")) > 0 && (index = tail.indexOf(" ", index + 1)) > 0) {
            this._version = tail.substring(0, index);
        }
        return this._version;
    }

    public String getSeeAlso() {
        URL toRead;
        StringBuffer result = new StringBuffer();
        result.append("<b>See Also:</b><ul>\n");
        String className = this._target == null ? this._targetClass.getName() : this._target.getClassName();
        if (this._isInstanceDoc) {
            if (this._target instanceof Instantiable && ((Instantiable)this._target).getParent() != null && ((NamedObj)((Instantiable)this._target).getParent()).attributeList(DocAttribute.class).size() > 0) {
                result.append("<li><a href=\"#parentClass\">Class documentation</a></li>");
            }
            if ((toRead = DocManager.docClassNameToURL(this._configuration, className, true, true, true, false)) != null) {
                result.append("<li><a href=\"" + toRead.toExternalForm() + "\">");
                if (toRead.toExternalForm().endsWith(".html")) {
                    result.append("Javadoc Documentation");
                } else if (toRead.toExternalForm().endsWith(".java")) {
                    result.append("Java Source");
                } else if (toRead.toExternalForm().endsWith(".xml")) {
                    result.append("Class Documentation");
                }
                result.append("</a></li>");
            }
        } else {
            try {
                toRead = DocManager.docClassNameToURL(this._configuration, className, false, true, false, false);
                if (toRead != null) {
                    result.append("<li><a href=\"" + toRead.toExternalForm() + "\">Javadoc documentation</a></li>");
                } else {
                    result.append("<li>No javadocs found</li>");
                }
            }
            catch (Exception ex) {
                result.append("<li>Error opening javadoc file:\n<pre>" + ex + "/n</pre></li>\n");
            }
            try {
                String baseClassName = this._targetClass.getSuperclass().getName();
                URL toRead2 = DocManager.docClassNameToURL(this._configuration, baseClassName, true, true, true, false);
                int lastDot = baseClassName.lastIndexOf(".");
                if (lastDot >= 0) {
                    baseClassName = baseClassName.substring(lastDot + 1);
                }
                if (toRead2 != null && toRead2.toExternalForm().endsWith(".xml")) {
                    result.append("<li><a href=\"" + toRead2.toExternalForm() + "\">Base class (" + baseClassName + ")</a></li>");
                } else if (toRead2 != null && toRead2.toExternalForm().endsWith(".html")) {
                    result.append("<li><a href=\"" + toRead2.toExternalForm() + "\">Base class Javadoc (" + baseClassName + ")</a></li>");
                } else if (toRead2 != null && toRead2.toExternalForm().endsWith(".java")) {
                    result.append("<li><a href=\"" + toRead2.toExternalForm() + "\">Base class Java (" + baseClassName + ")</a></li>");
                }
            }
            catch (Exception ex) {
                result.append("<li>Error opening javadoc file:\n<pre>" + ex + "/n</pre></li>\n");
            }
            try {
                toRead = DocManager.docClassNameToURL(this._configuration, className, false, false, true, false);
                if (toRead != null) {
                    result.append("<li><a href=\"" + toRead.toExternalForm() + "\">Source code</a></li>");
                }
            }
            catch (Exception exception) {}
        }
        try {
            toRead = DocManager.docClassNameToURL(this._configuration, className, false, false, false, true);
            if (toRead != null) {
                result.append("<li><a href=\"" + toRead.toExternalForm() + "\">Demo Usage</a></li>");
            } else {
                result.append("<li>Not used in any demos</li>");
            }
        }
        catch (Exception exception) {}
        result.append("</ul>");
        return result.toString();
    }

    public boolean hadException() {
        return this._exception != null;
    }

    public boolean isInstanceDoc() {
        return this._isInstanceDoc;
    }

    public boolean isTargetInstantiableAttribute() {
        if (this._target != null) {
            return this._target instanceof Attribute;
        }
        Class targetClass = this._targetClass;
        while (targetClass != null) {
            if (targetClass.equals(Attribute.class)) {
                return this._hasMoMLConstructor();
            }
            targetClass = targetClass.getSuperclass();
        }
        return false;
    }

    public boolean isTargetInstantiableEntity() {
        if (this._target != null) {
            return this._target instanceof Entity;
        }
        Class targetClass = this._targetClass;
        while (targetClass != null) {
            if (targetClass.equals(Entity.class)) {
                return this._hasMoMLConstructor();
            }
            targetClass = targetClass.getSuperclass();
        }
        return false;
    }

    public boolean isTargetInstantiablePort() {
        if (this._target != null) {
            return this._target instanceof Port;
        }
        Class targetClass = this._targetClass;
        while (targetClass != null) {
            if (targetClass.equals(Port.class)) {
                return this._hasMoMLConstructor();
            }
            targetClass = targetClass.getSuperclass();
        }
        return false;
    }

    public void parse(URL base, InputStream input) throws Exception {
        this.parse(base, new InputStreamReader(input));
    }

    public void parse(URL base, Reader reader) throws Exception {
        this._parser.setHandler((XmlHandler)this);
        BufferedReader buffered = new BufferedReader(reader);
        if (base == null) {
            this._parser.parse(null, null, (Reader)buffered);
        } else {
            this._parser.parse(base.toExternalForm(), null, (Reader)buffered);
        }
    }

    public void parse(String text) throws Exception {
        this.parse(null, new StringReader(text));
    }

    public Object resolveEntity(String publicID, String systemID) {
        if (publicID != null && publicID.equals("-//UC Berkeley//DTD DocML 1//EN")) {
            return new StringReader(DocML_DTD_1);
        }
        return null;
    }

    public static void setRemoteDocumentationURLBase(String remoteDocumentationURLBase) {
        _remoteDocumentationURLBase = remoteDocumentationURLBase;
    }

    public void startDocument() {
        this._attributes = new HashMap();
    }

    public void startElement(String elementName) throws XmlException {
        try {
            if (elementName.equals("author") || elementName.equals("description") || elementName.equals("Pt.AcceptedRating") || elementName.equals("Pt.ProposedRating") || elementName.equals("since") || elementName.equals("version")) {
                this._currentCharData = new StringBuffer();
            } else if (elementName.equals("doc")) {
                this._className = (String)this._attributes.get("class");
                this._checkForNull(this._className, "No class argument for element \"doc\"");
                Class<?> specifiedClass = Class.forName(this._className);
                if (this._targetClass != null && this._targetClass != specifiedClass) {
                    throw new Exception("Classes don't match: " + this._targetClass + "\n and \n" + specifiedClass);
                }
                this._targetClass = specifiedClass;
            } else if (elementName.equals("port")) {
                this._currentCharData = new StringBuffer();
                this._name = (String)this._attributes.get("name");
                this._checkForNull(this._name, "No name argument for element \"port\"");
            } else if (elementName.equals("property")) {
                this._currentCharData = new StringBuffer();
                this._name = (String)this._attributes.get("name");
                this._checkForNull(this._name, "No name argument for element \"property\"");
            }
        }
        catch (Exception ex) {
            if (ex instanceof XmlException) {
                throw (XmlException)ex;
            }
            String msg = "XML element \"" + elementName + "\" triggers exception:\n  " + ex.toString();
            throw new XmlException(msg, this._currentExternalEntity(), this._parser.getLineNumber(), this._parser.getColumnNumber());
        }
        this._attributes.clear();
    }

    public void startExternalEntity(String systemID) {
        this._externalEntities.push(systemID);
    }

    protected void _checkForNull(Object object, String message) throws XmlException {
        if (object == null) {
            throw new XmlException(message, this._currentExternalEntity(), this._parser.getLineNumber(), this._parser.getColumnNumber());
        }
    }

    protected String _currentExternalEntity() {
        return (String)this._externalEntities.peek();
    }

    private void _createNextTier() {
        if (this._nextTier != null) {
            return;
        }
        if (this._isInstanceDoc) {
            this._nextTier = new DocManager(this._configuration, this._targetClass);
        } else {
            Class superClass = this._targetClass.getSuperclass();
            if (this._isNamedObj(superClass)) {
                this._nextTier = new DocManager(this._configuration, superClass);
            }
        }
    }

    private boolean _hasMoMLConstructor() {
        Class[] parameters = new Class[]{TypedCompositeActor.class, String.class};
        while (parameters[0] != null) {
            try {
                this._targetClass.getConstructor(parameters);
                return true;
            }
            catch (Exception exception) {
                if (parameters[0].equals(NamedObj.class)) break;
                parameters[0] = parameters[0].getSuperclass();
            }
        }
        return false;
    }

    private boolean _isNamedObj(Class candidate) {
        if (candidate == NamedObj.class) {
            return true;
        }
        if ((candidate = candidate.getSuperclass()) == null) {
            return false;
        }
        return this._isNamedObj(candidate);
    }

    private void _readDocFile() {
        if (this._docFileHasBeenRead || this._isInstanceDoc) {
            return;
        }
        URL toRead = DocManager.docClassNameToURL(this._configuration, this._className, true, false, false, false);
        try {
            if (toRead != null) {
                this.parse(null, toRead.openStream());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this._exception = "Error reading URL: " + toRead.toExternalForm() + "\n<pre>\n" + ex + "\n</pre>\n";
        }
        this._docFileHasBeenRead = true;
    }
}

