/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.vergil.actor;

import diva.canvas.CompositeFigure;
import diva.canvas.Figure;
import diva.canvas.toolbox.BasicFigure;
import diva.graph.GraphController;
import diva.graph.GraphModel;
import diva.graph.GraphViewListener;
import diva.graph.layout.GlobalLayout;
import diva.graph.layout.IncrLayoutAdapter;
import diva.graph.layout.IncrementalLayout;
import diva.graph.layout.IncrementalLayoutListener;
import diva.util.Filter;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.lang.ref.WeakReference;
import java.util.List;
import javax.swing.Action;
import javax.swing.KeyStroke;
import ptolemy.kernel.Entity;
import ptolemy.kernel.InstantiableNamedObj;
import ptolemy.kernel.util.ChangeRequest;
import ptolemy.kernel.util.Locatable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.moml.MoMLChangeRequest;
import ptolemy.util.MessageHandler;
import ptolemy.vergil.actor.ActorController;
import ptolemy.vergil.basic.OffsetMoMLChangeRequest;
import ptolemy.vergil.kernel.AttributeController;
import ptolemy.vergil.toolbox.FigureAction;
import ptolemy.vergil.toolbox.MenuActionFactory;

public class ClassDefinitionController
extends ActorController {
    protected ConvertToInstanceAction _convertToInstanceAction = new ConvertToInstanceAction("Convert to Instance");
    protected CreateInstanceAction _createInstanceAction = new CreateInstanceAction("Create Instance");
    protected CreateSubclassAction _createSubclassAction = new CreateSubclassAction("Create Subclass");
    private static Color _HIGHLIGHT_COLOR = new Color(150, 150, 255);

    public ClassDefinitionController(GraphController controller) {
        this(controller, FULL);
    }

    public ClassDefinitionController(GraphController controller, AttributeController.Access access) {
        super(controller, access);
        if (access == FULL) {
            Action[] actions = new Action[]{this._createInstanceAction, this._createSubclassAction, this._convertToInstanceAction};
            this._menuFactory.addMenuItemFactory(new MenuActionFactory(actions, "Class Actions"));
        }
        Filter portFilter = new Filter(){

            public boolean accept(Object candidate) {
                GraphModel model = ClassDefinitionController.this.getController().getGraphModel();
                Object semanticObject = model.getSemanticObject(candidate);
                return candidate instanceof Locatable && semanticObject instanceof Entity && ((Entity)semanticObject).isClassDefinition();
            }
        };
        ActorController.EntityLayout layout = new ActorController.EntityLayout();
        controller.addGraphViewListener((GraphViewListener)new IncrementalLayoutListener((IncrementalLayout)new IncrLayoutAdapter((GlobalLayout)layout){

            public void nodeDrawn(Object node) {
                this.layout(node);
            }
        }, portFilter));
    }

    protected Figure _renderNode(Object node) {
        Figure nf = super._renderNode(node);
        if (nf instanceof CompositeFigure) {
            CompositeFigure cf = (CompositeFigure)nf;
            Figure backgroundFigure = cf.getBackgroundFigure();
            if (backgroundFigure != null) {
                BasicFigure bf = new BasicFigure((Shape)backgroundFigure.getBounds(), 4.0f);
                bf.setStrokePaint((Paint)_HIGHLIGHT_COLOR);
                int index = cf.getFigureCount();
                if (index < 0) {
                    index = 0;
                }
                cf.add(index, (Figure)bf);
            }
            return cf;
        }
        return nf;
    }

    private void _createChangeRequest(NamedObj object, boolean subclass) {
        NamedObj container = object.getContainer();
        StringBuffer moml = new StringBuffer();
        moml.append("<group name=\"auto\">");
        if (((InstantiableNamedObj)object).isClassDefinition()) {
            if (subclass) {
                moml.append("<class name=\"SubclassOf" + object.getName() + "\" extends=\"" + object.getName() + "\"/>");
            } else {
                moml.append("<entity name=\"InstanceOf" + object.getName() + "\" class=\"" + object.getName() + "\"/>");
            }
            moml.append("</group>");
            OffsetMoMLChangeRequest request = new OffsetMoMLChangeRequest((Object)this, container, moml.toString());
            container.requestChange((ChangeRequest)request);
        }
    }

    private class ConvertToInstanceAction
    extends FigureAction {
        public ConvertToInstanceAction(String commandName) {
            super(commandName);
        }

        public void actionPerformed(ActionEvent e) {
            if (ClassDefinitionController.this._access != FULL) {
                return;
            }
            super.actionPerformed(e);
            InstantiableNamedObj object = (InstantiableNamedObj)this.getTarget();
            NamedObj container = object.getContainer();
            if (!object.isClassDefinition()) {
                return;
            }
            boolean hasDeferrals = false;
            List deferred = object.getChildren();
            StringBuffer names = new StringBuffer();
            if (deferred != null) {
                for (WeakReference deferrer : deferred) {
                    NamedObj deferrerObject = (NamedObj)deferrer.get();
                    if (deferrerObject == null) continue;
                    hasDeferrals = true;
                    if (names.length() > 0) {
                        names.append(", ");
                    }
                    names.append(deferrerObject.getFullName());
                }
            }
            if (hasDeferrals) {
                MessageHandler.error((String)("Cannot convert to instance because there are instances and/or subclasses:\n" + names.toString()));
                return;
            }
            String moml = "<entity name=\"" + object.getName() + "\"/>";
            MoMLChangeRequest request = new MoMLChangeRequest((Object)this, container, moml);
            container.requestChange((ChangeRequest)request);
        }
    }

    private class CreateInstanceAction
    extends FigureAction {
        public CreateInstanceAction(String commandName) {
            super(commandName);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(78, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        }

        public void actionPerformed(ActionEvent e) {
            if (ClassDefinitionController.this._access != FULL) {
                return;
            }
            super.actionPerformed(e);
            NamedObj object = this.getTarget();
            ClassDefinitionController.this._createChangeRequest(object, false);
        }
    }

    private class CreateSubclassAction
    extends FigureAction {
        public CreateSubclassAction(String commandName) {
            super(commandName);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(85, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        }

        public void actionPerformed(ActionEvent e) {
            if (ClassDefinitionController.this._access != FULL) {
                return;
            }
            super.actionPerformed(e);
            NamedObj object = this.getTarget();
            ClassDefinitionController.this._createChangeRequest(object, true);
        }
    }
}

