/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.gui;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import ptolemy.actor.gui.Effigy;
import ptolemy.actor.gui.EffigyFactory;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Workspace;
import ptolemy.util.ClassUtilities;

public class TextEffigy
extends Effigy {
    private Document _doc;

    public TextEffigy(Workspace workspace) {
        super(workspace);
    }

    public TextEffigy(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
    }

    public Document getDocument() {
        return this._doc;
    }

    public static TextEffigy newTextEffigy(CompositeEntity container, String text) throws Exception {
        TextEffigy effigy = new TextEffigy(container, container.uniqueName("effigy"));
        DefaultStyledDocument doc = new DefaultStyledDocument();
        effigy.setDocument(doc);
        if (text != null) {
            doc.insertString(0, text, null);
        }
        return effigy;
    }

    public static TextEffigy newTextEffigy(CompositeEntity container, URL base, URL in) throws Exception {
        TextEffigy effigy = new TextEffigy(container, container.uniqueName("effigy"));
        DefaultStyledDocument doc = new DefaultStyledDocument();
        effigy.setDocument(doc);
        if (in != null) {
            BufferedReader reader = null;
            try {
                try {
                    InputStream inputStream = null;
                    try {
                        inputStream = in.openStream();
                    }
                    catch (NullPointerException nullPointerException) {
                        throw new IOException("Failed to open '" + in + "', base: '" + base + "' : openStream() threw a " + "NullPointerException");
                    }
                    reader = new BufferedReader(new InputStreamReader(inputStream));
                }
                catch (IOException ex) {
                    try {
                        URL jarURL = ClassUtilities.jarURLEntryResource((String)in.toString());
                        reader = new BufferedReader(new InputStreamReader(jarURL.openStream()));
                        in = jarURL;
                    }
                    catch (Throwable throwable) {
                        throw ex;
                    }
                }
                String line = reader.readLine();
                while (line != null) {
                    doc.insertString(doc.getLength(), String.valueOf(line) + "\n", null);
                    line = reader.readLine();
                }
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
            if (in.getProtocol().equals("file")) {
                String filename = in.getFile();
                File file = new File(filename);
                try {
                    if (!file.canWrite()) {
                        effigy.setModifiable(false);
                    }
                }
                catch (SecurityException securityException) {
                    effigy.setModifiable(false);
                }
            } else {
                effigy.setModifiable(false);
            }
            effigy.uri.setURL(in);
        } else {
            effigy.setModifiable(true);
        }
        return effigy;
    }

    public void setDocument(Document document) {
        this._doc = document;
    }

    public void writeFile(File file) throws IOException {
        if (this._doc != null) {
            FileWriter fileWriter = null;
            try {
                fileWriter = new FileWriter(file);
                try {
                    fileWriter.write(this._doc.getText(0, this._doc.getLength()));
                }
                catch (BadLocationException ex) {
                    throw new IOException("Failed to get text from the document: " + ex);
                }
            }
            finally {
                if (fileWriter != null) {
                    fileWriter.close();
                }
            }
        }
    }

    public static class Factory
    extends EffigyFactory {
        private Method _newTextEffigyURL;

        public Factory(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
            super(container, name);
            try {
                String editorPreference = ".";
                try {
                    editorPreference = System.getProperty("ptolemy.user.texteditor", ".");
                }
                catch (SecurityException securityException) {}
                Class<?> effigyClass = editorPreference.equals("emacs") ? Class.forName("ptolemy.actor.gui.ExternalTextEffigy") : Class.forName("ptolemy.actor.gui.TextEffigy");
                this._newTextEffigyURL = effigyClass.getMethod("newTextEffigy", CompositeEntity.class, URL.class, URL.class);
            }
            catch (ClassNotFoundException ex) {
                throw new IllegalActionException(ex.toString());
            }
            catch (NoSuchMethodException ex) {
                throw new IllegalActionException(ex.toString());
            }
        }

        public boolean canCreateBlankEffigy() {
            return true;
        }

        public Effigy createEffigy(CompositeEntity container, URL base, URL in) throws Exception {
            try {
                return (Effigy)((Object)this._newTextEffigyURL.invoke(null, container, base, in));
            }
            catch (InvocationTargetException ex) {
                throw (Exception)ex.getCause();
            }
        }
    }
}

