/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.gui;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import ptolemy.actor.CompositeActor;
import ptolemy.actor.Manager;
import ptolemy.actor.gui.DebugListenerTableau;
import ptolemy.actor.gui.Effigy;
import ptolemy.actor.gui.ModelFrame;
import ptolemy.actor.gui.PtolemyEffigy;
import ptolemy.actor.gui.Tableau;
import ptolemy.actor.gui.TableauFactory;
import ptolemy.actor.gui.TextEffigy;
import ptolemy.kernel.util.Debuggable;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.KernelException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.util.CancelException;
import ptolemy.util.MessageHandler;

public class RunTableau
extends Tableau {
    private static Color BACKGROUND_COLOR = new Color(0xE5E5E5);

    public RunTableau(PtolemyEffigy container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        NamedObj model = container.getModel();
        if (!(model instanceof CompositeActor)) {
            throw new IllegalActionException((Nameable)this, "Cannot run a model that is not a CompositeActor. It is: " + model);
        }
        CompositeActor actor = (CompositeActor)model;
        Manager manager = actor.getManager();
        if (manager == null) {
            try {
                actor.setManager(new Manager(actor.workspace(), "manager"));
            }
            catch (IllegalActionException ex) {
                throw new IllegalActionException((Nameable)this, (Throwable)ex, "Failed to set manager.  This can occur if you try to run a non-toplevel model that is a component of a toplevel model.  The solution is invoke View -> Run while in a toplevel window.");
            }
        }
        RunFrame frame = new RunFrame(actor, this);
        this.setFrame(frame);
        frame.setBackground(BACKGROUND_COLOR);
    }

    public static class Factory
    extends TableauFactory {
        public Factory(NamedObj container, String name) throws IllegalActionException, NameDuplicationException {
            super(container, name);
        }

        public Tableau createTableau(Effigy effigy) throws Exception {
            if (effigy instanceof PtolemyEffigy) {
                RunTableau tableau = (RunTableau)effigy.getEntity("runTableau");
                if (tableau == null) {
                    tableau = new RunTableau((PtolemyEffigy)effigy, "runTableau");
                }
                return tableau;
            }
            return null;
        }
    }

    public class RunFrame
    extends ModelFrame {
        protected JMenu _debugMenu;

        public RunFrame(CompositeActor model, Tableau tableau) {
            super(model, tableau);
        }

        protected void _addMenus() {
            super._addMenus();
            JMenuItem[] debugMenuItems = new JMenuItem[]{new JMenuItem("Listen to Manager", 77), new JMenuItem("Listen to Director", 68)};
            this._debugMenu = new JMenu("Debug");
            this._debugMenu.setMnemonic(68);
            DebugMenuListener debugMenuListener = new DebugMenuListener();
            int i = 0;
            while (i < debugMenuItems.length) {
                debugMenuItems[i].setActionCommand(debugMenuItems[i].getText());
                debugMenuItems[i].addActionListener(debugMenuListener);
                this._debugMenu.add(debugMenuItems[i]);
                ++i;
            }
            this._menubar.add(this._debugMenu);
        }

        public class DebugMenuListener
        implements ActionListener {
            public void actionPerformed(ActionEvent e) {
                JMenuItem target = (JMenuItem)e.getSource();
                String actionCommand = target.getActionCommand();
                NamedObj model = RunFrame.this.getModel();
                if (model instanceof CompositeActor) {
                    try {
                        Object debug = actionCommand.equals("Listen to Manager") ? ((CompositeActor)model).getManager() : (actionCommand.equals("Listen to Director") ? ((CompositeActor)model).getDirector() : null);
                        if (debug != null) {
                            Effigy effigy = (Effigy)RunTableau.this.getContainer();
                            TextEffigy textEffigy = new TextEffigy(effigy, effigy.uniqueName("debug listener"));
                            DebugListenerTableau tableau = new DebugListenerTableau(textEffigy, textEffigy.uniqueName("debugListener"));
                            tableau.setDebuggable((Debuggable)debug);
                        }
                    }
                    catch (KernelException ex) {
                        try {
                            MessageHandler.warning((String)("Failed to create debug listener: " + (Object)((Object)ex)));
                        }
                        catch (CancelException cancelException) {}
                    }
                }
            }
        }
    }

    public static class TopFactory
    extends Factory {
        public TopFactory(NamedObj container, String name) throws IllegalActionException, NameDuplicationException {
            super(container, name);
        }

        public Tableau createTableau(Effigy effigy) throws Exception {
            return super.createTableau(effigy.masterEffigy());
        }
    }
}

