/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.gui;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import ptolemy.actor.gui.ColorAttribute;
import ptolemy.actor.gui.Configuration;
import ptolemy.actor.gui.JNLPUtilities;
import ptolemy.data.BooleanToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Constants;
import ptolemy.data.expr.ModelScope;
import ptolemy.data.expr.Parameter;
import ptolemy.data.expr.ScopeExtendingAttribute;
import ptolemy.data.expr.SingletonParameter;
import ptolemy.data.expr.StringParameter;
import ptolemy.data.expr.Variable;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.Location;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Settable;
import ptolemy.moml.MoMLParser;
import ptolemy.util.StringUtilities;
import ptolemy.vergil.icon.EditorIcon;
import ptolemy.vergil.kernel.attributes.RectangleAttribute;
import ptolemy.vergil.kernel.attributes.TextAttribute;

public class PtolemyPreferences
extends ScopeExtendingAttribute {
    public ColorAttribute backgroundColor;
    public static String PREFERENCES_FILE_NAME = "PtolemyPreferences.xml";
    public static String PREFERENCES_WITHIN_CONFIGURATION = "actor library.Utilities.LocalPreferences";

    public PtolemyPreferences(NamedObj container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        Parameter _relationSize = new Parameter((NamedObj)this, "_relationSize");
        _relationSize.setTypeEquals((Type)BaseType.DOUBLE);
        _relationSize.setExpression("12.0");
        _relationSize.setDisplayName("Relation size");
        Parameter _linkBendRadius = new Parameter((NamedObj)this, "_linkBendRadius");
        _linkBendRadius.setTypeEquals((Type)BaseType.DOUBLE);
        _linkBendRadius.setExpression("20.0");
        _linkBendRadius.setDisplayName("Link bend radius");
        this.backgroundColor = new ColorAttribute((NamedObj)this, "backgroundColor");
        this.backgroundColor.setExpression("{0.9, 0.9, 0.9, 1.0}");
        this.backgroundColor.setDisplayName("Background Color");
        StringParameter _showParameters = new StringParameter((NamedObj)this, "_showParameters");
        _showParameters.addChoice("None");
        _showParameters.addChoice("Overridden parameters only");
        _showParameters.addChoice("All");
        _showParameters.setExpression("None");
        _showParameters.setDisplayName("Show parameters");
        EditorIcon _icon = new EditorIcon((NamedObj)this, "_icon");
        RectangleAttribute rectangle = new RectangleAttribute((NamedObj)_icon, "rectangle");
        rectangle.width.setExpression("120.0");
        rectangle.height.setExpression("20.0");
        rectangle.fillColor.setExpression("{0.2,1.0,1.0,1.0}");
        Location _location = new Location((NamedObj)rectangle, "_location");
        _location.setExpression("-5.0, -15.0");
        TextAttribute text = new TextAttribute((NamedObj)_icon, "text");
        text.text.setExpression("LocalPreferences");
        SingletonParameter _hideName = new SingletonParameter((NamedObj)this, "_hideName");
        _hideName.setToken((Token)BooleanToken.TRUE);
        _hideName.setVisibility(Settable.EXPERT);
    }

    public static PtolemyPreferences getPtolemyPreferencesWithinConfiguration(Configuration configuration) throws IllegalActionException {
        PtolemyPreferences preferences = null;
        try {
            preferences = (PtolemyPreferences)configuration.getAttribute(PREFERENCES_WITHIN_CONFIGURATION, PtolemyPreferences.class);
        }
        catch (IllegalActionException illegalActionException) {
            return null;
        }
        return preferences;
    }

    public static Token preferenceValue(NamedObj context, String preferenceName) {
        Variable result = ModelScope.getScopedVariable(null, (NamedObj)context, (String)preferenceName);
        if (result != null) {
            try {
                return result.getToken();
            }
            catch (IllegalActionException ex) {
                System.out.println("Warning: Invalid preference: " + (Object)((Object)ex));
            }
        }
        return Constants.get((String)preferenceName);
    }

    public static Token preferenceValueLocal(NamedObj context, String preferenceName) {
        try {
            NamedObj container = context.getContainer();
            if (container != null) {
                Attribute attribute = container.getAttribute(preferenceName);
                if (attribute instanceof Variable) {
                    return ((Variable)attribute).getToken();
                }
                for (PtolemyPreferences preference : container.attributeList(PtolemyPreferences.class)) {
                    attribute = preference.getAttribute(preferenceName);
                    if (!(attribute instanceof Variable)) continue;
                    return ((Variable)attribute).getToken();
                }
            }
        }
        catch (IllegalActionException ex) {
            System.out.println("Warning: Invalid preference: " + (Object)((Object)ex));
        }
        return Constants.get((String)preferenceName);
    }

    public void save() throws IOException {
        String libraryName = String.valueOf(StringUtilities.preferencesDirectory()) + PREFERENCES_FILE_NAME;
        File file = new File(libraryName);
        FileWriter writer = null;
        try {
            writer = new FileWriter(file);
            this.exportMoML(writer);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException ex) {
                    System.out.println("Failed to close \"" + libraryName + "\": " + ex);
                }
            }
        }
    }

    public void setAsDefault() throws IllegalActionException {
        for (Variable parameter : this.attributeList(Variable.class)) {
            Token token = parameter.getToken();
            Constants.add((String)parameter.getName(), (Token)token);
        }
    }

    public static void setDefaultPreferences(Configuration configuration) {
        PtolemyPreferences preferences = null;
        try {
            preferences = PtolemyPreferences.getPtolemyPreferencesWithinConfiguration(configuration);
        }
        catch (IllegalActionException ex) {
            System.out.println("Warning: Problem with preferences attribute in the configuration: " + ex.getMessage());
            return;
        }
        if (preferences == null) {
            return;
        }
        String libraryName = null;
        try {
            libraryName = String.valueOf(StringUtilities.preferencesDirectory()) + PREFERENCES_FILE_NAME;
        }
        catch (Exception ex) {
            System.out.println("Warning: Failed to get the preferences directory (-sandbox always causes this): " + ex.getMessage());
            return;
        }
        File file = new File(libraryName);
        if (file.isFile() && file.canRead()) {
            URL fileURL;
            System.out.println("Opening user preferences " + PREFERENCES_FILE_NAME + "...");
            try {
                fileURL = JNLPUtilities.canonicalizeJarURL(file.toURI().toURL());
            }
            catch (MalformedURLException ex) {
                System.err.println("Malformed preferences URL: " + ex);
                return;
            }
            MoMLParser parser = new MoMLParser(preferences.workspace());
            parser.setContext(preferences.getContainer());
            try {
                parser.parse(fileURL, fileURL);
            }
            catch (Exception ex) {
                System.out.println("Failed to read user preferences file: " + ex);
            }
        }
        try {
            preferences.setAsDefault();
        }
        catch (IllegalActionException ex) {
            System.out.println("Warning: Problem with preferences value: " + ex.getMessage());
        }
    }
}

