/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Constructor;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JPanel;
import ptolemy.actor.CompositeActor;
import ptolemy.actor.ExecutionListener;
import ptolemy.actor.Manager;
import ptolemy.actor.gui.ModelPane;
import ptolemy.gui.BasicJApplet;
import ptolemy.kernel.attributes.VersionAttribute;
import ptolemy.kernel.util.BasicModelErrorHandler;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.ModelErrorHandler;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Workspace;

public class PtolemyApplet
extends BasicJApplet
implements ExecutionListener {
    protected Manager _manager;
    protected boolean _setupOK = true;
    protected NamedObj _toplevel;
    protected Workspace _workspace;
    private JButton _goButton;
    private JButton _stopButton;
    private Manager.State _previousState;

    public void destroy() {
        this.stop();
    }

    public void executionError(Manager manager, Throwable throwable) {
        this.report(throwable);
    }

    public void executionFinished(Manager manager) {
        this.report("execution finished.");
    }

    public String getAppletInfo() {
        return "Ptolemy applet for Ptolemy II " + VersionAttribute.CURRENT_VERSION + "\nPtolemy II comes from UC Berkeley, Department of EECS.\n" + "See http://ptolemy.eecs.berkeley.edu/ptolemyII" + "\n(Build: $Id: PtolemyApplet.java,v 1.70 2006/08/21 23:09:53 cxh Exp $)";
    }

    public String[][] getParameterInfo() {
        String[][] newInfo = new String[][]{{"modelClass", "", "Class name for an instance of NamedObj"}, {"orientation", "", "Orientation: vertical, horizontal, or controls_only"}, {"controls", "", "List of on-screen controls"}, {"autoRun", "boolean", "Determines if the model is run automatically"}};
        return this._concatStringArrays(super.getParameterInfo(), newInfo);
    }

    public void init() {
        super.init();
        this._setupOK = true;
        this._workspace = new Workspace(this.getClass().getName());
        try {
            this._toplevel = this._createModel(this._workspace);
            this._toplevel.setModelErrorHandler((ModelErrorHandler)new BasicModelErrorHandler());
            if (this._toplevel.getContainer() == null && this._toplevel instanceof CompositeActor) {
                if (((CompositeActor)this._toplevel).getManager() == null) {
                    this._manager = new Manager(this._workspace, "manager");
                    this._manager.addExecutionListener((ExecutionListener)this);
                    ((CompositeActor)this._toplevel).setManager(this._manager);
                } else {
                    this._manager = ((CompositeActor)this._toplevel).getManager();
                }
            }
        }
        catch (Exception ex) {
            this._setupOK = false;
            this.report("Creation of model failed:\n", ex);
        }
        this._createView();
    }

    public void managerStateChanged(Manager manager) {
        Manager.State newState = manager.getState();
        if (newState != this._previousState) {
            this.report(manager.getState().getDescription());
            this._previousState = newState;
        }
    }

    public void start() {
        if (!this._setupOK) {
            return;
        }
        String autoRunSpec = this.getParameter("autoRun");
        boolean autoRun = true;
        if (autoRunSpec != null) {
            autoRun = Boolean.valueOf(autoRunSpec);
        }
        if (autoRun) {
            try {
                this._go();
            }
            catch (Exception ex) {
                this.report(ex);
            }
        }
    }

    public void stop() {
        if (this._manager != null && this._setupOK) {
            this._manager.stop();
        }
    }

    protected NamedObj _createModel(Workspace workspace) throws Exception {
        NamedObj result = null;
        String modelSpecification = this.getParameter("modelClass");
        if (modelSpecification != null) {
            Object[] arguments = new Object[]{workspace};
            Class<?> modelClass = Class.forName(modelSpecification);
            Constructor<?>[] constructors = modelClass.getConstructors();
            boolean foundConstructor = false;
            int i = 0;
            while (i < constructors.length) {
                Constructor<?> constructor = constructors[i];
                Class<?>[] parameterTypes = constructor.getParameterTypes();
                if (parameterTypes.length == arguments.length) {
                    boolean match = true;
                    int j = 0;
                    while (j < parameterTypes.length) {
                        if (!parameterTypes[j].isInstance(arguments[j])) {
                            match = false;
                            break;
                        }
                        ++j;
                    }
                    if (match) {
                        result = (NamedObj)constructor.newInstance(arguments);
                        foundConstructor = true;
                    }
                }
                ++i;
            }
            if (!foundConstructor) {
                throw new IllegalActionException("Cannot find a suitable constructor for " + modelSpecification);
            }
        }
        if (result == null) {
            if (this._toplevel == null) {
                throw new Exception("Applet does not specify a model.");
            }
            return this._toplevel;
        }
        return result;
    }

    protected JPanel _createRunControls(int numberOfButtons) {
        JPanel panel = new JPanel();
        if (numberOfButtons > 0) {
            this._goButton = new JButton("Go");
            panel.add(this._goButton);
            this._goButton.addActionListener(new GoButtonListener());
        }
        if (numberOfButtons > 1) {
            this._stopButton = new JButton("Stop");
            panel.add(this._stopButton);
            this._stopButton.addActionListener(new StopButtonListener());
        }
        return panel;
    }

    protected void _createView() {
        if (!(this._toplevel instanceof CompositeActor)) {
            return;
        }
        String orientationSpec = this.getParameter("orientation");
        int orientation = 1;
        if (orientationSpec != null) {
            if (orientationSpec.trim().toLowerCase().equals("horizontal")) {
                orientation = 0;
            } else if (orientationSpec.trim().toLowerCase().equals("controls_only")) {
                orientation = 2;
            }
        }
        String controlsSpec = this.getParameter("controls");
        int controls = 1;
        if (controlsSpec != null) {
            controls = 0;
            StringTokenizer tokenizer = new StringTokenizer(controlsSpec, ",");
            while (tokenizer.hasMoreTokens()) {
                String controlSpec = tokenizer.nextToken().trim().toLowerCase();
                if (controlSpec.equals("buttons")) {
                    controls |= 1;
                    continue;
                }
                if (controlSpec.equals("topparameters")) {
                    controls |= 2;
                    continue;
                }
                if (controlSpec.equals("directorparameters")) {
                    controls |= 4;
                    continue;
                }
                if (controlSpec.equals("none")) {
                    controls = 0;
                    continue;
                }
                this.report("Warning: unrecognized controls: " + controlSpec);
            }
        }
        ModelPane pane = new ModelPane((CompositeActor)this._toplevel, orientation, controls);
        pane.setBackground(null);
        this.getContentPane().add(pane);
    }

    protected void _go() throws IllegalActionException {
        if (!this._setupOK) {
            return;
        }
        if (this._manager.getState() == Manager.IDLE) {
            this._manager.startRun();
        }
    }

    protected void _stop() {
        if (!this._setupOK) {
            return;
        }
        this._manager.stop();
    }

    private class GoButtonListener
    implements ActionListener {
        private GoButtonListener() {
        }

        public void actionPerformed(ActionEvent event) {
            try {
                PtolemyApplet.this._go();
            }
            catch (Exception ex) {
                PtolemyApplet.this.report(ex);
            }
        }
    }

    private class StopButtonListener
    implements ActionListener {
        private StopButtonListener() {
        }

        public void actionPerformed(ActionEvent event) {
            PtolemyApplet.this._stop();
        }
    }
}

