/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.gui;

import java.util.List;
import ptolemy.actor.gui.Effigy;
import ptolemy.actor.gui.MatrixPane;
import ptolemy.actor.gui.Tableau;
import ptolemy.actor.gui.TableauFactory;
import ptolemy.actor.gui.TableauFrame;
import ptolemy.actor.gui.TokenEffigy;
import ptolemy.actor.gui.TokenTableau;
import ptolemy.data.MatrixToken;
import ptolemy.data.Token;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;

public class MatrixTokenTableau
extends TokenTableau {
    private MatrixPane _pane;

    public MatrixTokenTableau(Effigy container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
    }

    public MatrixTokenTableau(Effigy container, String name, TableauFrame frame) throws IllegalActionException, NameDuplicationException {
        super(container, name, frame);
    }

    public void append(Token token) {
        if (this._pane != null && token instanceof MatrixToken) {
            this._pane.display((MatrixToken)token);
        }
    }

    public void append(List list) {
        if (this._pane != null) {
            for (Object token : list) {
                if (!(token instanceof MatrixToken)) continue;
                this._pane.display((MatrixToken)token);
            }
        }
    }

    public static boolean canDisplay(Token token) {
        return token instanceof MatrixToken;
    }

    public void clear() {
        if (this._pane != null) {
            this._pane.clear();
        }
    }

    public void createFrame(TableauFrame frame) throws IllegalActionException {
        TokenEffigy effigy = (TokenEffigy)this.getContainer();
        if (frame == null) {
            frame = new TableauFrame(this, null);
        }
        this.setFrame(frame);
        this._pane = new MatrixPane();
        frame.getContentPane().add(this._pane);
        for (Object token : effigy.getTokens()) {
            this._pane.display((MatrixToken)token);
        }
    }

    public static class Factory
    extends TableauFactory {
        public Factory(NamedObj container, String name) throws IllegalActionException, NameDuplicationException {
            super(container, name);
        }

        public Tableau createTableau(Effigy effigy) throws Exception {
            if (effigy instanceof TokenEffigy) {
                effigy.setTableauFactory(this);
                TokenTableau tableau = (TokenTableau)effigy.getEntity("tokenTableau");
                if (tableau != null) {
                    return tableau;
                }
                for (Object token : ((TokenEffigy)effigy).getTokens()) {
                    if (MatrixTokenTableau.canDisplay((Token)token)) continue;
                    return null;
                }
                return new MatrixTokenTableau(effigy, "tokenTableau");
            }
            return null;
        }
    }
}

