/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import ptolemy.actor.gui.Configuration;
import ptolemy.actor.gui.EditParametersDialog;
import ptolemy.actor.gui.EditorFactory;
import ptolemy.actor.gui.ModelDirectory;
import ptolemy.actor.gui.TextEffigy;
import ptolemy.data.expr.FileParameter;
import ptolemy.data.expr.StringParameter;
import ptolemy.gui.ComponentDialog;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;

public class FileOrURLEditorFactory
extends EditorFactory {
    private static String[] _moreButtons = new String[]{"Configure Parameters", "Edit File", "Help", "Cancel"};
    private static String[] _moreButtonsNoHelp = new String[]{"Configure Parameters", "Edit File", "Cancel"};

    public FileOrURLEditorFactory(NamedObj container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
    }

    public void createEditor(NamedObj object, Frame parent) {
        String button;
        ComponentDialog dialog = null;
        FileParameter helpFileParameter = (FileParameter)object.getAttribute("help");
        String[] buttons = _moreButtons;
        if (helpFileParameter == null) {
            buttons = _moreButtonsNoHelp;
        }
        if ((button = (dialog = new ComponentDialog(parent, "Edit Parameters or File", this.createEditorPane(), buttons)).buttonPressed()).equals("Cancel")) {
            return;
        }
        if (button.equals(_moreButtons[0])) {
            new EditParametersDialog(parent, object);
            return;
        }
        Configuration configuration = (Configuration)Configuration.findEffigy(object.getContainer()).toplevel();
        if (button.equals(_moreButtons[1])) {
            FileParameter fileOrURLParameter = (FileParameter)object.getAttribute("fileOrURL");
            if (fileOrURLParameter == null) {
                throw new InternalErrorException((Nameable)object, null, "No \"fileOrURL\" attribute.");
            }
            try {
                if (fileOrURLParameter.asURL() == null) {
                    ModelDirectory directory = configuration.getDirectory();
                    StringParameter initialDefaultContentsParameter = (StringParameter)object.getAttribute("initialDefaultContents");
                    String defaultText = "";
                    if (initialDefaultContentsParameter != null) {
                        defaultText = initialDefaultContentsParameter.getExpression();
                    }
                    TextEffigy effigy = TextEffigy.newTextEffigy(directory, defaultText);
                    configuration.createPrimaryTableau(effigy);
                } else {
                    URL fileURL = fileOrURLParameter.asFile().toURI().toURL();
                    configuration.openModel(null, fileURL, fileURL.toExternalForm());
                }
            }
            catch (Exception ex) {
                throw new InternalErrorException((Nameable)object, (Throwable)ex, "Failed to open \"" + fileOrURLParameter + "\"");
            }
            return;
        }
        if (button.equals(_moreButtons[2])) {
            try {
                if (helpFileParameter == null) {
                    throw new InternalErrorException("No help parameter?");
                }
                URL fileURL = helpFileParameter.asFile().toURI().toURL();
                configuration.openModel(null, fileURL, fileURL.toExternalForm());
            }
            catch (Exception ex) {
                throw new InternalErrorException((Nameable)object, (Throwable)ex, "Failed to open \"" + helpFileParameter + "\"");
            }
            return;
        }
    }

    public Component createEditorPane() {
        JPanel panel = new JPanel();
        JTextArea textArea = new JTextArea("To edit name of the file that contains the parameters, select \"" + _moreButtons[0] + "\".  To edit the file itself that contains the parameters," + " select \"" + _moreButtons[1] + "\".", 3, 40);
        textArea.setEditable(false);
        textArea.setBorder(BorderFactory.createEtchedBorder());
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(true);
        JScrollPane pane = new JScrollPane(textArea);
        pane.setPreferredSize(new Dimension(400, 100));
        panel.add(pane);
        return panel;
    }
}

