/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.workbench.model.editor.ui.properties;

import com.isencia.passerelle.actor.Actor;
import com.isencia.passerelle.workbench.model.editor.ui.descriptor.CheckboxPropertyDescriptor;
import com.isencia.passerelle.workbench.model.editor.ui.descriptor.ColorPropertyDescriptor;
import com.isencia.passerelle.workbench.model.editor.ui.descriptor.FilePickerPropertyDescriptor;
import com.isencia.passerelle.workbench.model.editor.ui.descriptor.FloatPropertyDescriptor;
import com.isencia.passerelle.workbench.model.editor.ui.descriptor.IntegerPropertyDescriptor;
import com.isencia.passerelle.workbench.model.editor.ui.figure.ActorFigure;
import com.isencia.passerelle.workbench.model.ui.ComponentUtility;
import com.isencia.passerelle.workbench.model.utils.ModelChangeRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.views.properties.ComboBoxPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;
import ptolemy.actor.TypedIOPort;
import ptolemy.actor.gui.ColorAttribute;
import ptolemy.data.expr.FileParameter;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.kernel.util.AbstractSettableAttribute;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.ChangeRequest;
import ptolemy.kernel.util.NamedObj;

public class EntityPropertySource
implements IPropertySource {
    private NamedObj entity;
    private IFigure figure;

    public EntityPropertySource(NamedObj namedObj, IFigure iFigure) {
        this.entity = namedObj;
        this.figure = iFigure;
        this.initializeOptions(namedObj);
    }

    private void initializeOptions(NamedObj namedObj) {
        if (namedObj instanceof Actor) {
            try {
                ((Actor)namedObj).initialize();
            }
            catch (Exception exception) {}
            this.configureParameters((Actor)namedObj);
        }
    }

    public Object getEditableValue() {
        return this.entity;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        ArrayList<PropertyDescriptor> arrayList = new ArrayList<PropertyDescriptor>();
        List list = this.entity.attributeList(Parameter.class);
        for (Parameter parameter : list) {
            this.addPropertyDescriptor(arrayList, (Attribute)parameter, parameter.getType());
        }
        return arrayList.toArray(new IPropertyDescriptor[0]);
    }

    private void configureParameters(Actor actor) {
        if (actor.getOptionsFactory() != null) {
            List list = actor.attributeList(Parameter.class);
            for (Parameter parameter : list) {
                actor.getOptionsFactory().setOptionsForParameter(parameter);
            }
        }
    }

    public Object getPropertyValue(Object object) {
        AbstractSettableAttribute abstractSettableAttribute = (AbstractSettableAttribute)this.entity.getAttribute((String)object);
        if (abstractSettableAttribute instanceof ColorAttribute) {
            return new RGB(0, 10, 10);
        }
        if (this.hasOptions((Attribute)abstractSettableAttribute)) {
            String[] stringArray = ((Parameter)abstractSettableAttribute).getChoices();
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].equals(abstractSettableAttribute.getExpression())) {
                    return n;
                }
                ++n;
            }
        } else if (abstractSettableAttribute instanceof Parameter) {
            Parameter parameter = (Parameter)abstractSettableAttribute;
            if (BaseType.INT.equals((Object)parameter.getType())) {
                return new Integer(abstractSettableAttribute.getExpression());
            }
            if (BaseType.FLOAT.equals((Object)parameter.getType())) {
                return new Float(abstractSettableAttribute.getExpression());
            }
            if (BaseType.BOOLEAN.equals((Object)parameter.getType())) {
                return new Boolean(abstractSettableAttribute.getExpression());
            }
        }
        return abstractSettableAttribute.getExpression();
    }

    public boolean isPropertySet(Object object) {
        return true;
    }

    public void resetPropertyValue(Object object) {
    }

    public void setPropertyValue(final Object object, final Object object2) {
        this.entity.requestChange((ChangeRequest)new ModelChangeRequest(EntityPropertySource.class, this.entity, "changeParameter"){

            protected void _execute() throws Exception {
                Parameter parameter = (Parameter)EntityPropertySource.this.entity.getAttribute((String)object);
                String string = parameter.getExpression();
                if (EntityPropertySource.this.hasOptions((Attribute)parameter)) {
                    parameter.setExpression(parameter.getChoices()[(Integer)object2]);
                } else {
                    parameter.setExpression(object2.toString());
                }
                if (EntityPropertySource.this.entity.getClass().getSimpleName().equals("Synchronizer") && parameter.getName().equals("Extra nr of ports")) {
                    this.changeNumberOfPortsOnFigure(object2, parameter, string);
                }
            }

            private void changeNumberOfPortsOnFigure(Object object3, Parameter parameter, String string) {
                try {
                    if (!string.equals(object3)) {
                        int n;
                        int n2 = Integer.parseInt(object3.toString());
                        if (n2 > (n = Integer.parseInt(string))) {
                            EntityPropertySource.this.entity.attributeChanged((Attribute)parameter);
                            EntityPropertySource.this.updateFigure((ActorFigure)EntityPropertySource.this.figure, (Actor)EntityPropertySource.this.entity);
                        } else {
                            EntityPropertySource.this.deletePort((ActorFigure)EntityPropertySource.this.figure, (Actor)EntityPropertySource.this.entity, n, n2);
                        }
                        EntityPropertySource.this.figure.repaint();
                    }
                }
                catch (Exception exception) {}
            }
        });
    }

    protected void updateFigure(ActorFigure actorFigure, Actor actor) {
        List list3;
        List list2 = actor.inputPortList();
        if (list2 != null) {
            for (List list3 : list2) {
                if (actorFigure.getInputPort(list3.getName()) != null) continue;
                actorFigure.addInput(list3.getName(), list3.getDisplayName());
            }
        }
        if ((list3 = actor.outputPortList()) != null) {
            for (TypedIOPort typedIOPort : list3) {
                if (actorFigure.getOutputPort(typedIOPort.getName()) != null) continue;
                actorFigure.addOutput(typedIOPort.getName(), typedIOPort.getDisplayName());
            }
        }
    }

    private void deletePort(ActorFigure actorFigure, Actor actor, int n, int n2) {
        actor.inputPortList();
        int n3 = n - 1;
        while (n3 >= n2) {
            actorFigure.removeInput("input" + n3);
            ComponentUtility.deleteConnections((NamedObj)actor.getPort("input" + n3).getContainer());
            --n3;
        }
        actor.outputPortList();
        n3 = n - 1;
        while (n3 >= n2) {
            actorFigure.removeOutput("output" + n3);
            ComponentUtility.deleteConnections((NamedObj)actor.getPort("output" + n3).getContainer());
            --n3;
        }
    }

    protected void addPropertyDescriptor(Collection<PropertyDescriptor> collection, Attribute attribute, Type type) {
        if (attribute instanceof ColorAttribute) {
            collection.add(new ColorPropertyDescriptor(attribute.getName(), attribute.getDisplayName()));
        } else if (attribute instanceof FileParameter) {
            collection.add(new FilePickerPropertyDescriptor(attribute.getName(), attribute.getDisplayName()));
        } else if (this.hasOptions(attribute)) {
            collection.add((PropertyDescriptor)new ComboBoxPropertyDescriptor((Object)attribute.getName(), attribute.getDisplayName(), ((Parameter)attribute).getChoices()));
        } else if (BaseType.INT.equals((Object)type)) {
            collection.add(new IntegerPropertyDescriptor(attribute.getName(), attribute.getDisplayName()));
        } else if (BaseType.FLOAT.equals((Object)type)) {
            collection.add(new FloatPropertyDescriptor(attribute.getName(), attribute.getDisplayName()));
        } else if (BaseType.BOOLEAN.equals((Object)type)) {
            collection.add(new CheckboxPropertyDescriptor(attribute.getName(), attribute.getDisplayName()));
        } else {
            collection.add((PropertyDescriptor)new TextPropertyDescriptor((Object)attribute.getName(), attribute.getDisplayName()));
        }
    }

    private boolean hasOptions(Attribute attribute) {
        return attribute instanceof Parameter && ((Parameter)attribute).getChoices() != null && ((Parameter)attribute).getChoices().length > 0;
    }
}

