/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.workbench.model.editor.ui.palette;

import com.isencia.passerelle.workbench.model.editor.ui.Activator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.gef.palette.CombinedTemplateCreationEntry;
import org.eclipse.gef.palette.ConnectionCreationToolEntry;
import org.eclipse.gef.palette.MarqueeToolEntry;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteGroup;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.PaletteStack;
import org.eclipse.gef.palette.PanningSelectionToolEntry;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.gef.tools.MarqueeSelectionTool;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.part.EditorPart;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaletteBuilder {
    private static Logger logger = LoggerFactory.getLogger(PaletteBuilder.class);
    public static final String PALETTE_CONTAINER_GENERAL = "General";
    private static Map<String, ImageDescriptor> actorIconMap = new HashMap<String, ImageDescriptor>();

    public static ImageDescriptor getIcon(String string) {
        return actorIconMap.get(string);
    }

    public static PaletteRoot createPalette(EditorPart editorPart) {
        PaletteRoot paletteRoot = new PaletteRoot();
        paletteRoot.addAll(PaletteBuilder.createCategories(paletteRoot, editorPart));
        return paletteRoot;
    }

    private static List createCategories(PaletteRoot paletteRoot, EditorPart editorPart) {
        Object object;
        String string;
        String string2;
        IConfigurationElement iConfigurationElement;
        int n;
        int n2;
        IConfigurationElement[] iConfigurationElementArray;
        IConfigurationElement[] iConfigurationElementArray2;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(PaletteBuilder.createControlGroup(paletteRoot));
        LinkedHashMap<String, PaletteContainer> linkedHashMap = new LinkedHashMap<String, PaletteContainer>();
        try {
            iConfigurationElementArray2 = Platform.getExtensionRegistry().getConfigurationElementsFor("com.isencia.passerelle.engine.actorGroups");
            if (iConfigurationElementArray2 != null) {
                iConfigurationElementArray = iConfigurationElementArray2;
                n2 = iConfigurationElementArray2.length;
                n = 0;
                while (n < n2) {
                    iConfigurationElement = iConfigurationElementArray[n];
                    string2 = iConfigurationElement.getAttribute("name");
                    string = iConfigurationElement.getAttribute("id");
                    if (!linkedHashMap.containsKey(string2)) {
                        object = PaletteBuilder.createPaletteContainer(string2);
                        linkedHashMap.put(string, (PaletteContainer)object);
                        arrayList.add(object);
                    }
                    ++n;
                }
            }
        }
        catch (Exception exception) {
            logger.error("Error creating Palette Categories", (Throwable)exception);
        }
        try {
            iConfigurationElementArray2 = Platform.getExtensionRegistry().getConfigurationElementsFor("com.isencia.passerelle.engine.actors");
            if (iConfigurationElementArray2 != null) {
                iConfigurationElementArray = iConfigurationElementArray2;
                n2 = iConfigurationElementArray2.length;
                n = 0;
                while (n < n2) {
                    iConfigurationElement = iConfigurationElementArray[n];
                    string2 = iConfigurationElement.getAttribute("name");
                    string = iConfigurationElement.getAttribute("group");
                    object = iConfigurationElement.getAttribute("icon");
                    Object object2 = "icons/ide.gif";
                    if (object != null && !((String)object).isEmpty()) {
                        object2 = object;
                    }
                    String string3 = iConfigurationElement.getDeclaringExtension().getContributor().getName();
                    Class<?> clazz = PaletteBuilder.loadClass(iConfigurationElement, string3);
                    ImageDescriptor imageDescriptor = Activator.getImageDescriptor(string3, (String)object2);
                    if (imageDescriptor == null) {
                        imageDescriptor = Activator.getImageDescriptor((String)object2);
                    }
                    if (clazz.getName().equals("ptolemy.actor.TypedIOPort")) {
                        actorIconMap.put(string2, imageDescriptor);
                    }
                    actorIconMap.put(clazz.getName(), imageDescriptor);
                    CombinedTemplateCreationEntry combinedTemplateCreationEntry = new CombinedTemplateCreationEntry(string2, string2, (CreationFactory)new ClassTypeFactory(clazz, string2), imageDescriptor, imageDescriptor);
                    PaletteContainer paletteContainer = (PaletteContainer)linkedHashMap.get(string);
                    if (paletteContainer != null) {
                        paletteContainer.add((PaletteEntry)combinedTemplateCreationEntry);
                    } else {
                        PaletteContainer paletteContainer2 = (PaletteContainer)linkedHashMap.get("");
                        if (paletteContainer2 == null) {
                            paletteContainer2 = PaletteBuilder.createPaletteContainer("");
                            arrayList.add(paletteContainer2);
                        }
                        paletteContainer2.add((PaletteEntry)combinedTemplateCreationEntry);
                    }
                    ++n;
                }
            }
        }
        catch (Exception exception) {
            logger.error("Error creating Palette Categories", (Throwable)exception);
        }
        return arrayList;
    }

    private static Class<?> loadClass(IConfigurationElement iConfigurationElement, String string) {
        Bundle bundle = Platform.getBundle((String)string);
        try {
            return bundle.loadClass(iConfigurationElement.getAttribute("class"));
        }
        catch (Exception exception) {
            logger.error("Cannot load class " + iConfigurationElement.getAttribute("class"), (Throwable)exception);
            return null;
        }
    }

    private static PaletteContainer createControlGroup(PaletteRoot paletteRoot) {
        PaletteGroup paletteGroup = new PaletteGroup("ControlGroup");
        ArrayList<Object> arrayList = new ArrayList<Object>();
        PanningSelectionToolEntry panningSelectionToolEntry = new PanningSelectionToolEntry();
        arrayList.add(panningSelectionToolEntry);
        paletteRoot.setDefaultEntry((ToolEntry)panningSelectionToolEntry);
        PaletteStack paletteStack = new PaletteStack("Stack", "", null);
        paletteStack.add((PaletteEntry)new MarqueeToolEntry());
        MarqueeToolEntry marqueeToolEntry = new MarqueeToolEntry();
        marqueeToolEntry.setToolProperty(MarqueeSelectionTool.PROPERTY_MARQUEE_BEHAVIOR, (Object)new Integer(MarqueeSelectionTool.BEHAVIOR_CONNECTIONS_TOUCHED));
        paletteStack.add((PaletteEntry)marqueeToolEntry);
        marqueeToolEntry = new MarqueeToolEntry();
        marqueeToolEntry.setToolProperty(MarqueeSelectionTool.PROPERTY_MARQUEE_BEHAVIOR, (Object)new Integer(MarqueeSelectionTool.BEHAVIOR_CONNECTIONS_TOUCHED | MarqueeSelectionTool.BEHAVIOR_NODES_CONTAINED));
        paletteStack.add((PaletteEntry)marqueeToolEntry);
        paletteStack.setUserModificationPermission(1);
        arrayList.add(paletteStack);
        panningSelectionToolEntry = new ConnectionCreationToolEntry("Connection", "Connection", null, Activator.getImageDescriptor("icons/connection16.gif"), Activator.getImageDescriptor("icons/connection24.gif"));
        arrayList.add(panningSelectionToolEntry);
        paletteGroup.addAll(arrayList);
        return paletteGroup;
    }

    private static PaletteContainer createPaletteContainer(String string) {
        PaletteDrawer paletteDrawer = new PaletteDrawer(string, null);
        return paletteDrawer;
    }

    public static class ClassTypeFactory
    implements CreationFactory {
        private Class<?> type;
        private String name;

        public ClassTypeFactory(Class<?> clazz, String string) {
            this.type = clazz;
            this.name = string;
        }

        public Object getNewObject() {
            return this.name;
        }

        public Object getObjectType() {
            return this.type;
        }
    }
}

