/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.workbench.model.editor.ui.figure;

import com.isencia.passerelle.workbench.model.editor.ui.IBody;
import com.isencia.passerelle.workbench.model.editor.ui.figure.CompoundIOFigure;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.BorderLayout;
import org.eclipse.draw2d.Clickable;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

public class CompoundOutputFigure
extends CompoundIOFigure {
    public static final String OUTPUT_PORT_NAME = "output";

    public CompoundOutputFigure(String string) {
        super(string);
        this.addInput(OUTPUT_PORT_NAME, OUTPUT_PORT_NAME);
        this.setBackgroundColor(ColorConstants.black);
    }

    @Override
    protected Color getBackGroundcolor() {
        return ColorConstants.white;
    }

    @Override
    protected IFigure generateBody(Image image, Clickable[] clickableArray) {
        Body body = new Body();
        body.setBorder((Border)new LineBorder());
        Clickable[] clickableArray2 = clickableArray;
        int n = clickableArray.length;
        int n2 = 0;
        while (n2 < n) {
            Clickable clickable = clickableArray2[n2];
            body.initClickable(clickable);
            ++n2;
        }
        return body;
    }

    private class Body
    extends RectangleFigure
    implements IBody {
        public Body() {
            BorderLayout borderLayout = new BorderLayout();
            this.setLayoutManager((LayoutManager)borderLayout);
            this.setBackgroundColor(ColorConstants.white);
            this.setOpaque(true);
        }

        @Override
        public void initClickable(Clickable clickable) {
            if (clickable != null) {
                this.add((IFigure)clickable, BorderLayout.BOTTOM);
            }
        }

        protected void fillShape(Graphics graphics) {
            graphics.pushState();
            graphics.setForegroundColor(ColorConstants.white);
            graphics.setBackgroundColor(ColorConstants.white);
            graphics.popState();
            graphics.setForegroundColor(ColorConstants.black);
            int n = this.bounds.getTop().x;
            int n2 = this.bounds.y + (this.bounds.getBottom().y - this.bounds.getTop().y) / 2;
            PointList pointList = new PointList();
            pointList.addPoint(n - (this.bounds.getRight().x - n) / 2, n2 - (this.bounds.getBottom().y - n2) / 2);
            pointList.addPoint(n, n2 - (this.bounds.getBottom().y - n2) / 3);
            pointList.addPoint(n + (this.bounds.getRight().x - n) / 2, n2 - (this.bounds.getBottom().y - n2) / 3);
            pointList.addPoint(n + (this.bounds.getRight().x - n) / 2, n2 + (this.bounds.getBottom().y - n2) / 3);
            pointList.addPoint(n, n2 + (this.bounds.getBottom().y - n2) / 3);
            pointList.addPoint(n - (this.bounds.getRight().x - n) / 2, n2 + (this.bounds.getBottom().y - n2) / 2);
            graphics.fillPolygon(pointList);
            graphics.drawPolyline(pointList);
        }

        public Dimension getPreferredSize(int n, int n2) {
            Dimension dimension = this.getParent().getSize().getCopy();
            return dimension;
        }

        @Override
        public void initImage(Image image) {
        }
    }
}

