/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.workbench.model.editor.ui.figure;

import com.isencia.passerelle.workbench.model.editor.ui.IBody;
import com.isencia.passerelle.workbench.model.editor.ui.figure.AbstractNodeFigure;
import com.isencia.passerelle.workbench.model.editor.ui.figure.FixedConnectionAnchor;
import com.isencia.passerelle.workbench.model.editor.ui.figure.InputPortFigure;
import com.isencia.passerelle.workbench.model.editor.ui.figure.OutputPortFigure;
import com.isencia.passerelle.workbench.model.editor.ui.figure.PortFigure;
import java.util.HashMap;
import java.util.Vector;
import org.eclipse.draw2d.AbstractBorder;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.BorderLayout;
import org.eclipse.draw2d.Clickable;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ImageFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

public class ActorFigure
extends AbstractNodeFigure {
    public static final Color ACTOR_BACKGROUND_COLOR = ColorConstants.gray;
    private IFigure body = null;
    private InputPorts inputPorts = null;
    private OutputPorts outputPorts = null;
    private HashMap<String, PortFigure> inputPortMap = new HashMap();
    private HashMap<String, PortFigure> outputPortMap = new HashMap();

    public HashMap<String, PortFigure> getInputPortMap() {
        return this.inputPortMap;
    }

    public HashMap<String, PortFigure> getOutputPortMap() {
        return this.outputPortMap;
    }

    public ActorFigure(String string, Image image, Clickable[] clickableArray) {
        super(string);
        this.add((IFigure)new CompositeFigure(image, clickableArray));
    }

    protected IFigure generateBody(Image image, Clickable[] clickableArray) {
        Body body = new Body();
        body.setBorder((Border)new LineBorder());
        body.initImage(image);
        Clickable[] clickableArray2 = clickableArray;
        int n = clickableArray.length;
        int n2 = 0;
        while (n2 < n) {
            Clickable clickable = clickableArray2[n2];
            body.initClickable(clickable);
            ++n2;
        }
        return body;
    }

    public void setBackgroundColor(Color color) {
        if (this.body != null) {
            this.body.setBackgroundColor(color);
        }
    }

    public Color getBackgroundColor() {
        if (this.body != null) {
            return this.body.getBackgroundColor();
        }
        return super.getBackgroundColor();
    }

    public PortFigure addInput(String string, String string2) {
        InputPortFigure inputPortFigure = new InputPortFigure(string);
        inputPortFigure.setToolTip((IFigure)new Label(string2));
        int n = 0;
        int n2 = 0;
        inputPortFigure.setLocation(new Point(n, n2));
        if (this.inputPorts != null) {
            this.inputPorts.add((IFigure)inputPortFigure);
            this.inputPortMap.put(string, inputPortFigure);
        }
        FixedConnectionAnchor fixedConnectionAnchor = new FixedConnectionAnchor((IFigure)inputPortFigure);
        fixedConnectionAnchor.offsetV = 4;
        this.getTargetConnectionAnchors().add((ConnectionAnchor)fixedConnectionAnchor);
        this.connectionAnchors.put(string, fixedConnectionAnchor);
        return inputPortFigure;
    }

    public void removeInput(String string) {
        PortFigure portFigure = this.inputPortMap.get(string);
        if (portFigure != null) {
            this.inputPorts.remove((IFigure)portFigure);
            this.inputPortMap.remove(string);
            ConnectionAnchor connectionAnchor = this.getConnectionAnchor(string);
            if (connectionAnchor != null) {
                this.getTargetConnectionAnchors().remove(connectionAnchor);
            }
        }
    }

    public void removeOutput(String string) {
        PortFigure portFigure = this.outputPortMap.get(string);
        if (portFigure != null) {
            this.outputPorts.remove((IFigure)portFigure);
            this.outputPortMap.remove(string);
            ConnectionAnchor connectionAnchor = this.getConnectionAnchor(string);
            if (connectionAnchor != null) {
                this.getSourceConnectionAnchors().remove(connectionAnchor);
            }
        }
    }

    public PortFigure addOutput(String string, String string2) {
        OutputPortFigure outputPortFigure = new OutputPortFigure(string);
        outputPortFigure.setToolTip((IFigure)new Label(string2));
        int n = 0;
        int n2 = 0;
        outputPortFigure.setLocation(new Point(n, n2));
        if (this.outputPorts != null) {
            this.outputPorts.add((IFigure)outputPortFigure);
            this.outputPortMap.put(string, outputPortFigure);
        }
        FixedConnectionAnchor fixedConnectionAnchor = new FixedConnectionAnchor((IFigure)outputPortFigure);
        fixedConnectionAnchor.offsetV = 4;
        fixedConnectionAnchor.offsetH = 6;
        this.getSourceConnectionAnchors().add((ConnectionAnchor)fixedConnectionAnchor);
        this.connectionAnchors.put(string, fixedConnectionAnchor);
        return outputPortFigure;
    }

    public PortFigure getInputPort(String string) {
        return this.inputPortMap.get(string);
    }

    public PortFigure getOutputPort(String string) {
        return this.outputPortMap.get(string);
    }

    private class Body
    extends RectangleFigure
    implements IBody {
        public Body() {
            BorderLayout borderLayout = new BorderLayout();
            this.setLayoutManager((LayoutManager)borderLayout);
            this.setBackgroundColor(ACTOR_BACKGROUND_COLOR);
            this.setOpaque(true);
        }

        @Override
        public void initImage(Image image) {
            if (image != null) {
                ImageFigure imageFigure = new ImageFigure(image);
                imageFigure.setAlignment(8);
                imageFigure.setBorder((Border)new MarginBorder(5, 5, 0, 0));
                this.add((IFigure)imageFigure, BorderLayout.TOP);
            }
        }

        @Override
        public void initClickable(Clickable clickable) {
            if (clickable != null) {
                this.add((IFigure)clickable, BorderLayout.BOTTOM);
            }
        }

        protected void fillShape(Graphics graphics) {
            graphics.pushState();
            graphics.setForegroundColor(ColorConstants.white);
            graphics.setBackgroundColor(this.getBackgroundColor());
            graphics.fillGradient(this.getBounds(), true);
            graphics.popState();
        }

        public Dimension getPreferredSize(int n, int n2) {
            Dimension dimension = this.getParent().getSize().getCopy();
            return dimension;
        }
    }

    private class CompositeFigure
    extends Figure {
        public CompositeFigure(Image image, Clickable[] clickableArray) {
            ToolbarLayout toolbarLayout = new ToolbarLayout();
            toolbarLayout.setVertical(false);
            this.setLayoutManager((LayoutManager)toolbarLayout);
            this.setOpaque(false);
            ActorFigure.this.inputPorts = new InputPorts();
            this.add((IFigure)ActorFigure.this.inputPorts);
            ActorFigure.this.body = ActorFigure.this.generateBody(image, clickableArray);
            this.add(ActorFigure.this.body);
            ActorFigure.this.outputPorts = new OutputPorts();
            this.add((IFigure)ActorFigure.this.outputPorts);
        }

        public Dimension getMaximumSize() {
            return this.getPreferredSize(-1, -1);
        }

        public Dimension getPreferredSize(int n, int n2) {
            Vector<ConnectionAnchor> vector = ActorFigure.this.getTargetConnectionAnchors();
            Vector<ConnectionAnchor> vector2 = ActorFigure.this.getSourceConnectionAnchors();
            int n3 = Math.max(vector.size(), vector2.size());
            if (n3 > 0) {
                int n4 = n3 * 9 + (n3 > 1 ? (n3 - 1) * 3 : 0) + 20;
                if (n4 < 60) {
                    n4 = 60;
                }
                return new Dimension(60, n4);
            }
            return super.getMinimumSize();
        }
    }

    private class InputPorts
    extends Ports {
    }

    private class OutputPorts
    extends Ports {
    }

    private class Ports
    extends Figure {
        public Ports() {
            ToolbarLayout toolbarLayout = new ToolbarLayout();
            toolbarLayout.setVertical(true);
            toolbarLayout.setSpacing(3);
            this.setLayoutManager((LayoutManager)toolbarLayout);
            this.setOpaque(false);
            this.setBorder((Border)new PortsBorder());
        }
    }

    private class PortsBorder
    extends AbstractBorder {
        private PortsBorder() {
        }

        public Insets getInsets(IFigure iFigure) {
            return new Insets(10, 0, 0, 0);
        }

        public void paint(IFigure iFigure, Graphics graphics, Insets insets) {
        }
    }
}

