/*
 * Decompiled with CFR 0.152.
 */
package org.nexusformat;

import java.io.File;
import java.util.Hashtable;
import ncsa.hdf.hdflib.HDFArray;
import ncsa.hdf.hdflib.HDFException;
import org.nexusformat.AttributeEntry;
import org.nexusformat.NXlink;
import org.nexusformat.NeXusFileInterface;
import org.nexusformat.NexusException;

public class NexusFile
implements NeXusFileInterface {
    public static final int NXACC_READ = 1;
    public static final int NXACC_RDWR = 2;
    public static final int NXACC_CREATE = 3;
    public static final int NXACC_CREATE4 = 4;
    public static final int NXACC_CREATE5 = 5;
    public static final int NXACC_CREATEXML = 6;
    public static final int NXACC_NOSTRIP = 128;
    public static final int NX_UNLIMITED = -1;
    public static final int NX_FLOAT32 = 5;
    public static final int NX_FLOAT64 = 6;
    public static final int NX_INT8 = 20;
    public static final int NX_BINARY = 20;
    public static final int NX_UINT8 = 21;
    public static final int NX_BOOLEAN = 21;
    public static final int NX_INT16 = 22;
    public static final int NX_UINT16 = 23;
    public static final int NX_INT32 = 24;
    public static final int NX_UINT32 = 25;
    public static final int NX_INT64 = 26;
    public static final int NX_UINT64 = 27;
    public static final int NX_CHAR = 4;
    public static final int NX_COMP_NONE = 100;
    public static final int NX_COMP_LZW = 200;
    public static final int NX_COMP_RLE = 300;
    public static final int NX_COMP_HUF = 400;
    protected static final int MAXNAMELEN = 64;
    protected int handle;

    protected native int init(String var1, int var2);

    protected native void close(int var1);

    protected native int nxflush(int var1);

    public NexusFile(String string, int n) throws NexusException {
        this.checkForNull(string);
        this.handle = this.init(string, n);
        if (this.handle < 0) {
            throw new NexusException("Failed to open " + string);
        }
    }

    @Override
    public void flush() throws NexusException {
        if (this.handle < 0) {
            throw new NexusException("NAPI-ERROR: File not open");
        }
        this.handle = this.nxflush(this.handle);
    }

    @Override
    public void close() throws NexusException {
        if (this.handle >= 0) {
            this.close(this.handle);
            this.handle = -1;
        }
    }

    @Override
    public void finalize() throws Throwable {
        this.close();
    }

    protected native void nxmakegroup(int var1, String var2, String var3);

    protected native void nxopengroup(int var1, String var2, String var3);

    protected native void nxopenpath(int var1, String var2);

    protected native void nxopengrouppath(int var1, String var2);

    protected native void nxclosegroup(int var1);

    @Override
    public void makegroup(String string, String string2) throws NexusException {
        this.checkForNull(string, string2);
        if (this.handle < 0) {
            throw new NexusException("NAPI-ERROR: File not open");
        }
        this.nxmakegroup(this.handle, string, string2);
    }

    @Override
    public void opengroup(String string, String string2) throws NexusException {
        if (this.handle < 0) {
            throw new NexusException("NAPI-ERROR: File not open");
        }
        this.checkForNull(string, string2);
        this.nxopengroup(this.handle, string, string2);
    }

    @Override
    public void openpath(String string) throws NexusException {
        if (this.handle < 0) {
            throw new NexusException("NAPI-ERROR: File not open");
        }
        this.checkForNull(string);
        this.nxopenpath(this.handle, string);
    }

    @Override
    public void opengrouppath(String string) throws NexusException {
        if (this.handle < 0) {
            throw new NexusException("NAPI-ERROR: File not open");
        }
        this.checkForNull(string);
        this.nxopengrouppath(this.handle, string);
    }

    @Override
    public void closegroup() throws NexusException {
        if (this.handle < 0) {
            throw new NexusException("NAPI-ERROR: File not open");
        }
        this.nxclosegroup(this.handle);
    }

    protected native void nxmakedata(int var1, String var2, int var3, int var4, int[] var5);

    protected native void nxmakecompdata(int var1, String var2, int var3, int var4, int[] var5, int var6, int[] var7);

    protected native void nxopendata(int var1, String var2);

    protected native void nxclosedata(int var1);

    protected native void nxcompress(int var1, int var2);

    @Override
    public void compmakedata(String string, int n, int n2, int[] nArray, int n3, int[] nArray2) throws NexusException {
        if (this.handle < 0) {
            throw new NexusException("NAPI-ERROR: File not open");
        }
        this.checkType(n);
        this.checkForNull(string, n2, nArray2);
        this.checkForNegInIntArray(true, nArray, nArray2);
        switch (n3) {
            case 100: 
            case 200: {
                break;
            }
            default: {
                throw new NexusException("Invalid compression code requested");
            }
        }
        this.nxmakecompdata(this.handle, string, n, n2, nArray, n3, nArray2);
    }

    @Override
    public void makedata(String string, int n, int n2, int[] nArray) throws NexusException {
        if (this.handle < 0) {
            throw new NexusException("NAPI-ERROR: File not open");
        }
        this.checkType(n);
        this.checkForNull(string, nArray);
        this.checkForNegInIntArray(true, new int[][]{nArray});
        this.nxmakedata(this.handle, string, n, n2, nArray);
    }

    @Override
    public void opendata(String string) throws NexusException {
        if (this.handle < 0) {
            throw new NexusException("NAPI-ERROR: File not open");
        }
        this.checkForNull(string);
        this.nxopendata(this.handle, string);
    }

    @Override
    public void closedata() throws NexusException {
        if (this.handle < 0) {
            throw new NexusException("NAPI-ERROR: File not open");
        }
        this.nxclosedata(this.handle);
    }

    @Override
    public void compress(int n) throws NexusException {
        if (this.handle < 0) {
            throw new NexusException("NAPI-ERROR: File not open");
        }
        switch (n) {
            case 100: 
            case 200: 
            case 300: 
            case 400: {
                break;
            }
            default: {
                throw new NexusException("Invalid compression code requested");
            }
        }
        this.nxcompress(this.handle, n);
    }

    protected native void nxgetdata(int var1, byte[] var2);

    protected native void nxgetslab(int var1, int[] var2, int[] var3, byte[] var4);

    protected native void nxgetattr(int var1, String var2, byte[] var3, int[] var4);

    @Override
    public void getdata(Object object) throws NexusException {
        if (this.handle < 0) {
            throw new NexusException("NAPI-ERROR: File not open");
        }
        this.checkForNull(object);
        try {
            HDFArray hDFArray = new HDFArray(object);
            byte[] byArray = hDFArray.emptyBytes();
            this.nxgetdata(this.handle, byArray);
            object = hDFArray.arrayify(byArray);
        }
        catch (HDFException hDFException) {
            throw new NexusException(hDFException.getMessage());
        }
    }

    @Override
    public void getslab(int[] nArray, int[] nArray2, Object object) throws NexusException {
        if (this.handle < 0) {
            throw new NexusException("NAPI-ERROR: File not open");
        }
        this.checkForNull(nArray, nArray2, object);
        this.checkForNegInIntArray(false, nArray, nArray2);
        try {
            HDFArray hDFArray = new HDFArray(object);
            byte[] byArray = hDFArray.emptyBytes();
            this.nxgetslab(this.handle, nArray, nArray2, byArray);
            object = hDFArray.arrayify(byArray);
        }
        catch (HDFException hDFException) {
            throw new NexusException(hDFException.getMessage());
        }
    }

    @Override
    public void getattr(String string, Object object, int[] nArray) throws NexusException {
        if (this.handle < 0) {
            throw new NexusException("NAPI-ERROR: File not open");
        }
        this.checkForNull(string, object, nArray);
        this.checkType(nArray[1]);
        try {
            HDFArray hDFArray = new HDFArray(object);
            byte[] byArray = hDFArray.emptyBytes();
            this.nxgetattr(this.handle, string, byArray, nArray);
            object = hDFArray.arrayify(byArray);
        }
        catch (HDFException hDFException) {
            throw new NexusException(hDFException.getMessage());
        }
    }

    protected native void nxputdata(int var1, byte[] var2);

    protected native void nxputslab(int var1, byte[] var2, int[] var3, int[] var4);

    protected native void nxputattr(int var1, String var2, byte[] var3, int var4);

    @Override
    public void putdata(Object object) throws NexusException {
        byte[] byArray;
        if (this.handle < 0) {
            throw new NexusException("NAPI-ERROR: File not open");
        }
        this.checkForNull(object);
        try {
            HDFArray hDFArray = new HDFArray(object);
            byArray = hDFArray.byteify();
            hDFArray = null;
        }
        catch (HDFException hDFException) {
            throw new NexusException(hDFException.getMessage());
        }
        this.nxputdata(this.handle, byArray);
        byArray = null;
    }

    @Override
    public void putslab(Object object, int[] nArray, int[] nArray2) throws NexusException {
        byte[] byArray;
        if (this.handle < 0) {
            throw new NexusException("NAPI-ERROR: File not open");
        }
        this.checkForNull(object, nArray, nArray2);
        this.checkForNegInIntArray(false, nArray, nArray2);
        try {
            HDFArray hDFArray = new HDFArray(object);
            byArray = hDFArray.byteify();
            hDFArray = null;
        }
        catch (HDFException hDFException) {
            throw new NexusException(hDFException.getMessage());
        }
        this.nxputslab(this.handle, byArray, nArray, nArray2);
        byArray = null;
    }

    @Override
    public void putattr(String string, Object object, int n) throws NexusException {
        byte[] byArray;
        if (this.handle < 0) {
            throw new NexusException("NAPI-ERROR: File not open");
        }
        this.checkType(n);
        this.checkForNull(string, object);
        try {
            HDFArray hDFArray = new HDFArray(object);
            byArray = hDFArray.byteify();
            hDFArray = null;
        }
        catch (HDFException hDFException) {
            throw new NexusException(hDFException.getMessage());
        }
        this.nxputattr(this.handle, string, byArray, n);
        byArray = null;
    }

    protected native void nxgetinfo(int var1, int[] var2, int[] var3);

    protected native void nxsetnumberformat(int var1, int var2, String var3);

    protected native int nextentry(int var1, String[] var2);

    protected native int nextattr(int var1, String[] var2, int[] var3);

    @Override
    public void setnumberformat(int n, String string) throws NexusException {
        if (this.handle < 0) {
            throw new NexusException("NAPI-ERROR: File not open");
        }
        this.checkType(n);
        this.checkForNull(string);
        this.nxsetnumberformat(this.handle, n, string);
    }

    @Override
    public void getinfo(int[] nArray, int[] nArray2) throws NexusException {
        if (this.handle < 0) {
            throw new NexusException("NAPI-ERROR: File not open");
        }
        this.nxgetinfo(this.handle, nArray, nArray2);
    }

    @Override
    public Hashtable groupdir() throws NexusException {
        if (this.handle < 0) {
            throw new NexusException("NAPI-ERROR: File not open");
        }
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String[] stringArray = new String[2];
        while (this.nextentry(this.handle, stringArray) != -1) {
            hashtable.put(stringArray[0], stringArray[1]);
        }
        return hashtable;
    }

    @Override
    public Hashtable attrdir() throws NexusException {
        int[] nArray = new int[2];
        String[] stringArray = new String[1];
        Hashtable<String, AttributeEntry> hashtable = new Hashtable<String, AttributeEntry>();
        if (this.handle < 0) {
            throw new NexusException("NAPI-ERROR: File not open");
        }
        while (this.nextattr(this.handle, stringArray, nArray) != -1) {
            AttributeEntry attributeEntry = new AttributeEntry();
            attributeEntry.length = nArray[0];
            attributeEntry.type = nArray[1];
            hashtable.put(stringArray[0], attributeEntry);
        }
        return hashtable;
    }

    protected native void nxgetgroupid(int var1, NXlink var2);

    protected native void nxgetdataid(int var1, NXlink var2);

    protected native void nxmakelink(int var1, NXlink var2);

    protected native void nxmakenamedlink(int var1, String var2, NXlink var3);

    protected native void nxopensourcepath(int var1);

    @Override
    public NXlink getgroupID() throws NexusException {
        if (this.handle < 0) {
            throw new NexusException("NAPI-ERROR: File not open");
        }
        NXlink nXlink = new NXlink();
        this.nxgetgroupid(this.handle, nXlink);
        return nXlink;
    }

    @Override
    public NXlink getdataID() throws NexusException {
        if (this.handle < 0) {
            throw new NexusException("NAPI-ERROR: File not open");
        }
        NXlink nXlink = new NXlink();
        this.nxgetdataid(this.handle, nXlink);
        return nXlink;
    }

    @Override
    public void makelink(NXlink nXlink) throws NexusException {
        if (this.handle < 0) {
            throw new NexusException("NAPI-ERROR: File not open");
        }
        this.checkForNull(nXlink);
        this.nxmakelink(this.handle, nXlink);
    }

    @Override
    public void makenamedlink(String string, NXlink nXlink) throws NexusException {
        if (this.handle < 0) {
            throw new NexusException("NAPI-ERROR: File not open");
        }
        this.checkForNull(string, nXlink);
        this.nxmakenamedlink(this.handle, string, nXlink);
    }

    @Override
    public void opensourcepath() throws NexusException {
        if (this.handle < 0) {
            throw new NexusException("NAPI-ERROR: File not open");
        }
        this.nxopensourcepath(this.handle);
    }

    private void checkForNull(Object ... objectArray) {
        for (Object object : objectArray) {
            if (object != null) continue;
            throw new NullPointerException();
        }
    }

    private void checkForNegInIntArray(boolean bl, int[] ... nArray) {
        boolean bl2 = true;
        int[][] nArray2 = nArray;
        int n = nArray2.length;
        for (int i = 0; i < n; ++i) {
            int[] nArray3;
            for (int n2 : nArray3 = nArray2[i]) {
                if (n2 < 0) {
                    if (n2 != -1 || !bl || !bl2) {
                        throw new IllegalArgumentException("negative dimension received");
                    }
                }
                bl2 = false;
            }
        }
    }

    private void checkType(int n) throws NexusException {
        switch (n) {
            case 4: 
            case 5: 
            case 6: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                break;
            }
            default: {
                throw new NexusException("Illegal number type requested");
            }
        }
    }

    protected native void nxinquirefile(int var1, String[] var2);

    protected native void nxlinkexternal(int var1, String var2, String var3, String var4);

    protected native int nxisexternalgroup(int var1, String var2, String var3, String[] var4);

    @Override
    public String inquirefile() throws NexusException {
        if (this.handle < 0) {
            throw new NexusException("NAPI-ERROR: File not open");
        }
        String[] stringArray = new String[1];
        this.nxinquirefile(this.handle, stringArray);
        return stringArray[0];
    }

    @Override
    public void linkexternal(String string, String string2, String string3) throws NexusException {
        if (this.handle < 0) {
            throw new NexusException("NAPI-ERROR: File not open");
        }
        this.checkForNull(string, string2, string3);
        this.nxlinkexternal(this.handle, string, string2, string3);
    }

    @Override
    public String isexternalgroup(String string, String string2) throws NexusException {
        if (this.handle < 0) {
            throw new NexusException("NAPI-ERROR: File not open");
        }
        this.checkForNull(string, string2);
        String[] stringArray = new String[1];
        int n = this.nxisexternalgroup(this.handle, string, string2, stringArray);
        if (n == 1) {
            return stringArray[0];
        }
        return null;
    }

    public native void debugstop();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static {
        String string = null;
        string = System.getProperty("org.nexusformat.JNEXUSLIB", null);
        if (string != null && string.length() > 0) {
            File file = new File(string);
            if (!file.exists() || !file.canRead() || !file.isFile()) throw new UnsatisfiedLinkError("Invalid JNEXUS library");
            System.load(string);
            return;
        } else {
            System.loadLibrary("jnexus");
        }
    }
}

