/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.ui.hierarchy;

import com.python.pydev.ui.hierarchy.HierarchyNodeModel;
import com.python.pydev.ui.hierarchy.HierarchyNodeView;
import com.python.pydev.ui.hierarchy.HierarchyNodeViewListener;
import com.python.pydev.ui.hierarchy.HierarchyViewer;
import com.python.pydev.ui.hierarchy.TreeMouseListener;
import edu.umd.cs.piccolo.event.PInputEvent;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.part.ViewPart;
import org.python.pydev.core.IModule;
import org.python.pydev.editor.actions.PyOpenAction;
import org.python.pydev.editor.model.ItemPointer;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.ClassDef;
import org.python.pydev.parser.jython.ast.FunctionDef;
import org.python.pydev.parser.visitors.scope.ASTEntry;
import org.python.pydev.parser.visitors.scope.DefinitionsASTIteratorVisitor;
import org.python.pydev.plugin.PydevPlugin;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PyHierarchyView
extends ViewPart
implements HierarchyNodeViewListener {
    private static HierarchyViewer viewer;
    private MouseListener treeMouseListener;
    private Tree tree;
    private Object lock = new Object();

    public void createPartControl(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 2;
        parent.setLayout((Layout)layout);
        SashForm s = new SashForm(parent, 512);
        GridData layoutData = new GridData();
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.grabExcessVerticalSpace = true;
        layoutData.horizontalAlignment = 4;
        layoutData.verticalAlignment = 4;
        s.setLayoutData((Object)layoutData);
        parent = s;
        viewer = new HierarchyViewer(parent, 0);
        this.tree = new Tree(parent, 0);
        this.treeMouseListener = new TreeMouseListener(this.tree);
    }

    public void setHierarchy(HierarchyNodeModel model) {
        viewer.setHierarchy(model);
        HierarchyNodeView initial = null;
        for (HierarchyNodeView v : PyHierarchyView.viewer.allAdded) {
            v.addListener(this);
            if (v.model != model) continue;
            initial = v;
        }
        if (initial != null) {
            this.onClick(initial, null);
        }
    }

    public void setFocus() {
    }

    public void dispose() {
        super.dispose();
    }

    @Override
    public void onClick(final HierarchyNodeView view, PInputEvent event) {
        if (event != null && event.getClickCount() == 2) {
            IModule m = view.model.module;
            if (m != null && view.model.ast != null) {
                ItemPointer pointer = new ItemPointer((Object)m.getFile(), (SimpleNode)view.model.ast.name);
                new PyOpenAction().run(pointer);
            }
        } else {
            Runnable r = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Object object = PyHierarchyView.this.lock;
                    synchronized (object) {
                        ClassDef ast = view.model.ast;
                        if (ast != null) {
                            PyHierarchyView.this.tree.removeAll();
                            DefinitionsASTIteratorVisitor visitor = DefinitionsASTIteratorVisitor.create((SimpleNode)ast);
                            Iterator outline = visitor.getOutline();
                            HashMap c = new HashMap();
                            while (outline.hasNext()) {
                                ASTEntry entry = (ASTEntry)outline.next();
                                TreeItem item = null;
                                if (entry.node instanceof FunctionDef) {
                                    item = PyHierarchyView.this.createTreeItem(c, entry);
                                    item.setImage(PydevPlugin.getImageCache().get("icons/methpub_obj.gif"));
                                    if (view.model.module != null) {
                                        item.setData((Object)new ItemPointer((Object)view.model.module.getFile(), (SimpleNode)((FunctionDef)entry.node).name));
                                    }
                                } else if (entry.node instanceof ClassDef) {
                                    item = PyHierarchyView.this.createTreeItem(c, entry);
                                    item.setImage(PydevPlugin.getImageCache().get("icons/class_obj.gif"));
                                    if (view.model.module != null) {
                                        item.setData((Object)new ItemPointer((Object)view.model.module.getFile(), (SimpleNode)((ClassDef)entry.node).name));
                                    }
                                } else {
                                    item = PyHierarchyView.this.createTreeItem(c, entry);
                                    item.setImage(PydevPlugin.getImageCache().get("icons/attrpub_obj.gif"));
                                    if (view.model.module != null) {
                                        item.setData((Object)new ItemPointer((Object)view.model.module.getFile(), entry.node));
                                    }
                                }
                                item.setText(entry.getName());
                                item.setExpanded(true);
                                PyHierarchyView.this.tree.showItem(item);
                                PyHierarchyView.this.tree.addMouseListener(PyHierarchyView.this.treeMouseListener);
                            }
                        }
                    }
                }
            };
            Display.getDefault().asyncExec(r);
        }
    }

    private TreeItem createTreeItem(HashMap<SimpleNode, TreeItem> c, ASTEntry entry) {
        TreeItem parent = null;
        ASTEntry par = entry.parent;
        if (par != null) {
            parent = c.get(par.node);
        }
        TreeItem item = parent == null ? new TreeItem(this.tree, 0) : new TreeItem(parent, 0);
        c.put(entry.node, item);
        return item;
    }
}

