/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.ui.hierarchy;

import com.python.pydev.ui.hierarchy.HierarchyNodeModel;
import com.python.pydev.ui.hierarchy.HierarchyNodeViewListener;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolox.swt.PSWTCanvas;
import edu.umd.cs.piccolox.swt.PSWTImage;
import edu.umd.cs.piccolox.swt.PSWTPath;
import edu.umd.cs.piccolox.swt.PSWTText;
import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.graphics.Image;
import org.python.pydev.plugin.PydevPlugin;

public class HierarchyNodeView {
    public PSWTPath node;
    public HierarchyNodeModel model;
    public Color initialColor;
    public List<HierarchyNodeViewListener> listeners = new ArrayList<HierarchyNodeViewListener>();

    public HierarchyNodeView(PSWTCanvas canvas, HierarchyNodeModel model, double x, double y) {
        this(canvas, model, x, y, Color.WHITE);
    }

    protected void onClick(PInputEvent event) {
        Iterator<HierarchyNodeViewListener> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            HierarchyNodeViewListener l = iterator.next();
            l.onClick(this, event);
        }
    }

    public void addListener(HierarchyNodeViewListener l) {
        this.listeners.add(l);
    }

    public HierarchyNodeView(PSWTCanvas canvas, HierarchyNodeModel model, double x, double y, Color initialColor) {
        this.model = model;
        this.initialColor = initialColor;
        Image classImg = PydevPlugin.getImageCache().get("icons/class_obj.gif");
        PSWTImage img = new PSWTImage(canvas, classImg, false);
        img.translate(0.0 + x, 5.0 + y);
        Rectangle2D imgRect = img.getBounds().getBounds2D();
        PSWTText text = new PSWTText(model.name);
        Rectangle2D textRect = text.getBounds().getBounds2D();
        text.translate(imgRect.getWidth() + 2.0 + x, 0.0 + y);
        final PSWTPath rect = PSWTPath.createRectangle((float)(imgRect.getX() + x - 5.0), (float)(imgRect.getY() + y), (float)(imgRect.getWidth() + textRect.getWidth() + 2.0 + 10.0), (float)textRect.getHeight());
        rect.addChild(img);
        rect.addChild(text);
        rect.setPaint(this.initialColor);
        rect.addInputEventListener(new PBasicInputEventHandler(){
            long pressedOn = -1L;

            public void mouseEntered(PInputEvent event) {
                Color c = HierarchyNodeView.this.initialColor;
                Color c1 = new Color(c.getRed() - 20, c.getBlue() - 20, c.getGreen() - 20);
                rect.setPaint(c1);
            }

            public void mouseExited(PInputEvent event) {
                rect.setPaint(HierarchyNodeView.this.initialColor);
            }

            public void mousePressed(PInputEvent event) {
                this.pressedOn = System.currentTimeMillis();
            }

            public void mouseReleased(PInputEvent event) {
                long delta = System.currentTimeMillis() - this.pressedOn;
                if (delta < 200L) {
                    HierarchyNodeView.this.onClick(event);
                }
            }
        });
        this.node = rect;
    }

    public String toString() {
        return "Node View[" + this.model.name + "]";
    }

    public int hashCode() {
        return this.model.hashCode();
    }

    public boolean equals(Object obj) {
        return this.model.equals(((HierarchyNodeView)obj).model);
    }
}

